/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.codegen.def;

import dev.quantumfusion.hyphen.codegen.MethodHandler;
import dev.quantumfusion.hyphen.codegen.def.SerializerDef;

public class PrimitiveIODef
implements SerializerDef {
    protected final Class<?> primitive;
    protected final int size;

    public PrimitiveIODef(Class<?> primitive) {
        this.primitive = primitive;
        this.size = PrimitiveIODef.getSize(primitive);
    }

    public static int getSize(Class<?> primitive) {
        if (primitive == Boolean.TYPE || primitive == Byte.TYPE) {
            return 1;
        }
        if (primitive == Short.TYPE || primitive == Character.TYPE) {
            return 2;
        }
        if (primitive == Integer.TYPE || primitive == Float.TYPE) {
            return 4;
        }
        if (primitive == Long.TYPE || primitive == Double.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void writePut(MethodHandler mh, Runnable valueLoad) {
        mh.loadIO();
        valueLoad.run();
        mh.putIO(this.primitive);
    }

    @Override
    public void writeGet(MethodHandler mh) {
        mh.loadIO();
        mh.getIO(this.primitive);
    }

    @Override
    public int getStaticSize() {
        return this.size;
    }

    @Override
    public boolean hasDynamicSize() {
        return false;
    }
}

