/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.codegen;

import dev.quantumfusion.hyphen.ClassDefiner;
import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.Options;
import dev.quantumfusion.hyphen.codegen.MethodHandler;
import dev.quantumfusion.hyphen.codegen.MethodInfo;
import dev.quantumfusion.hyphen.codegen.def.MethodDef;
import dev.quantumfusion.hyphen.io.IOInterface;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.thr.HyphenException;
import dev.quantumfusion.hyphen.util.GenUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;

public class CodegenHandler<IO extends IOInterface, D> {
    public final Class<IO> ioClass;
    public final Class<D> dataClass;
    public final String self;
    public final EnumMap<Options, Boolean> options;
    @Nullable
    private final Map<MethodInfo, AtomicInteger> methodDedup;
    private final ClassWriter cw;
    private final ClassDefiner definer;

    public CodegenHandler(Class<IO> ioClass, Class<D> dataClass, String self, EnumMap<Options, Boolean> options, ClassDefiner definer) {
        this.ioClass = ioClass;
        this.dataClass = dataClass;
        this.self = self;
        this.options = options;
        this.definer = definer;
        this.methodDedup = this.options.get((Object)Options.SHORT_METHOD_NAMES) != false ? new HashMap() : null;
        this.cw = new ClassWriter(2);
        this.cw.visit(60, 17, this.self, null, GenUtil.internal(Object.class), new String[]{GenUtil.internal(HyphenSerializer.class)});
        try (MethodHandler mh = new MethodHandler(this.cw.visitMethod(1, "<init>", GenUtil.methodDesc(Void.TYPE, new Class[0]), null, null), this.self, dataClass, ioClass, true);){
            mh.visitIntInsn(25, 0);
            mh.callInst(183, Object.class, "<init>", Void.TYPE, new Class[0]);
            mh.op(177);
        }
        if (options.get((Object)Options.FAST_ALLOC).booleanValue()) {
            mh = new MethodHandler(this.cw.visitMethod(8, "<clinit>", GenUtil.methodDesc(Void.TYPE, new Class[0]), null, null), this.self, dataClass, ioClass, false);
            try {
                mh.visitTypeInsn(187, this.self);
                mh.op(89);
                mh.visitMethodInsn(183, this.self, "<init>", GenUtil.methodDesc(Void.TYPE, new Class[0]), false);
                mh.visitFieldInsn(179, ClassDefiner.class, "SERIALIZER", HyphenSerializer.class);
                mh.op(177);
            }
            finally {
                mh.close();
            }
        }
    }

    public MethodInfo createMethodInfo(Clazz clazz, String prefix, String suffix, Class<?> returnClass, Class<?> ... parameters) {
        MethodInfo info = new MethodInfo(GenUtil.makeSafe(prefix + clazz.toString() + suffix), returnClass, parameters);
        if (this.methodDedup != null) {
            info.setName(GenUtil.hyphenShortMethodName(this.methodDedup.computeIfAbsent(info, info1 -> new AtomicInteger(0)).getAndIncrement()));
        }
        return info;
    }

    public void writeMethods(Collection<MethodDef> methods) {
        for (MethodDef method : methods) {
            this.writeMethod(method, false);
        }
    }

    private void writeMethod(MethodDef def, boolean spark) {
        def.writeMethods(this, this::writeMethodInternal, spark);
    }

    private void writeMethodInternal(Clazz clazz, MethodInfo methodInfo, boolean spark, boolean synthetic, Consumer<MethodHandler> writer) {
        Class<?>[] parameters = methodInfo.parameters;
        try (MethodHandler mh = new MethodHandler(this.cw, methodInfo, this.self, this.dataClass, this.ioClass, this.options.get((Object)Options.SHORT_VARIABLE_NAMES), spark, synthetic);){
            int i;
            for (i = 0; i < parameters.length; ++i) {
                mh.addVar(MethodHandler.getParamName(i) + (spark ? "raw" : ""), spark ? Object.class : parameters[i]);
            }
            mh.visitCode();
            if (spark) {
                for (i = 0; i < parameters.length; ++i) {
                    Class<?> parameter = parameters[i];
                    String varName = MethodHandler.getParamName(i);
                    mh.addVar(varName, parameter);
                    mh.varOp(21, varName + "raw");
                    mh.typeOp(192, parameter);
                    mh.varOp(54, varName);
                }
            }
            try {
                writer.accept(mh);
            }
            catch (Throwable thr) {
                throw HyphenException.thr("class", "-", clazz.getDefinedClass().getSimpleName(), thr);
            }
            mh.op(Type.getType(methodInfo.returnClass).getOpcode(172));
            mh.visitEnd();
        }
        catch (Throwable throwable) {
            throw HyphenException.thr("method", "-", methodInfo.getName(), throwable);
        }
    }

    public void setupSpark(MethodDef spark) {
        spark.getInfo.setName("get");
        spark.putInfo.setName("put");
        spark.measureInfo.setName("measure");
        this.writeMethod(spark, true);
    }

    /*
     * Loose catch block
     */
    public synchronized <O extends HyphenSerializer<IO, D>> HyphenSerializer<IO, D> export(Path exportPath) {
        Class<?> def;
        block8: {
            byte[] bytes = this.cw.toByteArray();
            if (exportPath != null) {
                try {
                    Files.write(exportPath, bytes, StandardOpenOption.CREATE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            def = this.definer.def(this.self, bytes);
            if (!this.options.get((Object)Options.FAST_ALLOC).booleanValue()) break block8;
            return ClassDefiner.SERIALIZER;
            {
                catch (Throwable thr) {
                    CheckClassAdapter.verify((ClassReader)new ClassReader(bytes), (boolean)true, (PrintWriter)new PrintWriter(System.out));
                    throw thr;
                }
            }
        }
        try {
            Constructor<?> constructor = def.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (HyphenSerializer)constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static interface MethodWriter {
        public void writeMethod(Clazz var1, MethodInfo var2, boolean var3, boolean var4, Consumer<MethodHandler> var5);
    }
}

