/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen;

import dev.quantumfusion.hyphen.ClassDefiner;
import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.Options;
import dev.quantumfusion.hyphen.SerializerFactory;
import dev.quantumfusion.hyphen.codegen.CodegenHandler;
import dev.quantumfusion.hyphen.codegen.def.ArrayDef;
import dev.quantumfusion.hyphen.codegen.def.BoxedIODef;
import dev.quantumfusion.hyphen.codegen.def.ClassDef;
import dev.quantumfusion.hyphen.codegen.def.EnumDef;
import dev.quantumfusion.hyphen.codegen.def.ListDef;
import dev.quantumfusion.hyphen.codegen.def.MapDef;
import dev.quantumfusion.hyphen.codegen.def.MethodDef;
import dev.quantumfusion.hyphen.codegen.def.PrimitiveArrayIODef;
import dev.quantumfusion.hyphen.codegen.def.PrimitiveIODef;
import dev.quantumfusion.hyphen.codegen.def.SerializerDef;
import dev.quantumfusion.hyphen.codegen.def.SetDef;
import dev.quantumfusion.hyphen.codegen.def.StringIODef;
import dev.quantumfusion.hyphen.codegen.def.SubclassDef;
import dev.quantumfusion.hyphen.io.IOInterface;
import dev.quantumfusion.hyphen.scan.annotations.DataSubclasses;
import dev.quantumfusion.hyphen.scan.type.ArrayClazz;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.scan.type.ParaClazz;
import dev.quantumfusion.hyphen.scan.type.TypeClazz;
import dev.quantumfusion.hyphen.scan.type.UnknownClazz;
import dev.quantumfusion.hyphen.thr.HyphenException;
import dev.quantumfusion.hyphen.thr.UnknownTypeException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class SerializerHandler<IO extends IOInterface, D> {
    private static final Map<Class<?>, SerializerFactory.DynamicDefFactory> BUILD_IN_DEFINITIONS = new HashMap();
    public final EnumMap<Options, Boolean> options;
    public final Class<D> dataClass;
    public final Class<IO> ioClass;
    public final boolean debug;
    public final Map<Class<?>, SerializerFactory.DynamicDefFactory> definitions;
    public final Map<Object, Map<Class<? extends Annotation>, Object>> globalAnnotations;
    public final Map<Clazz, SerializerDef> scanDeduplicationMap = new HashMap<Clazz, SerializerDef>();
    public final Map<Clazz, MethodDef> methods = new HashMap<Clazz, MethodDef>();
    public ClassDefiner definer = new ClassDefiner(Thread.currentThread().getContextClassLoader());
    public CodegenHandler<IO, D> codegenHandler;
    public String name = "HyphenSerializer";
    public Path exportPath = null;

    public SerializerHandler(Class<IO> ioClass, Class<D> dataClass, boolean debug) {
        this.options = new EnumMap(Options.class);
        for (Options value : Options.values()) {
            this.options.put(value, value.defaultValue);
        }
        this.dataClass = dataClass;
        this.ioClass = ioClass;
        this.debug = debug;
        if (debug) {
            this.options.put(Options.SHORT_METHOD_NAMES, false);
            this.options.put(Options.SHORT_VARIABLE_NAMES, false);
        }
        this.definitions = new HashMap(BUILD_IN_DEFINITIONS);
        this.globalAnnotations = new HashMap<Object, Map<Class<? extends Annotation>, Object>>();
    }

    private static void addStaticDef(Function<Class<?>, SerializerDef> creator, Class<?> ... clazz) {
        for (Class<?> aClass : clazz) {
            BUILD_IN_DEFINITIONS.put(aClass, (c, sh) -> (SerializerDef)creator.apply(aClass));
        }
    }

    private static void addDynamicDef(SerializerFactory.DynamicDefFactory creator, Class<?> ... clazz) {
        for (Class<?> aClass : clazz) {
            BUILD_IN_DEFINITIONS.put(aClass, creator);
        }
    }

    public SerializerDef acquireDef(Clazz clazz) {
        if (this.methods.containsKey(clazz)) {
            return this.methods.get(clazz);
        }
        this.checkDefined(clazz);
        Clazz clazz2 = clazz;
        if (clazz2 instanceof TypeClazz) {
            TypeClazz t = (TypeClazz)clazz2;
            return this.acquireDef(t.getDefined());
        }
        if (this.scanDeduplicationMap.containsKey(clazz)) {
            return this.scanDeduplicationMap.get(clazz);
        }
        SerializerDef serializerDef = this.acquireDefNew(clazz);
        SerializerDef serializerDef2 = serializerDef;
        if (serializerDef2 instanceof MethodDef) {
            MethodDef methodDef = (MethodDef)serializerDef2;
            methodDef.scan(this, clazz);
            this.methods.put(clazz, methodDef);
        }
        return serializerDef;
    }

    private SerializerDef acquireDefNew(Clazz clazz) {
        Class<?> definedClass = clazz.getDefinedClass();
        if (this.definitions.containsKey(definedClass)) {
            return this.definitions.get(definedClass).create(clazz, this);
        }
        MethodDef methodDef = this.acquireDefNewMethod(clazz);
        this.scanDeduplicationMap.put(clazz, methodDef);
        return methodDef;
    }

    private MethodDef acquireDefNewMethod(Clazz clazz) {
        if (clazz.containsAnnotation(DataSubclasses.class)) {
            return new SubclassDef(this, clazz, (Class[])clazz.getAnnotationValue(DataSubclasses.class));
        }
        Clazz clazz2 = clazz;
        if (clazz2 instanceof ArrayClazz) {
            ArrayClazz arrayClazz = (ArrayClazz)clazz2;
            return new ArrayDef(this, arrayClazz);
        }
        if (clazz.getDefinedClass().isEnum()) {
            return new EnumDef(this, clazz);
        }
        return new ClassDef(this, clazz);
    }

    private void checkDefined(Clazz clazz) {
        if (clazz == UnknownClazz.UNKNOWN) {
            throw new UnknownTypeException("Type could not be identified", "Check the Path for the source of \"UNKNOWN\" which is when a type is not known");
        }
        Clazz clazz2 = clazz;
        if (clazz2 instanceof TypeClazz) {
            TypeClazz t = (TypeClazz)clazz2;
            if (t.defined == UnknownClazz.UNKNOWN) {
                throw new UnknownTypeException("Type " + t.typeName + " could not be identified", "Trace the path of \"" + t.typeName + "\" in the path below. And see if you can define that path.");
            }
        }
    }

    private MethodDef scan() {
        Clazz clazz = new Clazz(this, this.dataClass);
        MethodDef methodDef = this.acquireDefNewMethod(clazz);
        methodDef.scan(this, clazz);
        return methodDef;
    }

    public HyphenSerializer<IO, D> build() {
        try {
            this.codegenHandler = new CodegenHandler<IO, D>(this.ioClass, this.dataClass, this.name, this.options, this.definer);
            this.codegenHandler.setupSpark(this.scan());
            this.codegenHandler.writeMethods(this.methods.values());
            return this.codegenHandler.export(this.exportPath);
        }
        catch (Throwable throwable) {
            HyphenException he;
            Throwable throwable2 = throwable;
            HyphenException hyphenException = throwable2 instanceof HyphenException ? (he = (HyphenException)throwable2) : new HyphenException(throwable, null);
            throw hyphenException;
        }
    }

    static {
        SerializerHandler.addStaticDef(PrimitiveIODef::new, Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        SerializerHandler.addDynamicDef(PrimitiveArrayIODef::new, boolean[].class, byte[].class, short[].class, char[].class, int[].class, float[].class, long[].class, double[].class);
        SerializerHandler.addStaticDef(BoxedIODef::new, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class);
        BUILD_IN_DEFINITIONS.put(String.class, (c, sh) -> new StringIODef());
        BUILD_IN_DEFINITIONS.put(List.class, (c, sh) -> new ListDef(sh, (ParaClazz)c));
        BUILD_IN_DEFINITIONS.put(Map.class, (c, sh) -> new MapDef(sh, (ParaClazz)c));
        BUILD_IN_DEFINITIONS.put(Set.class, (c, sh) -> new SetDef(sh, (ParaClazz)c));
    }
}

