/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen;

import dev.quantumfusion.hyphen.ClassDefiner;
import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.Options;
import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.codegen.def.SerializerDef;
import dev.quantumfusion.hyphen.io.IOInterface;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.util.ScanUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;

public class SerializerFactory<IO extends IOInterface, D> {
    private final SerializerHandler<IO, D> sh;

    private SerializerFactory(Class<IO> ioClass, Class<D> dataClass, boolean debug) {
        this.sh = new SerializerHandler<IO, D>(ioClass, dataClass, debug);
    }

    public static <IO extends IOInterface, D> SerializerFactory<IO, D> create(Class<IO> ioClass, Class<D> dataClass) {
        return new SerializerFactory<IO, D>(ioClass, dataClass, false);
    }

    public static <IO extends IOInterface, D> SerializerFactory<IO, D> createDebug(Class<IO> ioClass, Class<D> dataClass) {
        return new SerializerFactory<IO, D>(ioClass, dataClass, true);
    }

    public void setOption(Options option, Boolean value) {
        this.sh.options.put(option, value);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.sh.definer = new ClassDefiner(classLoader);
    }

    public void setClassName(String name) {
        this.sh.name = name;
    }

    public void setExportPath(Path path) {
        this.sh.exportPath = path;
    }

    public void setExportDir(Path path) {
        this.setExportPath(path.resolve(this.sh.name + ".class"));
    }

    public void addStaticDef(Class<?> target, SerializerDef def) {
        this.sh.definitions.put(target, (clazz, sh) -> def);
    }

    public void addDynamicDef(Class<?> target, DynamicDefFactory factory) {
        this.sh.definitions.put(target, factory);
    }

    public void addGlobalAnnotation(String id, Class<? extends Annotation> annotation, Object value) {
        this.addGlobalAnnotationInternal(id, annotation, value);
    }

    public void addGlobalAnnotation(Class<?> clazz, Class<? extends Annotation> annotation, Object value) {
        this.addGlobalAnnotationInternal(clazz, annotation, value);
    }

    private void addGlobalAnnotationInternal(Object id, Class<? extends Annotation> annotation, Object value) {
        Method valueGetter = ScanUtil.getAnnotationValueGetter(annotation);
        if (valueGetter != null) {
            Class<?> returnType = valueGetter.getReturnType();
            Class<?> valueType = value.getClass();
            if (valueType != returnType) {
                throw new RuntimeException("Annotation " + annotation.getSimpleName() + " value type " + returnType.getSimpleName() + " does not match parameter " + valueType.getSimpleName());
            }
        }
        this.sh.globalAnnotations.computeIfAbsent(id, s -> new HashMap()).put(annotation, value);
    }

    public HyphenSerializer<IO, D> build() {
        return this.sh.build();
    }

    @FunctionalInterface
    public static interface DynamicDefFactory {
        public SerializerDef create(Clazz var1, SerializerHandler<?, ?> var2);
    }
}

