/*
 * Decompiled with CFR 0.152.
 */
package dev.profunktor.redis4cats;

import dev.profunktor.redis4cats.effects;
import dev.profunktor.redis4cats.effects$Distance$;
import dev.profunktor.redis4cats.effects$GeoCoordinate$;
import dev.profunktor.redis4cats.effects$GeoHash$;
import dev.profunktor.redis4cats.effects$GeoRadiusResult$;
import dev.profunktor.redis4cats.effects$Score$;
import dev.profunktor.redis4cats.effects$ScoreWithValue$;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.Range;
import io.lettuce.core.ScoredValue;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public interface RedisConversionOps {
    public static GeoRadiusResultOps GeoRadiusResultOps$(RedisConversionOps $this, GeoWithin v) {
        return $this.GeoRadiusResultOps(v);
    }

    default public <V> GeoRadiusResultOps<V> GeoRadiusResultOps(GeoWithin<V> v) {
        return new GeoRadiusResultOps<V>(this, v);
    }

    public static GeoRadiusKeyStorageOps GeoRadiusKeyStorageOps$(RedisConversionOps $this, effects.GeoRadiusKeyStorage v) {
        return $this.GeoRadiusKeyStorageOps(v);
    }

    default public <K> GeoRadiusKeyStorageOps<K> GeoRadiusKeyStorageOps(effects.GeoRadiusKeyStorage<K> v) {
        return new GeoRadiusKeyStorageOps<K>(this, v);
    }

    public static GeoRadiusDistStorageOps GeoRadiusDistStorageOps$(RedisConversionOps $this, effects.GeoRadiusDistStorage v) {
        return $this.GeoRadiusDistStorageOps(v);
    }

    default public <K> GeoRadiusDistStorageOps<K> GeoRadiusDistStorageOps(effects.GeoRadiusDistStorage<K> v) {
        return new GeoRadiusDistStorageOps<K>(this, v);
    }

    public static ZRangeOps ZRangeOps$(RedisConversionOps $this, effects.ZRange range, Numeric evidence$21) {
        return $this.ZRangeOps(range, evidence$21);
    }

    default public <T> ZRangeOps<T> ZRangeOps(effects.ZRange<T> range, Numeric<T> evidence$21) {
        return new ZRangeOps<T>(this, range, evidence$21);
    }

    public static ScoredValuesOps ScoredValuesOps$(RedisConversionOps $this, ScoredValue v) {
        return $this.ScoredValuesOps(v);
    }

    default public <V> ScoredValuesOps<V> ScoredValuesOps(ScoredValue<V> v) {
        return new ScoredValuesOps<V>(this, v);
    }

    public static DurationOps DurationOps$(RedisConversionOps $this, Duration d) {
        return $this.DurationOps(d);
    }

    default public DurationOps DurationOps(Duration d) {
        return new DurationOps(this, d);
    }

    public class DurationOps {
        private final Duration d;
        private final RedisConversionOps $outer;

        public DurationOps(RedisConversionOps $outer, Duration d) {
            this.d = d;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public long toSecondsOrZero() {
            long l;
            Duration duration = this.d;
            if (duration instanceof Duration.Infinite) {
                l = 0L;
            } else if (duration instanceof FiniteDuration) {
                FiniteDuration duration2 = (FiniteDuration)duration;
                l = duration2.toSeconds();
            } else {
                throw new MatchError((Object)duration);
            }
            return l;
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$DurationOps$$$outer() {
            return this.$outer;
        }
    }

    public class GeoRadiusDistStorageOps<K> {
        private final effects.GeoRadiusDistStorage<K> v;
        private final RedisConversionOps $outer;

        public <K> GeoRadiusDistStorageOps(RedisConversionOps $outer, effects.GeoRadiusDistStorage<K> v) {
            this.v = v;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        /*
         * WARNING - void declaration
         */
        public GeoRadiusStoreArgs<K> asGeoRadiusStoreArgs() {
            void var1_1;
            GeoRadiusStoreArgs store = GeoRadiusStoreArgs.Builder.withStoreDist(this.v.key()).withCount(this.v.count());
            return var1_1;
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$GeoRadiusDistStorageOps$$$outer() {
            return this.$outer;
        }
    }

    public class GeoRadiusKeyStorageOps<K> {
        private final effects.GeoRadiusKeyStorage<K> v;
        private final RedisConversionOps $outer;

        public <K> GeoRadiusKeyStorageOps(RedisConversionOps $outer, effects.GeoRadiusKeyStorage<K> v) {
            this.v = v;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        /*
         * WARNING - void declaration
         */
        public GeoRadiusStoreArgs<K> asGeoRadiusStoreArgs() {
            void var1_1;
            GeoRadiusStoreArgs store = GeoRadiusStoreArgs.Builder.store(this.v.key()).withCount(this.v.count());
            return var1_1;
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$GeoRadiusKeyStorageOps$$$outer() {
            return this.$outer;
        }
    }

    public class GeoRadiusResultOps<V> {
        private final GeoWithin<V> v;
        private final RedisConversionOps $outer;

        public <V> GeoRadiusResultOps(RedisConversionOps $outer, GeoWithin<V> v) {
            this.v = v;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public effects.GeoRadiusResult<V> asGeoRadiusResult() {
            return effects$GeoRadiusResult$.MODULE$.apply(this.v.getMember(), effects$Distance$.MODULE$.apply(Predef$.MODULE$.Double2double(this.v.getDistance())), effects$GeoHash$.MODULE$.apply(Predef$.MODULE$.Long2long(this.v.getGeohash())), effects$GeoCoordinate$.MODULE$.apply(this.v.getCoordinates().getX().doubleValue(), this.v.getCoordinates().getY().doubleValue()));
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$GeoRadiusResultOps$$$outer() {
            return this.$outer;
        }
    }

    public class ScoredValuesOps<V> {
        private final ScoredValue<V> v;
        private final RedisConversionOps $outer;

        public <V> ScoredValuesOps(RedisConversionOps $outer, ScoredValue<V> v) {
            this.v = v;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public effects.ScoreWithValue<V> asScoreWithValues() {
            return effects$ScoreWithValue$.MODULE$.apply(effects$Score$.MODULE$.apply(this.v.getScore()), this.v.getValue());
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$ScoredValuesOps$$$outer() {
            return this.$outer;
        }
    }

    public class ZRangeOps<T> {
        private final effects.ZRange<T> range;
        private final Numeric<T> evidence$21;
        private final RedisConversionOps $outer;

        public <T> ZRangeOps(RedisConversionOps $outer, effects.ZRange<T> range, Numeric<T> evidence$21) {
            this.range = range;
            this.evidence$21 = evidence$21;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Range<Number> asJavaRange() {
            Number start = this.toJavaNumber$1(this.range.start());
            Number end = this.toJavaNumber$1(this.range.end());
            return Range.create((Object)start, (Object)end);
        }

        public final RedisConversionOps dev$profunktor$redis4cats$RedisConversionOps$ZRangeOps$$$outer() {
            return this.$outer;
        }

        private final Number toJavaNumber$1(Object t) {
            Number number;
            Object object = t;
            if (object instanceof Byte) {
                Object b = BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)object));
                number = Predef$.MODULE$.byte2Byte(BoxesRunTime.unboxToByte((Object)b));
            } else if (object instanceof Short) {
                Object s = BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)object));
                number = Predef$.MODULE$.short2Short(BoxesRunTime.unboxToShort((Object)s));
            } else if (object instanceof Integer) {
                Object i = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)object));
                number = Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i));
            } else if (object instanceof Long) {
                Object l = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)object));
                number = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)l));
            } else if (object instanceof Float) {
                Object f = BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)object));
                number = Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)f));
            } else {
                number = Predef$.MODULE$.double2Double(((Numeric)Predef$.MODULE$.implicitly(this.evidence$21)).toDouble(t));
            }
            return number;
        }
    }
}

