/*
 * Decompiled with CFR 0.152.
 */
package dev.profunktor.redis4cats;

import cats.Applicative$;
import cats.data.NonEmptyList;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import dev.profunktor.redis4cats.JavaConversions$;
import dev.profunktor.redis4cats.RedisCommands;
import dev.profunktor.redis4cats.RedisConversionOps;
import dev.profunktor.redis4cats.connection.RedisConnection;
import dev.profunktor.redis4cats.data;
import dev.profunktor.redis4cats.effect.JRFuture$;
import dev.profunktor.redis4cats.effect.Log;
import dev.profunktor.redis4cats.effect.RedisExecutor;
import dev.profunktor.redis4cats.effect.RedisExecutor$;
import dev.profunktor.redis4cats.effects;
import dev.profunktor.redis4cats.effects$GeoCoordinate$;
import dev.profunktor.redis4cats.effects$SetArg$Existence$Nx$;
import dev.profunktor.redis4cats.effects$SetArg$Existence$Xx$;
import dev.profunktor.redis4cats.effects$SetArg$Ttl$Ex$;
import dev.profunktor.redis4cats.effects$SetArg$Ttl$Px$;
import dev.profunktor.redis4cats.transactions$TransactionDiscarded$;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.KeyValue;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.SetArgs;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class BaseRedis<F, K, V>
implements RedisCommands<F, K, V>,
RedisConversionOps {
    private final RedisConnection conn;
    private final boolean cluster;
    private final Concurrent<F> evidence$1;
    private final ContextShift<F> evidence$2;
    private final RedisExecutor<F> evidence$3;
    private final Log<F> evidence$4;
    private final Object ping;
    private final Object flushAll;
    private final Object flushAllAsync;

    public <F, K, V> BaseRedis(RedisConnection<F, K, V> conn, boolean cluster, Concurrent<F> evidence$1, ContextShift<F> evidence$2, RedisExecutor<F> evidence$3, Log<F> evidence$4) {
        this.conn = conn;
        this.cluster = cluster;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.evidence$4 = evidence$4;
        this.ping = JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply((Sync)evidence$1).delay(() -> BaseRedis.$init$$$anonfun$4$$anonfun$1(c))), evidence$1, evidence$2, evidence$3, evidence$4).futureLift();
        this.flushAll = package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply((Sync)evidence$1).delay(() -> BaseRedis.$init$$$anonfun$5$$anonfun$1(c))), evidence$1, evidence$2, evidence$3, evidence$4).futureLift(), evidence$1).void();
        this.flushAllAsync = package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply((Sync)evidence$1).delay(() -> BaseRedis.$init$$$anonfun$6$$anonfun$1(c))), evidence$1, evidence$2, evidence$3, evidence$4).futureLift(), evidence$1).void();
    }

    public RedisConnection<F, K, V> conn() {
        return this.conn;
    }

    public boolean cluster() {
        return this.cluster;
    }

    public <G> RedisCommands<G, K, V> liftK(Concurrent<G> evidence$13, ContextShift<G> evidence$14, Log<G> evidence$15) {
        RedisExecutor redisEcG = RedisExecutor$.MODULE$.apply(this.evidence$3).liftK(evidence$13, evidence$14);
        return new BaseRedis<G, K, V>(this.conn().liftK(evidence$13, evidence$14), this.cluster(), evidence$13, evidence$14, redisEcG, evidence$15);
    }

    public F async() {
        return (F)(this.cluster() ? this.conn().clusterAsync() : package.all$.MODULE$.toFunctorOps(this.conn().async(), this.evidence$1).widen());
    }

    public F sync() {
        return (F)(this.cluster() ? this.conn().clusterSync() : package.all$.MODULE$.toFunctorOps(this.conn().sync(), this.evidence$1).widen());
    }

    @Override
    public F del(Seq<K> key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.del$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F exists(Seq<K> key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.exists$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> BoxesRunTime.equals((Object)x, (Object)BoxesRunTime.boxToLong((long)key.size())));
    }

    @Override
    public F expire(K key, FiniteDuration expiresIn) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> {
            Object object;
            block7: {
                block3: {
                    TimeUnit timeUnit;
                    block6: {
                        TimeUnit timeUnit2;
                        TimeUnit timeUnit3;
                        block5: {
                            block4: {
                                TimeUnit timeUnit4;
                                TimeUnit timeUnit5;
                                block2: {
                                    timeUnit = expiresIn.unit();
                                    timeUnit5 = TimeUnit.MILLISECONDS;
                                    timeUnit4 = timeUnit;
                                    if (timeUnit5 != null) break block2;
                                    if (timeUnit4 == null) break block3;
                                    break block4;
                                }
                                if (((Object)((Object)timeUnit5)).equals((Object)timeUnit4)) break block3;
                            }
                            timeUnit3 = TimeUnit.MICROSECONDS;
                            timeUnit2 = timeUnit;
                            if (timeUnit3 != null) break block5;
                            if (timeUnit2 == null) break block3;
                            break block6;
                        }
                        if (((Object)((Object)timeUnit3)).equals((Object)timeUnit2)) break block3;
                    }
                    TimeUnit timeUnit6 = TimeUnit.NANOSECONDS;
                    TimeUnit timeUnit7 = timeUnit;
                    if (timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null) break block7;
                }
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.expire$$anonfun$3$$anonfun$1(key, expiresIn, c));
                return object;
            }
            object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.expire$$anonfun$4$$anonfun$2(key, expiresIn, c));
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F expireAt(K key, Instant at) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.expireAt$$anonfun$3$$anonfun$1(key, at, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F objectIdletime(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.objectIdletime$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            Option option;
            Long l = x$1;
            if (l == null) {
                option = package.all$.MODULE$.none();
            } else {
                Long d = l;
                FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxOptionId((Object)FiniteDuration$.MODULE$.apply(Predef$.MODULE$.Long2long(d), TimeUnit.SECONDS));
                option = OptionIdOps$.MODULE$.some$extension((Object)finiteDuration);
            }
            return option;
        });
    }

    private Option<FiniteDuration> toFiniteDuration(Long duration) {
        Option option;
        Long l = duration;
        Long d = l;
        if (Predef$.MODULE$.Long2long(d) < 0L) {
            option = package.all$.MODULE$.none();
        } else {
            Long d2 = l;
            FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxOptionId((Object)FiniteDuration$.MODULE$.apply(Predef$.MODULE$.Long2long(d2), TimeUnit.SECONDS));
            option = OptionIdOps$.MODULE$.some$extension((Object)finiteDuration);
        }
        return option;
    }

    @Override
    public F ttl(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.ttl$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)duration -> this.toFiniteDuration((Long)duration));
    }

    @Override
    public F pttl(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.pttl$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)duration -> this.toFiniteDuration((Long)duration));
    }

    @Override
    public F scan() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$13$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F scan(long cursor) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$14$$anonfun$1(cursor, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F scan(data.KeyScanCursor<K> previous) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$15$$anonfun$1(previous, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F scan(effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$16$$anonfun$1(scanArgs, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F scan(long cursor, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$17$$anonfun$1(cursor, scanArgs, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F scan(data.KeyScanCursor<K> previous, effects.ScanArgs scanArgs) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scan$$anonfun$18$$anonfun$1(previous, scanArgs, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)underlying -> data.KeyScanCursor$.MODULE$.apply(underlying));
    }

    @Override
    public F multi() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c2 = (RedisAsyncCommands)redisClusterAsyncCommands;
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.multi$$anonfun$2$$anonfun$1(c2));
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.multi$$anonfun$3$$anonfun$2$$anonfun$1(c)));
            }
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F exec() {
        return (F)package.all$.MODULE$.toFlatMapOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c2 = (RedisAsyncCommands)redisClusterAsyncCommands;
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.exec$$anonfun$3$$anonfun$1(c2));
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.exec$$anonfun$4$$anonfun$2$$anonfun$1(c)));
            }
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            TransactionResult transactionResult = x$1;
            TransactionResult res = transactionResult;
            if (res.wasDiscarded() || res.isEmpty()) {
                transactions$TransactionDiscarded$ transactions$TransactionDiscarded$2 = (transactions$TransactionDiscarded$)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)transactions$TransactionDiscarded$.MODULE$);
                object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)transactions$TransactionDiscarded$2, this.evidence$1);
            } else {
                object = Applicative$.MODULE$.apply(this.evidence$1).unit();
            }
            return object;
        });
    }

    @Override
    public F discard() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c2 = (RedisAsyncCommands)redisClusterAsyncCommands;
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.discard$$anonfun$2$$anonfun$1(c2));
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.discard$$anonfun$3$$anonfun$2$$anonfun$1(c)));
            }
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F watch(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c2 = (RedisAsyncCommands)redisClusterAsyncCommands;
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.watch$$anonfun$2$$anonfun$1(keys, c2));
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.watch$$anonfun$3$$anonfun$2$$anonfun$1(keys, c)));
            }
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F unwatch() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            RedisClusterAsyncCommands redisClusterAsyncCommands = x$1;
            if (redisClusterAsyncCommands instanceof RedisAsyncCommands) {
                RedisAsyncCommands c2 = (RedisAsyncCommands)redisClusterAsyncCommands;
                object = RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.unwatch$$anonfun$2$$anonfun$1(c2));
            } else {
                object = package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.unwatch$$anonfun$3$$anonfun$2$$anonfun$1(c)));
            }
            return object;
        }), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F enableAutoFlush() {
        return (F)RedisExecutor$.MODULE$.apply(this.evidence$3).eval(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> BaseRedis.enableAutoFlush$$anonfun$2$$anonfun$1(c)))));
    }

    @Override
    public F disableAutoFlush() {
        return (F)RedisExecutor$.MODULE$.apply(this.evidence$3).eval(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> BaseRedis.disableAutoFlush$$anonfun$2$$anonfun$1(c)))));
    }

    @Override
    public F flushCommands() {
        return (F)RedisExecutor$.MODULE$.apply(this.evidence$3).eval(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> BaseRedis.flushCommands$$anonfun$2$$anonfun$1(c)))));
    }

    @Override
    public F append(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.append$$anonfun$2$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F getSet(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.getSet$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F set(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.set$$anonfun$6$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F set(K key, V value, effects.SetArgs setArgs) {
        SetArgs jSetArgs = new SetArgs();
        setArgs.existence().foreach((Function1 & Serializable)x$1 -> {
            SetArgs setArgs;
            effects.SetArg.Existence existence = x$1;
            if (effects$SetArg$Existence$Nx$.MODULE$.equals(existence)) {
                setArgs = jSetArgs.nx();
            } else if (effects$SetArg$Existence$Xx$.MODULE$.equals(existence)) {
                setArgs = jSetArgs.xx();
            } else {
                throw new MatchError((Object)existence);
            }
            return setArgs;
        });
        setArgs.ttl().foreach((Function1 & Serializable)x$1 -> {
            SetArgs setArgs;
            effects.SetArg.Ttl ttl = x$1;
            if (ttl instanceof effects.SetArg.Ttl.Px) {
                FiniteDuration finiteDuration;
                effects.SetArg.Ttl.Px px = effects$SetArg$Ttl$Px$.MODULE$.unapply((effects.SetArg.Ttl.Px)ttl);
                FiniteDuration d = finiteDuration = px._1();
                setArgs = jSetArgs.px(d.toMillis());
            } else if (ttl instanceof effects.SetArg.Ttl.Ex) {
                FiniteDuration finiteDuration;
                effects.SetArg.Ttl.Ex ex = effects$SetArg$Ttl$Ex$.MODULE$.unapply((effects.SetArg.Ttl.Ex)ttl);
                FiniteDuration d = finiteDuration = ex._1();
                setArgs = jSetArgs.ex(d.toSeconds());
            } else {
                throw new MatchError((Object)ttl);
            }
            return setArgs;
        });
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.set$$anonfun$7$$anonfun$1(key, value, jSetArgs, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$11 -> {
            String string = _$11;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public F setNx(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.setNx$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F setEx(K key, V value, FiniteDuration expiresIn) {
        TimeUnit timeUnit = expiresIn.unit();
        TimeUnit timeUnit2 = TimeUnit.MILLISECONDS;
        TimeUnit timeUnit3 = timeUnit;
        Object command = !(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null) ? package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$24$$anonfun$1(key, value, expiresIn, c))) : package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$25$$anonfun$1(key, value, expiresIn, c)));
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(command, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F setRange(K key, V value, long offset) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.setRange$$anonfun$2$$anonfun$1(key, value, offset, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F decr(K key, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.decr$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F decrBy(K key, long amount, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.decrBy$$anonfun$3$$anonfun$1(key, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F incr(K key, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.incr$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F incrBy(K key, long amount, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.incrBy$$anonfun$3$$anonfun$1(key, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F incrByFloat(K key, double amount, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.incrByFloat$$anonfun$3$$anonfun$1(key, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F get(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.get$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F getBit(K key, long offset) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.getBit$$anonfun$3$$anonfun$1(key, offset, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F getRange(K key, long start, long end) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.getRange$$anonfun$3$$anonfun$1(key, start, end, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F strLen(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.strLen$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F mGet(Set<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.mGet$$anonfun$3$$anonfun$1(keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$12 -> JavaConversions$.MODULE$.ListHasAsScala(_$12).asScala().toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(KeyValue x) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                return kv.hasValue();
            }

            public final Object applyOrElse(KeyValue x, Function1 function1) {
                Object object;
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                if (kv.hasValue()) {
                    Object object2 = Predef$.MODULE$.ArrowAssoc(kv.getKey());
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, kv.getValue());
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public F mSet(scala.collection.immutable.Map<K, V> keyValues) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.mSet$$anonfun$2$$anonfun$1(keyValues, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F mSetNx(scala.collection.immutable.Map<K, V> keyValues) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.mSetNx$$anonfun$3$$anonfun$1(keyValues, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F bitCount(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitCount$$anonfun$5$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F bitCount(K key, long start, long end) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitCount$$anonfun$6$$anonfun$1(key, start, end, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F bitPos(K key, boolean state) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitPos$$anonfun$7$$anonfun$1(key, state, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F bitPos(K key, boolean state, long start) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitPos$$anonfun$8$$anonfun$1(key, state, start, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F bitPos(K key, boolean state, long start, long end) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitPos$$anonfun$9$$anonfun$1(key, state, start, end, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F bitOpAnd(K destination, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitOpAnd$$anonfun$2$$anonfun$1(destination, sources, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F bitOpNot(K destination, K source) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitOpNot$$anonfun$2$$anonfun$1(destination, source, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F bitOpOr(K destination, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitOpOr$$anonfun$2$$anonfun$1(destination, sources, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F bitOpXor(K destination, Seq<K> sources) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.bitOpXor$$anonfun$2$$anonfun$1(destination, sources, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F hDel(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hDel$$anonfun$3$$anonfun$1(key, fields, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F hExists(K key, K field) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hExists$$anonfun$3$$anonfun$1(key, field, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F hGet(K key, K field) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hGet$$anonfun$3$$anonfun$1(key, field, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F hGetAll(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hGetAll$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$13 -> JavaConversions$.MODULE$.MapHasAsScala(_$13).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public F hmGet(K key, Seq<K> fields) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hmGet$$anonfun$3$$anonfun$1(key, fields, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$14 -> JavaConversions$.MODULE$.ListHasAsScala(_$14).asScala().toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(KeyValue x) {
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                return kv.hasValue();
            }

            public final Object applyOrElse(KeyValue x, Function1 function1) {
                Object object;
                KeyValue keyValue = x;
                KeyValue kv = keyValue;
                if (kv.hasValue()) {
                    Object object2 = Predef$.MODULE$.ArrowAssoc(kv.getKey());
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, kv.getValue());
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public F hKeys(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hKeys$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$15 -> JavaConversions$.MODULE$.ListHasAsScala(_$15).asScala().toList());
    }

    @Override
    public F hVals(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hVals$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$16 -> JavaConversions$.MODULE$.ListHasAsScala(_$16).asScala().toList());
    }

    @Override
    public F hStrLen(K key, K field) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hStrLen$$anonfun$3$$anonfun$1(key, field, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F hLen(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hLen$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F hSet(K key, K field, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hSet$$anonfun$3$$anonfun$1(key, field, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F hSetNx(K key, K field, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hSetNx$$anonfun$3$$anonfun$1(key, field, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F hmSet(K key, scala.collection.immutable.Map<K, V> fieldValues) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hmSet$$anonfun$2$$anonfun$1(key, fieldValues, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F hIncrBy(K key, K field, long amount, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hIncrBy$$anonfun$3$$anonfun$1(key, field, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F hIncrByFloat(K key, K field, double amount, Numeric<V> N) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.hIncrByFloat$$anonfun$3$$anonfun$1(key, field, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F sIsMember(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sIsMember$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F sAdd(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sAdd$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F sDiffStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sDiffStore$$anonfun$3$$anonfun$1(destination, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F sInterStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sInterStore$$anonfun$3$$anonfun$1(destination, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F sMove(K source, K destination, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sMove$$anonfun$3$$anonfun$1(source, destination, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Boolean2boolean(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
    }

    @Override
    public F sPop(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sPop$$anonfun$5$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F sPop(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sPop$$anonfun$6$$anonfun$1(key, count, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$17 -> JavaConversions$.MODULE$.SetHasAsScala(_$17).asScala().toSet());
    }

    @Override
    public F sRem(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sRem$$anonfun$2$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F sCard(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sCard$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F sDiff(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sDiff$$anonfun$3$$anonfun$1(keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$18 -> JavaConversions$.MODULE$.SetHasAsScala(_$18).asScala().toSet());
    }

    @Override
    public F sInter(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sInter$$anonfun$3$$anonfun$1(keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$19 -> JavaConversions$.MODULE$.SetHasAsScala(_$19).asScala().toSet());
    }

    @Override
    public F sMembers(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sMembers$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$20 -> JavaConversions$.MODULE$.SetHasAsScala(_$20).asScala().toSet());
    }

    @Override
    public F sRandMember(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sRandMember$$anonfun$5$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F sRandMember(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sRandMember$$anonfun$6$$anonfun$1(key, count, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$21 -> JavaConversions$.MODULE$.ListHasAsScala(_$21).asScala().toList());
    }

    @Override
    public F sUnion(Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sUnion$$anonfun$3$$anonfun$1(keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$22 -> JavaConversions$.MODULE$.SetHasAsScala(_$22).asScala().toSet());
    }

    @Override
    public F sUnionStore(K destination, Seq<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.sUnionStore$$anonfun$2$$anonfun$1(destination, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F lIndex(K key, long index) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lIndex$$anonfun$3$$anonfun$1(key, index, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F lLen(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lLen$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F lRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lRange$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$23 -> JavaConversions$.MODULE$.ListHasAsScala(_$23).asScala().toList());
    }

    @Override
    public F blPop(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.blPop$$anonfun$3$$anonfun$1(timeout, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$24 -> Option$.MODULE$.apply(_$24).map((Function1 & Serializable)kv -> {
            Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
        }));
    }

    @Override
    public F brPop(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.brPop$$anonfun$3$$anonfun$1(timeout, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$25 -> Option$.MODULE$.apply(_$25).map((Function1 & Serializable)kv -> {
            Object object = Predef$.MODULE$.ArrowAssoc(kv.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, kv.getValue());
        }));
    }

    @Override
    public F brPopLPush(Duration timeout, K source, K destination) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.brPopLPush$$anonfun$3$$anonfun$1(timeout, source, destination, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F lPop(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lPop$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F lPush(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lPush$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F lPushX(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lPushX$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F rPop(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.rPop$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F rPopLPush(K source, K destination) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.rPopLPush$$anonfun$3$$anonfun$1(source, destination, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F rPush(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.rPush$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F rPushX(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.rPushX$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F lInsertAfter(K key, V pivot, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lInsertAfter$$anonfun$3$$anonfun$1(key, pivot, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F lInsertBefore(K key, V pivot, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lInsertBefore$$anonfun$3$$anonfun$1(key, pivot, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F lRem(K key, long count, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lRem$$anonfun$3$$anonfun$1(key, count, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F lSet(K key, long index, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lSet$$anonfun$2$$anonfun$1(key, index, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F lTrim(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.lTrim$$anonfun$2$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F geoDist(K key, V from, V to, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoDist$$anonfun$3$$anonfun$1(key, from, to, unit, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F geoHash(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoHash$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$26 -> JavaConversions$.MODULE$.ListHasAsScala(_$26).asScala().toList().map((Function1 & Serializable)x -> Option$.MODULE$.apply(x.getValue())));
    }

    @Override
    public F geoPos(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoPos$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$27 -> JavaConversions$.MODULE$.ListHasAsScala(_$27).asScala().toList().map((Function1 & Serializable)c -> effects$GeoCoordinate$.MODULE$.apply(c.getX().doubleValue(), c.getY().doubleValue())));
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoRadius$$anonfun$7$$anonfun$1(key, geoRadius, unit, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$28 -> JavaConversions$.MODULE$.SetHasAsScala(_$28).asScala().toSet());
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, GeoArgs args) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoRadius$$anonfun$8$$anonfun$1(key, geoRadius, unit, args, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$29 -> JavaConversions$.MODULE$.ListHasAsScala(_$29).asScala().toList().map((Function1 & Serializable)_$30 -> this.GeoRadiusResultOps((GeoWithin)_$30).asGeoRadiusResult()));
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoRadiusByMember$$anonfun$7$$anonfun$1(key, value, dist, unit, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$31 -> JavaConversions$.MODULE$.SetHasAsScala(_$31).asScala().toSet());
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, GeoArgs args) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoRadiusByMember$$anonfun$8$$anonfun$1(key, value, dist, unit, args, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$32 -> JavaConversions$.MODULE$.ListHasAsScala(_$32).asScala().toList().map((Function1 & Serializable)_$33 -> this.GeoRadiusResultOps((GeoWithin)_$33).asGeoRadiusResult()));
    }

    @Override
    public F geoAdd(K key, Seq<effects.GeoLocation<V>> geoValues) {
        Seq triplets = (Seq)geoValues.flatMap((Function1 & Serializable)g -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)g.lon()), BoxesRunTime.boxToDouble((double)g.lat()), g.value()})));
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.geoAdd$$anonfun$2$$anonfun$1(key, triplets, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, effects.GeoRadiusKeyStorage<K> storage) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.geoRadius$$anonfun$10$$anonfun$1(key, geoRadius, unit, storage, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F geoRadius(K key, effects.GeoRadius geoRadius, GeoArgs.Unit unit, effects.GeoRadiusDistStorage<K> storage) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.geoRadius$$anonfun$11$$anonfun$1(key, geoRadius, unit, storage, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, effects.GeoRadiusKeyStorage<K> storage) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.geoRadiusByMember$$anonfun$10$$anonfun$1(key, value, dist, unit, storage, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F geoRadiusByMember(K key, V value, double dist, GeoArgs.Unit unit, effects.GeoRadiusDistStorage<K> storage) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.geoRadiusByMember$$anonfun$11$$anonfun$1(key, value, dist, unit, storage, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F zAdd(K key, Option<ZAddArgs> args, Seq<effects.ScoreWithValue<V>> values) {
        Object object;
        Option<ZAddArgs> option = args;
        if (option instanceof Some) {
            ZAddArgs x2 = (ZAddArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$27$$anonfun$2(key, values, x2, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$29$$anonfun$2(key, values, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zAddIncr(K key, Option<ZAddArgs> args, effects.ScoreWithValue<V> member) {
        Object object;
        Option<ZAddArgs> option = args;
        if (option instanceof Some) {
            ZAddArgs x2 = (ZAddArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$30$$anonfun$1(key, member, x2, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$31$$anonfun$1(key, member, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F zIncrBy(K key, V member, double amount) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zIncrBy$$anonfun$3$$anonfun$1(key, member, amount, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Double2double(BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(x))));
    }

    @Override
    public F zInterStore(K destination, Option<ZStoreArgs> args, Seq<K> keys) {
        Object object;
        Option<ZStoreArgs> option = args;
        if (option instanceof Some) {
            ZStoreArgs x2 = (ZStoreArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$32$$anonfun$1(destination, keys, x2, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$33$$anonfun$1(destination, keys, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zRem(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRem$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zRemRangeByLex(K key, effects.ZRange<V> range) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRemRangeByLex$$anonfun$3$$anonfun$1(key, range, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zRemRangeByRank(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRemRangeByRank$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public <T> F zRemRangeByScore(K key, effects.ZRange<T> range, Numeric<T> evidence$16) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.zRemRangeByScore$$anonfun$3$$anonfun$1(key, range, evidence$16, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zUnionStore(K destination, Option<ZStoreArgs> args, Seq<K> keys) {
        Object object;
        Option<ZStoreArgs> option = args;
        if (option instanceof Some) {
            ZStoreArgs x2 = (ZStoreArgs)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$34$$anonfun$1(destination, keys, x2, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$35$$anonfun$1(destination, keys, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x))));
    }

    @Override
    public F zCard(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zCard$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public <T> F zCount(K key, effects.ZRange<T> range, Numeric<T> evidence$17) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.zCount$$anonfun$3$$anonfun$1(key, range, evidence$17, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F zLexCount(K key, effects.ZRange<V> range) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zLexCount$$anonfun$3$$anonfun$1(key, range, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F zRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRange$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$34 -> JavaConversions$.MODULE$.ListHasAsScala(_$34).asScala().toList());
    }

    @Override
    public F zRangeByLex(K key, effects.ZRange<V> range, Option<effects.RangeLimit> limit) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$36$$anonfun$1(key, range, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$37$$anonfun$1(key, range, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$35 -> JavaConversions$.MODULE$.ListHasAsScala(_$35).asScala().toList());
    }

    @Override
    public <T> F zRangeByScore(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$18) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$38$$anonfun$1(key, range, evidence$18, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$39$$anonfun$1(key, range, evidence$18, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$36 -> JavaConversions$.MODULE$.ListHasAsScala(_$36).asScala().toList());
    }

    @Override
    public <T> F zRangeByScoreWithScores(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$19) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$40$$anonfun$1(key, range, evidence$19, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$41$$anonfun$1(key, range, evidence$19, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$37 -> JavaConversions$.MODULE$.ListHasAsScala(_$37).asScala().toList().map((Function1 & Serializable)_$38 -> this.ScoredValuesOps((ScoredValue)_$38).asScoreWithValues()));
    }

    @Override
    public F zRangeWithScores(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRangeWithScores$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$39 -> JavaConversions$.MODULE$.ListHasAsScala(_$39).asScala().toList().map((Function1 & Serializable)_$40 -> this.ScoredValuesOps((ScoredValue)_$40).asScoreWithValues()));
    }

    @Override
    public F zRank(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRank$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F zRevRange(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRevRange$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$41 -> JavaConversions$.MODULE$.ListHasAsScala(_$41).asScala().toList());
    }

    @Override
    public F zRevRangeByLex(K key, effects.ZRange<V> range, Option<effects.RangeLimit> limit) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$42$$anonfun$1(key, range, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.$anonfun$43$$anonfun$1(key, range, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$42 -> JavaConversions$.MODULE$.ListHasAsScala(_$42).asScala().toList());
    }

    @Override
    public <T> F zRevRangeByScore(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$20) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$44$$anonfun$1(key, range, evidence$20, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$45$$anonfun$1(key, range, evidence$20, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$43 -> JavaConversions$.MODULE$.ListHasAsScala(_$43).asScala().toList());
    }

    @Override
    public <T> F zRevRangeByScoreWithScores(K key, effects.ZRange<T> range, Option<effects.RangeLimit> limit, Numeric<T> evidence$21) {
        Object object;
        Option<effects.RangeLimit> option = limit;
        if (option instanceof Some) {
            effects.RangeLimit x = (effects.RangeLimit)((Some)option).value();
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$46$$anonfun$1(key, range, evidence$21, x, c)));
        } else if (None$.MODULE$.equals(option)) {
            object = package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.$anonfun$47$$anonfun$1(key, range, evidence$21, c)));
        } else {
            throw new MatchError(option);
        }
        Object res = object;
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(res, this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$44 -> JavaConversions$.MODULE$.ListHasAsScala(_$44).asScala().toList().map((Function1 & Serializable)_$45 -> this.ScoredValuesOps((ScoredValue)_$45).asScoreWithValues()));
    }

    @Override
    public F zRevRangeWithScores(K key, long start, long stop) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRevRangeWithScores$$anonfun$3$$anonfun$1(key, start, stop, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$46 -> JavaConversions$.MODULE$.ListHasAsScala(_$46).asScala().toList().map((Function1 & Serializable)_$47 -> this.ScoredValuesOps((ScoredValue)_$47).asScoreWithValues()));
    }

    @Override
    public F zRevRank(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zRevRank$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F zScore(K key, V value) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zScore$$anonfun$3$$anonfun$1(key, value, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> Option$.MODULE$.apply(x));
    }

    @Override
    public F zPopMin(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zPopMin$$anonfun$3$$anonfun$1(key, count, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$48 -> JavaConversions$.MODULE$.ListHasAsScala(_$48).asScala().toList().map((Function1 & Serializable)_$49 -> this.ScoredValuesOps((ScoredValue)_$49).asScoreWithValues()));
    }

    @Override
    public F zPopMax(K key, long count) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.zPopMax$$anonfun$3$$anonfun$1(key, count, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$50 -> JavaConversions$.MODULE$.ListHasAsScala(_$50).asScala().toList().map((Function1 & Serializable)_$51 -> this.ScoredValuesOps((ScoredValue)_$51).asScoreWithValues()));
    }

    @Override
    public F bzPopMin(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.bzPopMin$$anonfun$3$$anonfun$1(timeout, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$52 -> Option$.MODULE$.apply(_$52).map((Function1 & Serializable)kv -> Tuple2$.MODULE$.apply(kv.getKey(), this.ScoredValuesOps((ScoredValue)kv.getValue()).asScoreWithValues())));
    }

    @Override
    public F bzPopMax(Duration timeout, NonEmptyList<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> this.bzPopMax$$anonfun$3$$anonfun$1(timeout, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$53 -> Option$.MODULE$.apply(_$53).map((Function1 & Serializable)kv -> Tuple2$.MODULE$.apply(kv.getKey(), this.ScoredValuesOps((ScoredValue)kv.getValue()).asScoreWithValues())));
    }

    @Override
    public F ping() {
        return (F)this.ping;
    }

    @Override
    public F select(int index) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.conn().async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.select$$anonfun$2$$anonfun$1(index, c))), this.evidence$1).void();
    }

    @Override
    public F auth(CharSequence password) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.auth$$anonfun$5$$anonfun$1(password, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$54 -> {
            String string = _$54;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public F auth(String username, CharSequence password) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.auth$$anonfun$6$$anonfun$1(username, password, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$55 -> {
            String string = _$55;
            String string2 = "OK";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public F flushAll() {
        return (F)this.flushAll;
    }

    @Override
    public F flushAllAsync() {
        return (F)this.flushAllAsync;
    }

    @Override
    public F keys(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.keys$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$56 -> JavaConversions$.MODULE$.ListHasAsScala(_$56).asScala().toList());
    }

    @Override
    public F info() {
        return (F)package.all$.MODULE$.toFlatMapOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.info$$anonfun$3$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).flatMap((Function1 & Serializable)info -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.info$$anonfun$5$$anonfun$2(info)));
    }

    @Override
    public F dbsize() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.dbsize$$anonfun$3$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x));
    }

    @Override
    public F lastSave() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.lastSave$$anonfun$3$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$58 -> _$58.toInstant());
    }

    @Override
    public F slowLogLen() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.slowLogLen$$anonfun$3$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)x -> BoxesRunTime.unboxToLong((Object)x));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.eval$$anonfun$7$$anonfun$1(script, output, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)r -> output.convert(r));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.eval$$anonfun$8$$anonfun$1(script, output, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$59 -> output.convert(_$59));
    }

    @Override
    public F eval(String script, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.eval$$anonfun$9$$anonfun$1(script, output, keys, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$60 -> output.convert(_$60));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.evalSha$$anonfun$7$$anonfun$1(digest, output, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$61 -> output.convert(_$61));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output, List<K> keys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.evalSha$$anonfun$8$$anonfun$1(digest, output, keys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$62 -> output.convert(_$62));
    }

    @Override
    public F evalSha(String digest, effects.ScriptOutputType<V> output, List<K> keys, List<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.evalSha$$anonfun$9$$anonfun$1(digest, output, keys, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$63 -> output.convert(_$63));
    }

    @Override
    public F scriptLoad(String script) {
        return (F)JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scriptLoad$$anonfun$3$$anonfun$1(script, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift();
    }

    @Override
    public F scriptLoad(byte[] script) {
        return (F)JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scriptLoad$$anonfun$4$$anonfun$1(script, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift();
    }

    @Override
    public F scriptExists(Seq<String> digests) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scriptExists$$anonfun$3$$anonfun$1(digests, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$64 -> ((IterableOnceOps)JavaConversions$.MODULE$.ListHasAsScala(_$64).asScala().map((Function1 & Serializable)_$65 -> BoxesRunTime.unboxToBoolean((Object)_$65))).toList());
    }

    @Override
    public F scriptFlush() {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.scriptFlush$$anonfun$2$$anonfun$1(c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    @Override
    public F digest(String script) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> Sync$.MODULE$.apply(this.evidence$1).delay(() -> BaseRedis.digest$$anonfun$2$$anonfun$1(script, c)));
    }

    @Override
    public F pfAdd(K key, Seq<V> values) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.pfAdd$$anonfun$3$$anonfun$1(key, values, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$66 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$66))));
    }

    @Override
    public F pfCount(K key) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.pfCount$$anonfun$3$$anonfun$1(key, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).map((Function1 & Serializable)_$67 -> Predef$.MODULE$.Long2long(BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(_$67))));
    }

    @Override
    public F pfMerge(K outputKey, Seq<K> inputKeys) {
        return (F)package.all$.MODULE$.toFunctorOps(JRFuture$.MODULE$.FutureLiftOps(package.all$.MODULE$.toFlatMapOps(this.async(), this.evidence$1).flatMap((Function1 & Serializable)c -> RedisExecutor$.MODULE$.apply(this.evidence$3).delay(() -> BaseRedis.pfMerge$$anonfun$2$$anonfun$1(outputKey, inputKeys, c))), this.evidence$1, this.evidence$2, this.evidence$3, this.evidence$4).futureLift(), this.evidence$1).void();
    }

    private static final RedisFuture $init$$$anonfun$4$$anonfun$1(RedisClusterAsyncCommands c$1) {
        return c$1.ping();
    }

    private static final RedisFuture $init$$$anonfun$5$$anonfun$1(RedisClusterAsyncCommands c$2) {
        return c$2.flushall();
    }

    private static final RedisFuture $init$$$anonfun$6$$anonfun$1(RedisClusterAsyncCommands c$3) {
        return c$3.flushallAsync();
    }

    private static final RedisFuture del$$anonfun$3$$anonfun$1(Seq key$1, RedisClusterAsyncCommands c$4) {
        return c$4.del((Object[])Arrays$.MODULE$.seqToArray(key$1, Object.class));
    }

    private static final RedisFuture exists$$anonfun$3$$anonfun$1(Seq key$3, RedisClusterAsyncCommands c$5) {
        return c$5.exists((Object[])Arrays$.MODULE$.seqToArray(key$3, Object.class));
    }

    private static final RedisFuture expire$$anonfun$3$$anonfun$1(Object key$7, FiniteDuration expiresIn$2, RedisClusterAsyncCommands c$6) {
        return c$6.pexpire(key$7, expiresIn$2.toMillis());
    }

    private static final RedisFuture expire$$anonfun$4$$anonfun$2(Object key$8, FiniteDuration expiresIn$3, RedisClusterAsyncCommands c$7) {
        return c$7.expire(key$8, expiresIn$3.toSeconds());
    }

    private static final RedisFuture expireAt$$anonfun$3$$anonfun$1(Object key$9, Instant at$1, RedisClusterAsyncCommands c$8) {
        return c$8.pexpireat(key$9, at$1.toEpochMilli());
    }

    private static final RedisFuture objectIdletime$$anonfun$3$$anonfun$1(Object key$11, RedisClusterAsyncCommands c$9) {
        return c$9.objectIdletime(key$11);
    }

    private static final RedisFuture ttl$$anonfun$3$$anonfun$1(Object key$13, RedisClusterAsyncCommands c$10) {
        return c$10.ttl(key$13);
    }

    private static final RedisFuture pttl$$anonfun$3$$anonfun$1(Object key$15, RedisClusterAsyncCommands c$11) {
        return c$11.pttl(key$15);
    }

    private static final RedisFuture scan$$anonfun$13$$anonfun$1(RedisClusterAsyncCommands c$12) {
        return c$12.scan();
    }

    private static final RedisFuture scan$$anonfun$14$$anonfun$1(long cursor$1, RedisClusterAsyncCommands c$13) {
        return c$13.scan(ScanCursor.of((String)BoxesRunTime.boxToLong((long)cursor$1).toString()));
    }

    private static final RedisFuture scan$$anonfun$15$$anonfun$1(data.KeyScanCursor previous$1, RedisClusterAsyncCommands c$14) {
        return c$14.scan((ScanCursor)previous$1.underlying());
    }

    private static final RedisFuture scan$$anonfun$16$$anonfun$1(effects.ScanArgs scanArgs$1, RedisClusterAsyncCommands c$15) {
        return c$15.scan(scanArgs$1.underlying());
    }

    private static final RedisFuture scan$$anonfun$17$$anonfun$1(long cursor$3, effects.ScanArgs scanArgs$3, RedisClusterAsyncCommands c$16) {
        return c$16.scan(ScanCursor.of((String)BoxesRunTime.boxToLong((long)cursor$3).toString()), scanArgs$3.underlying());
    }

    private static final RedisFuture scan$$anonfun$18$$anonfun$1(data.KeyScanCursor previous$3, effects.ScanArgs scanArgs$5, RedisClusterAsyncCommands c$17) {
        return c$17.scan((ScanCursor)previous$3.underlying(), scanArgs$5.underlying());
    }

    private static final RedisFuture multi$$anonfun$2$$anonfun$1(RedisAsyncCommands c$18) {
        return c$18.multi();
    }

    private static final RedisFuture multi$$anonfun$3$$anonfun$2$$anonfun$1(RedisAsyncCommands c$19) {
        return c$19.multi();
    }

    private static final RedisFuture exec$$anonfun$3$$anonfun$1(RedisAsyncCommands c$20) {
        return c$20.exec();
    }

    private static final RedisFuture exec$$anonfun$4$$anonfun$2$$anonfun$1(RedisAsyncCommands c$21) {
        return c$21.exec();
    }

    private static final RedisFuture discard$$anonfun$2$$anonfun$1(RedisAsyncCommands c$22) {
        return c$22.discard();
    }

    private static final RedisFuture discard$$anonfun$3$$anonfun$2$$anonfun$1(RedisAsyncCommands c$23) {
        return c$23.discard();
    }

    private static final RedisFuture watch$$anonfun$2$$anonfun$1(Seq keys$1, RedisAsyncCommands c$24) {
        return c$24.watch((Object[])Arrays$.MODULE$.seqToArray(keys$1, Object.class));
    }

    private static final RedisFuture watch$$anonfun$3$$anonfun$2$$anonfun$1(Seq keys$3, RedisAsyncCommands c$25) {
        return c$25.watch((Object[])Arrays$.MODULE$.seqToArray(keys$3, Object.class));
    }

    private static final RedisFuture unwatch$$anonfun$2$$anonfun$1(RedisAsyncCommands c$26) {
        return c$26.unwatch();
    }

    private static final RedisFuture unwatch$$anonfun$3$$anonfun$2$$anonfun$1(RedisAsyncCommands c$27) {
        return c$27.unwatch();
    }

    private static final void enableAutoFlush$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands c$28) {
        c$28.setAutoFlushCommands(true);
    }

    private static final void disableAutoFlush$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands c$29) {
        c$29.setAutoFlushCommands(false);
    }

    private static final void flushCommands$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands c$30) {
        c$30.flushCommands();
    }

    private static final RedisFuture append$$anonfun$2$$anonfun$1(Object key$17, Object value$1, RedisClusterAsyncCommands c$31) {
        return c$31.append(key$17, value$1);
    }

    private static final RedisFuture getSet$$anonfun$3$$anonfun$1(Object key$19, Object value$3, RedisClusterAsyncCommands c$32) {
        return c$32.getset(key$19, value$3);
    }

    private static final RedisFuture set$$anonfun$6$$anonfun$1(Object key$21, Object value$5, RedisClusterAsyncCommands c$33) {
        return c$33.set(key$21, value$5);
    }

    private static final RedisFuture set$$anonfun$7$$anonfun$1(Object key$23, Object value$7, SetArgs jSetArgs$3, RedisClusterAsyncCommands c$34) {
        return c$34.set(key$23, value$7, jSetArgs$3);
    }

    private static final RedisFuture setNx$$anonfun$3$$anonfun$1(Object key$25, Object value$9, RedisClusterAsyncCommands c$35) {
        return c$35.setnx(key$25, value$9);
    }

    private static final RedisFuture $anonfun$24$$anonfun$1(Object key$27, Object value$11, FiniteDuration expiresIn$4, RedisClusterAsyncCommands c$36) {
        return c$36.psetex(key$27, expiresIn$4.toMillis(), value$11);
    }

    private static final RedisFuture $anonfun$25$$anonfun$1(Object key$29, Object value$13, FiniteDuration expiresIn$6, RedisClusterAsyncCommands c$37) {
        return c$37.setex(key$29, expiresIn$6.toSeconds(), value$13);
    }

    private static final RedisFuture setRange$$anonfun$2$$anonfun$1(Object key$31, Object value$15, long offset$1, RedisClusterAsyncCommands c$38) {
        return c$38.setrange(key$31, offset$1, value$15);
    }

    private static final RedisFuture decr$$anonfun$3$$anonfun$1(Object key$33, RedisClusterAsyncCommands c$39) {
        return c$39.decr(key$33);
    }

    private static final RedisFuture decrBy$$anonfun$3$$anonfun$1(Object key$35, long amount$1, RedisClusterAsyncCommands c$40) {
        return c$40.incrby(key$35, amount$1);
    }

    private static final RedisFuture incr$$anonfun$3$$anonfun$1(Object key$37, RedisClusterAsyncCommands c$41) {
        return c$41.incr(key$37);
    }

    private static final RedisFuture incrBy$$anonfun$3$$anonfun$1(Object key$39, long amount$3, RedisClusterAsyncCommands c$42) {
        return c$42.incrby(key$39, amount$3);
    }

    private static final RedisFuture incrByFloat$$anonfun$3$$anonfun$1(Object key$41, double amount$5, RedisClusterAsyncCommands c$43) {
        return c$43.incrbyfloat(key$41, amount$5);
    }

    private static final RedisFuture get$$anonfun$3$$anonfun$1(Object key$43, RedisClusterAsyncCommands c$44) {
        return c$44.get(key$43);
    }

    private static final RedisFuture getBit$$anonfun$3$$anonfun$1(Object key$45, long offset$3, RedisClusterAsyncCommands c$45) {
        return c$45.getbit(key$45, offset$3);
    }

    private static final RedisFuture getRange$$anonfun$3$$anonfun$1(Object key$47, long start$1, long end$1, RedisClusterAsyncCommands c$46) {
        return c$46.getrange(key$47, start$1, end$1);
    }

    private static final RedisFuture strLen$$anonfun$3$$anonfun$1(Object key$49, RedisClusterAsyncCommands c$47) {
        return c$47.strlen(key$49);
    }

    private static final RedisFuture mGet$$anonfun$3$$anonfun$1(Set keys$5, RedisClusterAsyncCommands c$48) {
        return c$48.mget((Object[])Arrays$.MODULE$.seqToArray(keys$5.toSeq(), Object.class));
    }

    private static final RedisFuture mSet$$anonfun$2$$anonfun$1(scala.collection.immutable.Map keyValues$1, RedisClusterAsyncCommands c$49) {
        return c$49.mset(JavaConversions$.MODULE$.MapHasAsJava((Map)keyValues$1).asJava());
    }

    private static final RedisFuture mSetNx$$anonfun$3$$anonfun$1(scala.collection.immutable.Map keyValues$3, RedisClusterAsyncCommands c$50) {
        return c$50.msetnx(JavaConversions$.MODULE$.MapHasAsJava((Map)keyValues$3).asJava());
    }

    private static final RedisFuture bitCount$$anonfun$5$$anonfun$1(Object key$51, RedisClusterAsyncCommands c$51) {
        return c$51.bitcount(key$51);
    }

    private static final RedisFuture bitCount$$anonfun$6$$anonfun$1(Object key$53, long start$3, long end$3, RedisClusterAsyncCommands c$52) {
        return c$52.bitcount(key$53, start$3, end$3);
    }

    private static final RedisFuture bitPos$$anonfun$7$$anonfun$1(Object key$55, boolean state$1, RedisClusterAsyncCommands c$53) {
        return c$53.bitpos(key$55, state$1);
    }

    private static final RedisFuture bitPos$$anonfun$8$$anonfun$1(Object key$57, boolean state$3, long start$5, RedisClusterAsyncCommands c$54) {
        return c$54.bitpos(key$57, state$3, start$5);
    }

    private static final RedisFuture bitPos$$anonfun$9$$anonfun$1(Object key$59, boolean state$5, long start$7, long end$5, RedisClusterAsyncCommands c$55) {
        return c$55.bitpos(key$59, state$5, start$7, end$5);
    }

    private static final RedisFuture bitOpAnd$$anonfun$2$$anonfun$1(Object destination$1, Seq sources$1, RedisClusterAsyncCommands c$56) {
        return c$56.bitopAnd(destination$1, (Object[])Arrays$.MODULE$.seqToArray(sources$1, Object.class));
    }

    private static final RedisFuture bitOpNot$$anonfun$2$$anonfun$1(Object destination$3, Object source$1, RedisClusterAsyncCommands c$57) {
        return c$57.bitopNot(destination$3, source$1);
    }

    private static final RedisFuture bitOpOr$$anonfun$2$$anonfun$1(Object destination$5, Seq sources$3, RedisClusterAsyncCommands c$58) {
        return c$58.bitopOr(destination$5, (Object[])Arrays$.MODULE$.seqToArray(sources$3, Object.class));
    }

    private static final RedisFuture bitOpXor$$anonfun$2$$anonfun$1(Object destination$7, Seq sources$5, RedisClusterAsyncCommands c$59) {
        return c$59.bitopXor(destination$7, (Object[])Arrays$.MODULE$.seqToArray(sources$5, Object.class));
    }

    private static final RedisFuture hDel$$anonfun$3$$anonfun$1(Object key$61, Seq fields$1, RedisClusterAsyncCommands c$60) {
        return c$60.hdel(key$61, (Object[])Arrays$.MODULE$.seqToArray(fields$1, Object.class));
    }

    private static final RedisFuture hExists$$anonfun$3$$anonfun$1(Object key$63, Object field$1, RedisClusterAsyncCommands c$61) {
        return c$61.hexists(key$63, field$1);
    }

    private static final RedisFuture hGet$$anonfun$3$$anonfun$1(Object key$65, Object field$3, RedisClusterAsyncCommands c$62) {
        return c$62.hget(key$65, field$3);
    }

    private static final RedisFuture hGetAll$$anonfun$3$$anonfun$1(Object key$67, RedisClusterAsyncCommands c$63) {
        return c$63.hgetall(key$67);
    }

    private static final RedisFuture hmGet$$anonfun$3$$anonfun$1(Object key$69, Seq fields$3, RedisClusterAsyncCommands c$64) {
        return c$64.hmget(key$69, (Object[])Arrays$.MODULE$.seqToArray(fields$3, Object.class));
    }

    private static final RedisFuture hKeys$$anonfun$3$$anonfun$1(Object key$71, RedisClusterAsyncCommands c$65) {
        return c$65.hkeys(key$71);
    }

    private static final RedisFuture hVals$$anonfun$3$$anonfun$1(Object key$73, RedisClusterAsyncCommands c$66) {
        return c$66.hvals(key$73);
    }

    private static final RedisFuture hStrLen$$anonfun$3$$anonfun$1(Object key$75, Object field$5, RedisClusterAsyncCommands c$67) {
        return c$67.hstrlen(key$75, field$5);
    }

    private static final RedisFuture hLen$$anonfun$3$$anonfun$1(Object key$77, RedisClusterAsyncCommands c$68) {
        return c$68.hlen(key$77);
    }

    private static final RedisFuture hSet$$anonfun$3$$anonfun$1(Object key$79, Object field$7, Object value$17, RedisClusterAsyncCommands c$69) {
        return c$69.hset(key$79, field$7, value$17);
    }

    private static final RedisFuture hSetNx$$anonfun$3$$anonfun$1(Object key$81, Object field$9, Object value$19, RedisClusterAsyncCommands c$70) {
        return c$70.hsetnx(key$81, field$9, value$19);
    }

    private static final RedisFuture hmSet$$anonfun$2$$anonfun$1(Object key$83, scala.collection.immutable.Map fieldValues$1, RedisClusterAsyncCommands c$71) {
        return c$71.hmset(key$83, JavaConversions$.MODULE$.MapHasAsJava((Map)fieldValues$1).asJava());
    }

    private static final RedisFuture hIncrBy$$anonfun$3$$anonfun$1(Object key$85, Object field$11, long amount$7, RedisClusterAsyncCommands c$72) {
        return c$72.hincrby(key$85, field$11, amount$7);
    }

    private static final RedisFuture hIncrByFloat$$anonfun$3$$anonfun$1(Object key$87, Object field$13, double amount$9, RedisClusterAsyncCommands c$73) {
        return c$73.hincrbyfloat(key$87, field$13, amount$9);
    }

    private static final RedisFuture sIsMember$$anonfun$3$$anonfun$1(Object key$89, Object value$21, RedisClusterAsyncCommands c$74) {
        return c$74.sismember(key$89, value$21);
    }

    private static final RedisFuture sAdd$$anonfun$3$$anonfun$1(Object key$91, Seq values$1, RedisClusterAsyncCommands c$75) {
        return c$75.sadd(key$91, (Object[])Arrays$.MODULE$.seqToArray(values$1, Object.class));
    }

    private static final RedisFuture sDiffStore$$anonfun$3$$anonfun$1(Object destination$9, Seq keys$7, RedisClusterAsyncCommands c$76) {
        return c$76.sdiffstore(destination$9, (Object[])Arrays$.MODULE$.seqToArray(keys$7, Object.class));
    }

    private static final RedisFuture sInterStore$$anonfun$3$$anonfun$1(Object destination$11, Seq keys$9, RedisClusterAsyncCommands c$77) {
        return c$77.sinterstore(destination$11, (Object[])Arrays$.MODULE$.seqToArray(keys$9, Object.class));
    }

    private static final RedisFuture sMove$$anonfun$3$$anonfun$1(Object source$3, Object destination$13, Object value$23, RedisClusterAsyncCommands c$78) {
        return c$78.smove(source$3, destination$13, value$23);
    }

    private static final RedisFuture sPop$$anonfun$5$$anonfun$1(Object key$93, RedisClusterAsyncCommands c$79) {
        return c$79.spop(key$93);
    }

    private static final RedisFuture sPop$$anonfun$6$$anonfun$1(Object key$95, long count$1, RedisClusterAsyncCommands c$80) {
        return c$80.spop(key$95, count$1);
    }

    private static final RedisFuture sRem$$anonfun$2$$anonfun$1(Object key$97, Seq values$3, RedisClusterAsyncCommands c$81) {
        return c$81.srem(key$97, (Object[])Arrays$.MODULE$.seqToArray(values$3, Object.class));
    }

    private static final RedisFuture sCard$$anonfun$3$$anonfun$1(Object key$99, RedisClusterAsyncCommands c$82) {
        return c$82.scard(key$99);
    }

    private static final RedisFuture sDiff$$anonfun$3$$anonfun$1(Seq keys$11, RedisClusterAsyncCommands c$83) {
        return c$83.sdiff((Object[])Arrays$.MODULE$.seqToArray(keys$11, Object.class));
    }

    private static final RedisFuture sInter$$anonfun$3$$anonfun$1(Seq keys$13, RedisClusterAsyncCommands c$84) {
        return c$84.sinter((Object[])Arrays$.MODULE$.seqToArray(keys$13, Object.class));
    }

    private static final RedisFuture sMembers$$anonfun$3$$anonfun$1(Object key$101, RedisClusterAsyncCommands c$85) {
        return c$85.smembers(key$101);
    }

    private static final RedisFuture sRandMember$$anonfun$5$$anonfun$1(Object key$103, RedisClusterAsyncCommands c$86) {
        return c$86.srandmember(key$103);
    }

    private static final RedisFuture sRandMember$$anonfun$6$$anonfun$1(Object key$105, long count$3, RedisClusterAsyncCommands c$87) {
        return c$87.srandmember(key$105, count$3);
    }

    private static final RedisFuture sUnion$$anonfun$3$$anonfun$1(Seq keys$15, RedisClusterAsyncCommands c$88) {
        return c$88.sunion((Object[])Arrays$.MODULE$.seqToArray(keys$15, Object.class));
    }

    private static final RedisFuture sUnionStore$$anonfun$2$$anonfun$1(Object destination$15, Seq keys$17, RedisClusterAsyncCommands c$89) {
        return c$89.sunionstore(destination$15, (Object[])Arrays$.MODULE$.seqToArray(keys$17, Object.class));
    }

    private static final RedisFuture lIndex$$anonfun$3$$anonfun$1(Object key$107, long index$1, RedisClusterAsyncCommands c$90) {
        return c$90.lindex(key$107, index$1);
    }

    private static final RedisFuture lLen$$anonfun$3$$anonfun$1(Object key$109, RedisClusterAsyncCommands c$91) {
        return c$91.llen(key$109);
    }

    private static final RedisFuture lRange$$anonfun$3$$anonfun$1(Object key$111, long start$9, long stop$1, RedisClusterAsyncCommands c$92) {
        return c$92.lrange(key$111, start$9, stop$1);
    }

    private final RedisFuture blPop$$anonfun$3$$anonfun$1(Duration timeout$1, NonEmptyList keys$19, RedisClusterAsyncCommands c$93) {
        return c$93.blpop(this.DurationOps(timeout$1).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$19.toList(), Object.class));
    }

    private final RedisFuture brPop$$anonfun$3$$anonfun$1(Duration timeout$3, NonEmptyList keys$21, RedisClusterAsyncCommands c$94) {
        return c$94.brpop(this.DurationOps(timeout$3).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$21.toList(), Object.class));
    }

    private final RedisFuture brPopLPush$$anonfun$3$$anonfun$1(Duration timeout$5, Object source$5, Object destination$17, RedisClusterAsyncCommands c$95) {
        return c$95.brpoplpush(this.DurationOps(timeout$5).toSecondsOrZero(), source$5, destination$17);
    }

    private static final RedisFuture lPop$$anonfun$3$$anonfun$1(Object key$113, RedisClusterAsyncCommands c$96) {
        return c$96.lpop(key$113);
    }

    private static final RedisFuture lPush$$anonfun$3$$anonfun$1(Object key$115, Seq values$5, RedisClusterAsyncCommands c$97) {
        return c$97.lpush(key$115, (Object[])Arrays$.MODULE$.seqToArray(values$5, Object.class));
    }

    private static final RedisFuture lPushX$$anonfun$3$$anonfun$1(Object key$117, Seq values$7, RedisClusterAsyncCommands c$98) {
        return c$98.lpushx(key$117, (Object[])Arrays$.MODULE$.seqToArray(values$7, Object.class));
    }

    private static final RedisFuture rPop$$anonfun$3$$anonfun$1(Object key$119, RedisClusterAsyncCommands c$99) {
        return c$99.rpop(key$119);
    }

    private static final RedisFuture rPopLPush$$anonfun$3$$anonfun$1(Object source$7, Object destination$19, RedisClusterAsyncCommands c$100) {
        return c$100.rpoplpush(source$7, destination$19);
    }

    private static final RedisFuture rPush$$anonfun$3$$anonfun$1(Object key$121, Seq values$9, RedisClusterAsyncCommands c$101) {
        return c$101.rpush(key$121, (Object[])Arrays$.MODULE$.seqToArray(values$9, Object.class));
    }

    private static final RedisFuture rPushX$$anonfun$3$$anonfun$1(Object key$123, Seq values$11, RedisClusterAsyncCommands c$102) {
        return c$102.rpushx(key$123, (Object[])Arrays$.MODULE$.seqToArray(values$11, Object.class));
    }

    private static final RedisFuture lInsertAfter$$anonfun$3$$anonfun$1(Object key$125, Object pivot$1, Object value$25, RedisClusterAsyncCommands c$103) {
        return c$103.linsert(key$125, false, pivot$1, value$25);
    }

    private static final RedisFuture lInsertBefore$$anonfun$3$$anonfun$1(Object key$127, Object pivot$3, Object value$27, RedisClusterAsyncCommands c$104) {
        return c$104.linsert(key$127, true, pivot$3, value$27);
    }

    private static final RedisFuture lRem$$anonfun$3$$anonfun$1(Object key$129, long count$5, Object value$29, RedisClusterAsyncCommands c$105) {
        return c$105.lrem(key$129, count$5, value$29);
    }

    private static final RedisFuture lSet$$anonfun$2$$anonfun$1(Object key$131, long index$3, Object value$31, RedisClusterAsyncCommands c$106) {
        return c$106.lset(key$131, index$3, value$31);
    }

    private static final RedisFuture lTrim$$anonfun$2$$anonfun$1(Object key$133, long start$11, long stop$3, RedisClusterAsyncCommands c$107) {
        return c$107.ltrim(key$133, start$11, stop$3);
    }

    private static final RedisFuture geoDist$$anonfun$3$$anonfun$1(Object key$135, Object from$1, Object to$1, GeoArgs.Unit unit$1, RedisClusterAsyncCommands c$108) {
        return c$108.geodist(key$135, from$1, to$1, unit$1);
    }

    private static final RedisFuture geoHash$$anonfun$3$$anonfun$1(Object key$137, Seq values$13, RedisClusterAsyncCommands c$109) {
        return c$109.geohash(key$137, (Object[])Arrays$.MODULE$.seqToArray(values$13, Object.class));
    }

    private static final RedisFuture geoPos$$anonfun$3$$anonfun$1(Object key$139, Seq values$15, RedisClusterAsyncCommands c$110) {
        return c$110.geopos(key$139, (Object[])Arrays$.MODULE$.seqToArray(values$15, Object.class));
    }

    private static final RedisFuture geoRadius$$anonfun$7$$anonfun$1(Object key$141, effects.GeoRadius geoRadius$1, GeoArgs.Unit unit$3, RedisClusterAsyncCommands c$111) {
        return c$111.georadius(key$141, geoRadius$1.lon(), geoRadius$1.lat(), geoRadius$1.dist(), unit$3);
    }

    private static final RedisFuture geoRadius$$anonfun$8$$anonfun$1(Object key$143, effects.GeoRadius geoRadius$3, GeoArgs.Unit unit$5, GeoArgs args$1, RedisClusterAsyncCommands c$112) {
        return c$112.georadius(key$143, geoRadius$3.lon(), geoRadius$3.lat(), geoRadius$3.dist(), unit$5, args$1);
    }

    private static final RedisFuture geoRadiusByMember$$anonfun$7$$anonfun$1(Object key$145, Object value$33, double dist$1, GeoArgs.Unit unit$7, RedisClusterAsyncCommands c$113) {
        return c$113.georadiusbymember(key$145, value$33, dist$1, unit$7);
    }

    private static final RedisFuture geoRadiusByMember$$anonfun$8$$anonfun$1(Object key$147, Object value$35, double dist$3, GeoArgs.Unit unit$9, GeoArgs args$3, RedisClusterAsyncCommands c$114) {
        return c$114.georadiusbymember(key$147, value$35, dist$3, unit$9, args$3);
    }

    private static final RedisFuture geoAdd$$anonfun$2$$anonfun$1(Object key$149, Seq triplets$1, RedisClusterAsyncCommands c$115) {
        return c$115.geoadd(key$149, (Object[])Arrays$.MODULE$.seqToArray(triplets$1, Object.class));
    }

    private final RedisFuture geoRadius$$anonfun$10$$anonfun$1(Object key$151, effects.GeoRadius geoRadius$5, GeoArgs.Unit unit$11, effects.GeoRadiusKeyStorage storage$1, RedisAsyncCommands c$116) {
        return c$116.georadius(key$151, geoRadius$5.lon(), geoRadius$5.lat(), geoRadius$5.dist(), unit$11, this.GeoRadiusKeyStorageOps(storage$1).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadius$$anonfun$11$$anonfun$1(Object key$153, effects.GeoRadius geoRadius$7, GeoArgs.Unit unit$13, effects.GeoRadiusDistStorage storage$3, RedisAsyncCommands c$117) {
        return c$117.georadius(key$153, geoRadius$7.lon(), geoRadius$7.lat(), geoRadius$7.dist(), unit$13, this.GeoRadiusDistStorageOps(storage$3).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadiusByMember$$anonfun$10$$anonfun$1(Object key$155, Object value$37, double dist$5, GeoArgs.Unit unit$15, effects.GeoRadiusKeyStorage storage$5, RedisClusterAsyncCommands c$118) {
        return c$118.georadiusbymember(key$155, value$37, dist$5, unit$15, this.GeoRadiusKeyStorageOps(storage$5).asGeoRadiusStoreArgs());
    }

    private final RedisFuture geoRadiusByMember$$anonfun$11$$anonfun$1(Object key$157, Object value$39, double dist$7, GeoArgs.Unit unit$17, effects.GeoRadiusDistStorage storage$7, RedisClusterAsyncCommands c$119) {
        return c$119.georadiusbymember(key$157, value$39, dist$7, unit$17, this.GeoRadiusDistStorageOps(storage$7).asGeoRadiusStoreArgs());
    }

    private static final RedisFuture $anonfun$27$$anonfun$2(Object key$159, Seq values$17, ZAddArgs x$1, RedisClusterAsyncCommands c$120) {
        return c$120.zadd(key$159, x$1, (ScoredValue[])Arrays$.MODULE$.seqToArray((Seq)values$17.map((Function1 & Serializable)s -> ScoredValue.just((double)s.score(), s.value())), ScoredValue.class));
    }

    private static final RedisFuture $anonfun$29$$anonfun$2(Object key$161, Seq values$19, RedisClusterAsyncCommands c$121) {
        return c$121.zadd(key$161, (ScoredValue[])Arrays$.MODULE$.seqToArray((Seq)values$19.map((Function1 & Serializable)s -> ScoredValue.just((double)s.score(), s.value())), ScoredValue.class));
    }

    private static final RedisFuture $anonfun$30$$anonfun$1(Object key$163, effects.ScoreWithValue member$1, ZAddArgs x$3, RedisClusterAsyncCommands c$122) {
        return c$122.zaddincr(key$163, x$3, member$1.score(), member$1.value());
    }

    private static final RedisFuture $anonfun$31$$anonfun$1(Object key$165, effects.ScoreWithValue member$3, RedisClusterAsyncCommands c$123) {
        return c$123.zaddincr(key$165, member$3.score(), member$3.value());
    }

    private static final RedisFuture zIncrBy$$anonfun$3$$anonfun$1(Object key$167, Object member$5, double amount$11, RedisClusterAsyncCommands c$124) {
        return c$124.zincrby(key$167, amount$11, member$5);
    }

    private static final RedisFuture $anonfun$32$$anonfun$1(Object destination$21, Seq keys$23, ZStoreArgs x$5, RedisClusterAsyncCommands c$125) {
        return c$125.zinterstore(destination$21, x$5, (Object[])Arrays$.MODULE$.seqToArray(keys$23, Object.class));
    }

    private static final RedisFuture $anonfun$33$$anonfun$1(Object destination$23, Seq keys$25, RedisClusterAsyncCommands c$126) {
        return c$126.zinterstore(destination$23, (Object[])Arrays$.MODULE$.seqToArray(keys$25, Object.class));
    }

    private static final RedisFuture zRem$$anonfun$3$$anonfun$1(Object key$169, Seq values$21, RedisClusterAsyncCommands c$127) {
        return c$127.zrem(key$169, (Object[])Arrays$.MODULE$.seqToArray(values$21, Object.class));
    }

    private static final RedisFuture zRemRangeByLex$$anonfun$3$$anonfun$1(Object key$171, effects.ZRange range$1, RedisClusterAsyncCommands c$128) {
        return c$128.zremrangebylex(key$171, Range.create(range$1.start(), range$1.end()));
    }

    private static final RedisFuture zRemRangeByRank$$anonfun$3$$anonfun$1(Object key$173, long start$13, long stop$5, RedisClusterAsyncCommands c$129) {
        return c$129.zremrangebyrank(key$173, start$13, stop$5);
    }

    private final RedisFuture zRemRangeByScore$$anonfun$3$$anonfun$1(Object key$175, effects.ZRange range$3, Numeric evidence$16$1, RedisClusterAsyncCommands c$130) {
        return c$130.zremrangebyscore(key$175, this.ZRangeOps(range$3, evidence$16$1).asJavaRange());
    }

    private static final RedisFuture $anonfun$34$$anonfun$1(Object destination$25, Seq keys$27, ZStoreArgs x$7, RedisClusterAsyncCommands c$131) {
        return c$131.zunionstore(destination$25, x$7, (Object[])Arrays$.MODULE$.seqToArray(keys$27, Object.class));
    }

    private static final RedisFuture $anonfun$35$$anonfun$1(Object destination$27, Seq keys$29, RedisClusterAsyncCommands c$132) {
        return c$132.zunionstore(destination$27, (Object[])Arrays$.MODULE$.seqToArray(keys$29, Object.class));
    }

    private static final RedisFuture zCard$$anonfun$3$$anonfun$1(Object key$177, RedisClusterAsyncCommands c$133) {
        return c$133.zcard(key$177);
    }

    private final RedisFuture zCount$$anonfun$3$$anonfun$1(Object key$179, effects.ZRange range$5, Numeric evidence$17$1, RedisClusterAsyncCommands c$134) {
        return c$134.zcount(key$179, this.ZRangeOps(range$5, evidence$17$1).asJavaRange());
    }

    private static final RedisFuture zLexCount$$anonfun$3$$anonfun$1(Object key$181, effects.ZRange range$7, RedisClusterAsyncCommands c$135) {
        return c$135.zlexcount(key$181, Range.create(range$7.start(), range$7.end()));
    }

    private static final RedisFuture zRange$$anonfun$3$$anonfun$1(Object key$183, long start$15, long stop$7, RedisClusterAsyncCommands c$136) {
        return c$136.zrange(key$183, start$15, stop$7);
    }

    private static final RedisFuture $anonfun$36$$anonfun$1(Object key$185, effects.ZRange range$9, effects.RangeLimit x$9, RedisClusterAsyncCommands c$137) {
        return c$137.zrangebylex(key$185, Range.create(range$9.start(), range$9.end()), Limit.create((long)x$9.offset(), (long)x$9.count()));
    }

    private static final RedisFuture $anonfun$37$$anonfun$1(Object key$187, effects.ZRange range$11, RedisClusterAsyncCommands c$138) {
        return c$138.zrangebylex(key$187, Range.create(range$11.start(), range$11.end()));
    }

    private final RedisFuture $anonfun$38$$anonfun$1(Object key$189, effects.ZRange range$13, Numeric evidence$18$1, effects.RangeLimit x$11, RedisClusterAsyncCommands c$139) {
        return c$139.zrangebyscore(key$189, this.ZRangeOps(range$13, evidence$18$1).asJavaRange(), Limit.create((long)x$11.offset(), (long)x$11.count()));
    }

    private final RedisFuture $anonfun$39$$anonfun$1(Object key$191, effects.ZRange range$15, Numeric evidence$18$3, RedisClusterAsyncCommands c$140) {
        return c$140.zrangebyscore(key$191, this.ZRangeOps(range$15, evidence$18$3).asJavaRange());
    }

    private final RedisFuture $anonfun$40$$anonfun$1(Object key$193, effects.ZRange range$17, Numeric evidence$19$1, effects.RangeLimit x$13, RedisClusterAsyncCommands c$141) {
        return c$141.zrangebyscoreWithScores(key$193, this.ZRangeOps(range$17, evidence$19$1).asJavaRange(), Limit.create((long)x$13.offset(), (long)x$13.count()));
    }

    private final RedisFuture $anonfun$41$$anonfun$1(Object key$195, effects.ZRange range$19, Numeric evidence$19$3, RedisClusterAsyncCommands c$142) {
        return c$142.zrangebyscoreWithScores(key$195, this.ZRangeOps(range$19, evidence$19$3).asJavaRange());
    }

    private static final RedisFuture zRangeWithScores$$anonfun$3$$anonfun$1(Object key$197, long start$17, long stop$9, RedisClusterAsyncCommands c$143) {
        return c$143.zrangeWithScores(key$197, start$17, stop$9);
    }

    private static final RedisFuture zRank$$anonfun$3$$anonfun$1(Object key$199, Object value$41, RedisClusterAsyncCommands c$144) {
        return c$144.zrank(key$199, value$41);
    }

    private static final RedisFuture zRevRange$$anonfun$3$$anonfun$1(Object key$201, long start$19, long stop$11, RedisClusterAsyncCommands c$145) {
        return c$145.zrevrange(key$201, start$19, stop$11);
    }

    private static final RedisFuture $anonfun$42$$anonfun$1(Object key$203, effects.ZRange range$21, effects.RangeLimit x$15, RedisClusterAsyncCommands c$146) {
        return c$146.zrevrangebylex(key$203, Range.create(range$21.start(), range$21.end()), Limit.create((long)x$15.offset(), (long)x$15.count()));
    }

    private static final RedisFuture $anonfun$43$$anonfun$1(Object key$205, effects.ZRange range$23, RedisClusterAsyncCommands c$147) {
        return c$147.zrevrangebylex(key$205, Range.create(range$23.start(), range$23.end()));
    }

    private final RedisFuture $anonfun$44$$anonfun$1(Object key$207, effects.ZRange range$25, Numeric evidence$20$1, effects.RangeLimit x$17, RedisClusterAsyncCommands c$148) {
        return c$148.zrevrangebyscore(key$207, this.ZRangeOps(range$25, evidence$20$1).asJavaRange(), Limit.create((long)x$17.offset(), (long)x$17.count()));
    }

    private final RedisFuture $anonfun$45$$anonfun$1(Object key$209, effects.ZRange range$27, Numeric evidence$20$3, RedisClusterAsyncCommands c$149) {
        return c$149.zrevrangebyscore(key$209, this.ZRangeOps(range$27, evidence$20$3).asJavaRange());
    }

    private final RedisFuture $anonfun$46$$anonfun$1(Object key$211, effects.ZRange range$29, Numeric evidence$21$1, effects.RangeLimit x$19, RedisClusterAsyncCommands c$150) {
        return c$150.zrevrangebyscoreWithScores(key$211, this.ZRangeOps(range$29, evidence$21$1).asJavaRange(), Limit.create((long)x$19.offset(), (long)x$19.count()));
    }

    private final RedisFuture $anonfun$47$$anonfun$1(Object key$213, effects.ZRange range$31, Numeric evidence$21$3, RedisClusterAsyncCommands c$151) {
        return c$151.zrangebyscoreWithScores(key$213, this.ZRangeOps(range$31, evidence$21$3).asJavaRange());
    }

    private static final RedisFuture zRevRangeWithScores$$anonfun$3$$anonfun$1(Object key$215, long start$21, long stop$13, RedisClusterAsyncCommands c$152) {
        return c$152.zrevrangeWithScores(key$215, start$21, stop$13);
    }

    private static final RedisFuture zRevRank$$anonfun$3$$anonfun$1(Object key$217, Object value$43, RedisClusterAsyncCommands c$153) {
        return c$153.zrevrank(key$217, value$43);
    }

    private static final RedisFuture zScore$$anonfun$3$$anonfun$1(Object key$219, Object value$45, RedisClusterAsyncCommands c$154) {
        return c$154.zscore(key$219, value$45);
    }

    private static final RedisFuture zPopMin$$anonfun$3$$anonfun$1(Object key$221, long count$7, RedisClusterAsyncCommands c$155) {
        return c$155.zpopmin(key$221, count$7);
    }

    private static final RedisFuture zPopMax$$anonfun$3$$anonfun$1(Object key$223, long count$9, RedisClusterAsyncCommands c$156) {
        return c$156.zpopmax(key$223, count$9);
    }

    private final RedisFuture bzPopMin$$anonfun$3$$anonfun$1(Duration timeout$7, NonEmptyList keys$31, RedisClusterAsyncCommands c$157) {
        return c$157.bzpopmin(this.DurationOps(timeout$7).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$31.toList(), Object.class));
    }

    private final RedisFuture bzPopMax$$anonfun$3$$anonfun$1(Duration timeout$9, NonEmptyList keys$33, RedisClusterAsyncCommands c$158) {
        return c$158.bzpopmax(this.DurationOps(timeout$9).toSecondsOrZero(), (Object[])Arrays$.MODULE$.seqToArray((Seq)keys$33.toList(), Object.class));
    }

    private static final RedisFuture select$$anonfun$2$$anonfun$1(int index$5, RedisAsyncCommands c$159) {
        return c$159.select(index$5);
    }

    private static final RedisFuture auth$$anonfun$5$$anonfun$1(CharSequence password$1, RedisClusterAsyncCommands c$160) {
        return c$160.auth(password$1);
    }

    private static final RedisFuture auth$$anonfun$6$$anonfun$1(String username$1, CharSequence password$3, RedisClusterAsyncCommands c$161) {
        return c$161.auth(username$1, password$3);
    }

    private static final RedisFuture keys$$anonfun$3$$anonfun$1(Object key$225, RedisClusterAsyncCommands c$162) {
        return c$162.keys(key$225);
    }

    private static final RedisFuture info$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands c$163) {
        return c$163.info();
    }

    private static final scala.collection.immutable.Map info$$anonfun$5$$anonfun$2(String info$1) {
        return Predef$.MODULE$.wrapRefArray((Object[])info$1.split("\\r?\\n")).toList().map((Function1 & Serializable)_$57 -> Predef$.MODULE$.wrapRefArray((Object[])_$57.split(":", 2)).toList()).collect((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List x) {
                List list = x;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                String k = (String)colon2.head();
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                List list3 = colon3.next$access$1();
                String v = (String)colon3.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (nil$ != null) {
                    if (!nil$.equals(list4)) return false;
                    return true;
                }
                if (list4 == null) return true;
                return false;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(List x, Function1 function1) {
                Object object;
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    String k = (String)colon2.head();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String v = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            object = Tuple2$.MODULE$.apply((Object)k, (Object)v);
                            return object;
                        }
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final RedisFuture dbsize$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands c$164) {
        return c$164.dbsize();
    }

    private static final RedisFuture lastSave$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands c$165) {
        return c$165.lastsave();
    }

    private static final RedisFuture slowLogLen$$anonfun$3$$anonfun$1(RedisClusterAsyncCommands c$166) {
        return c$166.slowlogLen();
    }

    private static final RedisFuture eval$$anonfun$7$$anonfun$1(String script$1, effects.ScriptOutputType output$1, RedisClusterAsyncCommands c$167) {
        return c$167.eval(script$1, output$1.outputType(), new Object[0]);
    }

    private static final RedisFuture eval$$anonfun$8$$anonfun$1(String script$3, effects.ScriptOutputType output$4, List keys$35, RedisClusterAsyncCommands c$168) {
        return c$168.eval(script$3, output$4.outputType(), (Object[])keys$35.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture eval$$anonfun$9$$anonfun$1(String script$5, effects.ScriptOutputType output$7, List keys$37, List values$23, RedisClusterAsyncCommands c$169) {
        return c$169.eval(script$5, output$7.outputType(), (Object[])keys$37.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$23, Object.class));
    }

    private static final RedisFuture evalSha$$anonfun$7$$anonfun$1(String digest$1, effects.ScriptOutputType output$10, RedisClusterAsyncCommands c$170) {
        return c$170.evalsha(digest$1, output$10.outputType(), new Object[0]);
    }

    private static final RedisFuture evalSha$$anonfun$8$$anonfun$1(String digest$3, effects.ScriptOutputType output$13, List keys$39, RedisClusterAsyncCommands c$171) {
        return c$171.evalsha(digest$3, output$13.outputType(), (Object[])keys$39.toArray(ClassTag$.MODULE$.Any()), new Object[0]);
    }

    private static final RedisFuture evalSha$$anonfun$9$$anonfun$1(String digest$5, effects.ScriptOutputType output$16, List keys$41, List values$25, RedisClusterAsyncCommands c$172) {
        return c$172.evalsha(digest$5, output$16.outputType(), (Object[])keys$41.toArray(ClassTag$.MODULE$.Any()), (Object[])Arrays$.MODULE$.seqToArray((Seq)values$25, Object.class));
    }

    private static final RedisFuture scriptLoad$$anonfun$3$$anonfun$1(String script$7, RedisClusterAsyncCommands c$173) {
        return c$173.scriptLoad(script$7);
    }

    private static final RedisFuture scriptLoad$$anonfun$4$$anonfun$1(byte[] script$9, RedisClusterAsyncCommands c$174) {
        return c$174.scriptLoad(script$9);
    }

    private static final RedisFuture scriptExists$$anonfun$3$$anonfun$1(Seq digests$1, RedisClusterAsyncCommands c$175) {
        return c$175.scriptExists((String[])Arrays$.MODULE$.seqToArray(digests$1, String.class));
    }

    private static final RedisFuture scriptFlush$$anonfun$2$$anonfun$1(RedisClusterAsyncCommands c$176) {
        return c$176.scriptFlush();
    }

    private static final String digest$$anonfun$2$$anonfun$1(String script$11, RedisClusterAsyncCommands c$177) {
        return c$177.digest(script$11);
    }

    private static final RedisFuture pfAdd$$anonfun$3$$anonfun$1(Object key$227, Seq values$27, RedisClusterAsyncCommands c$178) {
        return c$178.pfadd(key$227, (Object[])Arrays$.MODULE$.seqToArray(values$27, Object.class));
    }

    private static final RedisFuture pfCount$$anonfun$3$$anonfun$1(Object key$229, RedisClusterAsyncCommands c$179) {
        return c$179.pfcount(new Object[]{key$229});
    }

    private static final RedisFuture pfMerge$$anonfun$2$$anonfun$1(Object outputKey$1, Seq inputKeys$1, RedisClusterAsyncCommands c$180) {
        return c$180.pfmerge(outputKey$1, (Object[])Arrays$.MODULE$.seqToArray(inputKeys$1, Object.class));
    }
}

