/*
 * Decompiled with CFR 0.152.
 */
package dev.pitlor.gamekit_spring_boot_starter;

import dev.pitlor.gamekit_spring_boot_starter.implementations.User;
import java.security.Principal;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.StompWebSocketEndpointRegistration;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Ldev/pitlor/gamekit_spring_boot_starter/SocketConfig;", "Lorg/springframework/web/socket/config/annotation/WebSocketMessageBrokerConfigurer;", "()V", "configureClientInboundChannel", "", "registration", "Lorg/springframework/messaging/simp/config/ChannelRegistration;", "configureMessageBroker", "registry", "Lorg/springframework/messaging/simp/config/MessageBrokerRegistry;", "registerStompEndpoints", "Lorg/springframework/web/socket/config/annotation/StompEndpointRegistry;", "gamekit-spring-boot-starter"})
public class SocketConfig
implements WebSocketMessageBrokerConfigurer {
    public void configureMessageBroker(@NotNull MessageBrokerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String[] stringArray = new String[]{"/topic"};
        registry.enableSimpleBroker(stringArray);
        stringArray = new String[]{"/app", "/topic"};
        registry.setApplicationDestinationPrefixes(stringArray);
    }

    public void registerStompEndpoints(@NotNull StompEndpointRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String[] stringArray = new String[]{"/websocket-server"};
        StompWebSocketEndpointRegistration stompWebSocketEndpointRegistration = registry.addEndpoint(stringArray);
        stringArray = new String[]{"*"};
        stompWebSocketEndpointRegistration.setAllowedOriginPatterns(stringArray).withSockJS();
    }

    public void configureClientInboundChannel(@NotNull ChannelRegistration registration) {
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        ChannelInterceptor[] channelInterceptorArray = new ChannelInterceptor[]{new ChannelInterceptor(){

            @NotNull
            public Message<?> preSend(@NotNull Message<?> message, @NotNull MessageChannel channel) {
                Intrinsics.checkNotNullParameter(message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                StompHeaderAccessor stompHeaderAccessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
                Intrinsics.checkNotNull((Object)stompHeaderAccessor);
                StompHeaderAccessor accessor = stompHeaderAccessor;
                if (accessor.getCommand() == StompCommand.CONNECT) {
                    Object object = accessor.getNativeHeader("uuid");
                    String uuid = object == null ? null : (String)object.get(0);
                    object = UUID.fromString(uuid);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(uuid)");
                    accessor.setUser((Principal)new User((UUID)object));
                }
                return message;
            }
        }};
        registration.interceptors(channelInterceptorArray);
    }
}

