/*
 * Decompiled with CFR 0.152.
 */
package dev.pitlor.gamekit_spring_boot_starter.implementations;

import dev.pitlor.gamekit_spring_boot_starter.implementations.Server;
import dev.pitlor.gamekit_spring_boot_starter.interfaces.IGame;
import dev.pitlor.gamekit_spring_boot_starter.interfaces.IGameRepository;
import dev.pitlor.gamekit_spring_boot_starter.interfaces.IPlayer;
import dev.pitlor.gamekit_spring_boot_starter.interfaces.IServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(value={IServer.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u0012$\u0010\r\u001a \u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J,\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\"\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\r\u001a \u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Ldev/pitlor/gamekit_spring_boot_starter/implementations/Server;", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IServer;", "gameRepository", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IGameRepository;", "gameFactory", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "code", "Ljava/util/UUID;", "adminId", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IGame;", "playerFactory", "", "", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IPlayer;", "(Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IGameRepository;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "becomeAdmin", "gameCode", "userId", "(Ljava/lang/String;Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createGame", "adminUserId", "findCodeOfGameWithPlayer", "id", "getGame", "getGameCodes", "", "joinGame", "", "settings", "updateSettings", "newSettings", "gamekit-spring-boot-starter"})
public class Server
implements IServer {
    @NotNull
    private final IGameRepository gameRepository;
    @NotNull
    private final Function2<String, UUID, IGame> gameFactory;
    @NotNull
    private final Function2<UUID, Map<String, Object>, IPlayer> playerFactory;
    @NotNull
    private final Mutex mutex;

    public Server(@NotNull IGameRepository gameRepository, @NotNull Function2<? super String, ? super UUID, ? extends IGame> gameFactory2, @NotNull Function2<? super UUID, ? super Map<String, Object>, ? extends IPlayer> playerFactory2) {
        Intrinsics.checkNotNullParameter((Object)gameRepository, (String)"gameRepository");
        Intrinsics.checkNotNullParameter(gameFactory2, (String)"gameFactory");
        Intrinsics.checkNotNullParameter(playerFactory2, (String)"playerFactory");
        this.gameRepository = gameRepository;
        this.gameFactory = gameFactory2;
        this.playerFactory = playerFactory2;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public String findCodeOfGameWithPlayer(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        IGame iGame = (IGame)CollectionsKt.firstOrNull(this.gameRepository.findAll((Function1<? super IGame, Boolean>)((Function1)new Function1<IGame, Boolean>(id){
            final /* synthetic */ UUID $id;
            {
                this.$id = $id;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull IGame game) {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)game, (String)"game");
                    Iterable iterable = game.getPlayers();
                    UUID uUID = this.$id;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IPlayer it = (IPlayer)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)uUID)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        })));
        return iGame == null ? null : iGame.getCode();
    }

    @Override
    public void updateSettings(@NotNull String gameCode, @NotNull UUID userId, @NotNull Map<String, Object> newSettings) {
        Object v0;
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter(newSettings, (String)"newSettings");
            IGame game = this.gameRepository.getByCode(gameCode);
            boolean bl2 = game != null;
            boolean bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "That game doesn't exist";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable iterable = game.getPlayers();
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            for (Object t : iterable2) {
                IPlayer it = (IPlayer)t;
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)userId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        IPlayer player = v0;
        boolean bl7 = player != null;
        bl = false;
        boolean bl8 = false;
        if (!bl7) {
            boolean bl9 = false;
            String string = "That player doesn't exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        player.setSettings(newSettings);
    }

    @Override
    @NotNull
    public IGame getGame(@NotNull String gameCode) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        IGame game = this.gameRepository.getByCode(gameCode);
        boolean bl = game != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "That game doesn't exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return game;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getGameCodes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.gameRepository.getAllByNotStarted();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IGame iGame = (IGame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getCode();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String createGame(@NotNull String gameCode, @NotNull UUID adminUserId) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        Intrinsics.checkNotNullParameter((Object)adminUserId, (String)"adminUserId");
        CharSequence charSequence = gameCode;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Code is empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.gameRepository.getByCode(gameCode) == null;
        bl = false;
        bl3 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "That game does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        IGame game = (IGame)this.gameFactory.invoke((Object)gameCode, (Object)adminUserId);
        this.gameRepository.add(game);
        return "Game \"" + gameCode + "\" Created";
    }

    @Override
    public void joinGame(@NotNull String gameCode, @NotNull UUID userId, @NotNull Map<String, Object> settings) {
        Object v0;
        boolean bl;
        IGame game;
        block4: {
            Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter(settings, (String)"settings");
            game = this.gameRepository.getByCode(gameCode);
            CharSequence charSequence = gameCode;
            bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Code is empty";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = game != null;
            bl = false;
            bl3 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "That game does not exist";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable iterable = game.getPlayers();
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            for (Object t : iterable2) {
                IPlayer it = (IPlayer)t;
                boolean bl6 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)userId)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        boolean bl7 = v0 == null;
        bl = false;
        boolean bl8 = false;
        if (!bl7) {
            boolean bl9 = false;
            String string = "You are already in that game!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map<String, Object> map = settings;
        Object object = "connected";
        Object object2 = true;
        boolean bl10 = false;
        map.put((String)object, object2);
        IPlayer player = (IPlayer)this.playerFactory.invoke((Object)userId, settings);
        object = game;
        object2 = object.getPlayers();
        bl10 = false;
        object2.add(player);
    }

    @Override
    @Nullable
    public Object becomeAdmin(@NotNull String gameCode, @NotNull UUID userId, @NotNull Continuation<? super String> $completion) {
        return Server.becomeAdmin$suspendImpl(this, gameCode, userId, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object becomeAdmin$suspendImpl(Server var0, String var1_1, UUID var2_2, Continuation var3_3) {
        if (!(var3_3 instanceof becomeAdmin.1)) ** GOTO lbl-1000
        var20_4 = var3_3;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super becomeAdmin.1>)var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ Server this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Server.becomeAdmin$suspendImpl(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                var7_10 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = gameCode;
                $continuation.L$2 = userId;
                $continuation.L$3 = $this$withLock$iv;
                $continuation.label = 1;
                v0 = $this$withLock$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock$iv = (Mutex)$continuation.L$3;
                userId = (UUID)$continuation.L$2;
                gameCode = (String)$continuation.L$1;
                this = (Server)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                try {
                    $i$a$-withLock$default-Server$becomeAdmin$2 = false;
                    game = this.gameRepository.getByCode(gameCode);
                    var10_15 = game != null;
                    var11_18 = false;
                    var12_21 = false;
                    if (!var10_15) {
                        $i$a$-require-Server$becomeAdmin$2$1 = false;
                        var12_22 = "That game doesn't exist";
                        throw (Throwable)new IllegalArgumentException(var12_22.toString());
                    }
                    var11_19 = game.getPlayers();
                    var12_21 = false;
                    $i$a$-require-Server$becomeAdmin$2$1 = var11_19;
                    var14_27 = false;
                    for (T var16_29 : $i$a$-require-Server$becomeAdmin$2$1) {
                        it = (IPlayer)var16_29;
                        $i$a$-find-Server$becomeAdmin$2$2 = false;
                        if (!Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)it.getId(), (Object)game.getAdminId())).booleanValue()) continue;
                        v1 = var16_29;
                        ** GOTO lbl56
                    }
                    v1 = null;
lbl56:
                    // 2 sources

                    var10_16 = v1;
                    var10_17 = (var10_16 == null ? null : var10_16.getStartOfTimeOffline()) == null;
                    var11_20 = false;
                    var12_21 = false;
                    if (!var10_17) {
                        $i$a$-check-Server$becomeAdmin$2$3 = false;
                        var12_23 = "Someone already claimed the admin spot";
                        throw (Throwable)new IllegalStateException(var12_23.toString());
                    }
                    game.setAdminId(userId);
                    var7_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock$iv.unlock(owner$iv);
                }
                return "You are now the game admin";
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

