/*
 * Decompiled with CFR 0.152.
 */
package dev.pitlor.gamekit_spring_boot_starter.implementations;

import dev.pitlor.gamekit_spring_boot_starter.interfaces.IGame;
import dev.pitlor.gamekit_spring_boot_starter.interfaces.IGameRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="dev.pitlor", name={"persistenceStrategy"}, havingValue="memory", matchIfMissing=true)
@ConditionalOnMissingBean(value={IGameRepository.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/pitlor/gamekit_spring_boot_starter/implementations/MemoryGameRepository;", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IGameRepository;", "()V", "games", "Ljava/util/ArrayList;", "Ldev/pitlor/gamekit_spring_boot_starter/interfaces/IGame;", "Lkotlin/collections/ArrayList;", "add", "", "game", "findAll", "", "filter", "Lkotlin/Function1;", "", "getAllByNotStarted", "getByCode", "gameCode", "", "removeByCode", "gamekit-spring-boot-starter"})
public final class MemoryGameRepository
implements IGameRepository {
    @NotNull
    private final ArrayList<IGame> games;

    public MemoryGameRepository() {
        boolean bl = false;
        this.games = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IGame> findAll(@NotNull Function1<? super IGame, Boolean> filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Iterable $this$filter$iv = this.games;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IGame> getAllByNotStarted() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.games;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IGame it = (IGame)element$iv$iv;
            boolean bl = false;
            if (!(!it.isActive())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public IGame getByCode(@NotNull String gameCode) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
            Iterable iterable = this.games;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IGame it = (IGame)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)gameCode)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void add(@NotNull IGame game) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        MemoryGameRepository memoryGameRepository = this;
        Collection collection = memoryGameRepository.games;
        boolean bl = false;
        collection.add(game);
    }

    @Override
    public void removeByCode(@NotNull String gameCode) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        CollectionsKt.removeAll((List)this.games, (Function1)((Function1)new Function1<IGame, Boolean>(gameCode){
            final /* synthetic */ String $gameCode;
            {
                this.$gameCode = $gameCode;
                super(1);
            }

            public final boolean invoke(@NotNull IGame it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getCode(), (Object)this.$gameCode);
            }
        }));
    }
}

