/*
 * Decompiled with CFR 0.152.
 */
package dev.pitlor.gamekit_spring_boot_starter;

import dev.pitlor.gamekit_spring_boot_starter.Game;
import dev.pitlor.gamekit_spring_boot_starter.Server;
import dev.pitlor.gamekit_spring_boot_starter.User;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.socket.messaging.SessionConnectEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@Controller
@ConditionalOnBean(value={Server.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\t\u001a\u00020\bH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0007J2\u0010\u0012\u001a\u00020\u000f2\b\b\u0001\u0010\t\u001a\u00020\b2\u0014\b\u0001\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00142\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u0014\u0010\u0015\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0007J\u0014\u0010\u0019\u001a\u00020\b2\n\u0010\u0016\u001a\u00060\u001aj\u0002`\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020 H\u0007J2\u0010!\u001a\u00020\u000f2\b\b\u0001\u0010\t\u001a\u00020\b2\u0014\b\u0001\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00142\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/pitlor/gamekit_spring_boot_starter/BaseController;", "", "server", "Ldev/pitlor/gamekit_spring_boot_starter/Server;", "socket", "Lorg/springframework/messaging/simp/SimpMessagingTemplate;", "(Ldev/pitlor/gamekit_spring_boot_starter/Server;Lorg/springframework/messaging/simp/SimpMessagingTemplate;)V", "becomeAdmin", "", "gameCode", "user", "Ldev/pitlor/gamekit_spring_boot_starter/User;", "createGame", "findLastGame", "getGame", "Ldev/pitlor/gamekit_spring_boot_starter/Game;", "getGames", "", "joinGame", "settings", "", "on400Error", "e", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "on500Error", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "onConnect", "", "Lorg/springframework/web/socket/messaging/SessionConnectEvent;", "onDisconnect", "Lorg/springframework/web/socket/messaging/SessionDisconnectEvent;", "updateSettings", "gamekit-spring-boot-starter"})
public final class BaseController {
    @NotNull
    private final Server server;
    @NotNull
    private final SimpMessagingTemplate socket;

    public BaseController(@NotNull Server server, @NotNull SimpMessagingTemplate socket) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.server = server;
        this.socket = socket;
    }

    @EventListener
    public final void onConnect(@NotNull SessionConnectEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getUser() == null) {
            return;
        }
        Object object = e.getUser();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type dev.pitlor.gamekit_spring_boot_starter.User");
        }
        User user = (User)object;
        if ((object = this.server.findCodeOfGameWithPlayer(user.getId())) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"connected", (Object)true)};
            this.server.updateSettings((String)it, user.getId(), MapsKt.mutableMapOf((Pair[])pairArray));
            this.socket.convertAndSend((Object)Intrinsics.stringPlus((String)"/topic/games/", (Object)it), (Object)this.server.getGame((String)it));
        }
    }

    @EventListener
    public final void onDisconnect(@NotNull SessionDisconnectEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getUser() == null) {
            return;
        }
        Object object = e.getUser();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type dev.pitlor.gamekit_spring_boot_starter.User");
        }
        User user = (User)object;
        if ((object = this.server.findCodeOfGameWithPlayer(user.getId())) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"connected", (Object)false)};
            this.server.updateSettings((String)it, user.getId(), MapsKt.mutableMapOf((Pair[])pairArray));
            this.socket.convertAndSend((Object)Intrinsics.stringPlus((String)"/topic/games/", (Object)it), (Object)this.server.getGame((String)it));
        }
    }

    @MessageExceptionHandler
    @SendToUser(value={"/topic/errors/client"})
    @NotNull
    public final String on400Error(@NotNull IllegalArgumentException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getMessage();
        return string == null ? "" : string;
    }

    @MessageExceptionHandler
    @SendToUser(value={"/topic/errors/server"})
    @NotNull
    public final String on500Error(@NotNull IllegalStateException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getMessage();
        return string == null ? "" : string;
    }

    @SubscribeMapping(value={"/rejoin-game"})
    @Nullable
    public final String findLastGame(@ModelAttribute @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.server.findCodeOfGameWithPlayer(user.getId());
    }

    @SubscribeMapping(value={"/games"})
    @NotNull
    public final Iterable<String> getGames() {
        return this.server.getGameCodes();
    }

    @SubscribeMapping(value={"/games/{gameCode}"})
    @NotNull
    public final Game getGame(@DestinationVariable @NotNull String gameCode) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        return this.server.getGame(gameCode);
    }

    @MessageMapping(value={"/games/{gameCode}/create"})
    @SendToUser(value={"/topic/successes"})
    @NotNull
    public final String createGame(@DestinationVariable @NotNull String gameCode, @ModelAttribute @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        String response = this.server.createGame(gameCode, user.getId());
        this.socket.convertAndSend((Object)"/topic/games", this.server.getGameCodes());
        return response;
    }

    @MessageMapping(value={"/games/{gameCode}/join"})
    @SendTo(value={"/topic/games/{gameCode}"})
    @NotNull
    public final Game joinGame(@DestinationVariable @NotNull String gameCode, @Payload @NotNull Map<String, Object> settings, @ModelAttribute @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.server.joinGame(gameCode, user.getId(), settings);
        return this.server.getGame(gameCode);
    }

    @MessageMapping(value={"/games/{gameCode}/update"})
    @SendTo(value={"/topic/games/{gameCode}"})
    @NotNull
    public final Game updateSettings(@DestinationVariable @NotNull String gameCode, @Payload @NotNull Map<String, Object> settings, @ModelAttribute @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.server.updateSettings(gameCode, user.getId(), settings);
        return this.server.getGame(gameCode);
    }

    @MessageMapping(value={"/games/{gameCode}/become-admin"})
    @SendToUser(value={"/topic/successes"})
    @NotNull
    public final String becomeAdmin(@DestinationVariable @NotNull String gameCode, @ModelAttribute @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)gameCode, (String)"gameCode");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, gameCode, user, null){
            int label;
            final /* synthetic */ BaseController this$0;
            final /* synthetic */ String $gameCode;
            final /* synthetic */ User $user;
            {
                this.this$0 = $receiver;
                this.$gameCode = $gameCode;
                this.$user = $user;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = BaseController.access$getServer$p(this.this$0).becomeAdmin(this.$gameCode, this.$user.getId(), (Continuation<? super String>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        response = (String)v0;
                        BaseController.access$getSocket$p(this.this$0).convertAndSend((Object)Intrinsics.stringPlus((String)"/topic/games/", (Object)this.$gameCode), (Object)BaseController.access$getServer$p(this.this$0).getGame(this.$gameCode));
                        return response;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ Server access$getServer$p(BaseController $this) {
        return $this.server;
    }

    public static final /* synthetic */ SimpMessagingTemplate access$getSocket$p(BaseController $this) {
        return $this.socket;
    }
}

