/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.util;

import dev.piglin.piglinworldapi.PiglinWorldAPI;
import dev.piglin.piglinworldapi.util.PluginsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleportUtils
implements Listener {
    private static final Map<Player, TimedTeleportRecord<?>> timedTeleports = new HashMap();

    public static boolean teleportDelayed(TimedTeleportRecord<?> record, boolean checkPVP) {
        Boolean isInPVP;
        if (checkPVP && (isInPVP = PluginsUtils.antiRelogIsInPVP(record.player())) != null && isInPVP.booleanValue()) {
            return false;
        }
        timedTeleports.put(record.player(), record);
        return true;
    }

    private static void checkTeleports() {
        ArrayList<Player> toRemove = new ArrayList<Player>();
        long now = System.currentTimeMillis();
        timedTeleports.forEach((player, timedTeleportRecord) -> {
            if (now >= timedTeleportRecord.time()) {
                toRemove.add((Player)player);
                if (timedTeleportRecord.onTeleport().apply((TimedTeleportRecord<Object>)timedTeleportRecord).booleanValue()) {
                    player.teleport(timedTeleportRecord.destination());
                }
            }
        });
        toRemove.forEach(timedTeleports::remove);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        TimedTeleportRecord<?> record;
        if (event.getTo() == null) {
            return;
        }
        if ((event.getTo().getX() != event.getFrom().getX() || event.getTo().getY() != event.getFrom().getY() || event.getTo().getZ() != event.getFrom().getZ()) && (record = timedTeleports.remove(event.getPlayer())) != null) {
            record.onCancel().accept(record);
        }
    }

    static {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)PiglinWorldAPI.getInstance(), TeleportUtils::checkTeleports, 1L, 5L);
    }

    public record TimedTeleportRecord<M>(@NotNull Player player, @NotNull Location destination, long time, @NotNull Consumer<TimedTeleportRecord<Object>> onCancel, @NotNull Function<TimedTeleportRecord<Object>, Boolean> onTeleport, @Nullable M meta) {
        public static final Function<TimedTeleportRecord<Object>, Boolean> ALWAYS_TELEPORT = o -> true;
        public static final Consumer<TimedTeleportRecord<Object>> NOOP = o -> {};

        public TimedTeleportRecord(@NotNull Player player, @NotNull Location destination, @NotNull Consumer<TimedTeleportRecord<Object>> onCancel, @NotNull Function<TimedTeleportRecord<Object>, Boolean> onTeleport, @Nullable M meta) {
            this(player, destination, System.currentTimeMillis() + 1000L * PiglinWorldAPI.getInstance().getTeleportDelay(), onCancel, onTeleport, meta);
        }
    }
}

