/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkSpaceForItem(@NotNull Inventory inventory, @Nullable ItemStack item) {
        if (item == null) {
            return true;
        }
        if (inventory.firstEmpty() != -1) return true;
        if (Arrays.stream(inventory.getContents()).filter(arg_0 -> ((ItemStack)item).isSimilar(arg_0)).map(i -> i.getMaxStackSize() - i.getAmount()).reduce(Integer::sum).orElse(0) < item.getAmount()) return false;
        return true;
    }

    public static boolean addEverythingOrNothing(@NotNull Inventory inventory, @Nullable ItemStack item) {
        if (item == null) {
            return true;
        }
        if (!InventoryUtils.checkSpaceForItem(inventory, item)) {
            return false;
        }
        inventory.addItem(new ItemStack[]{item});
        return true;
    }

    public static List<Integer> getSimilarSlots(Inventory inventory, ItemStack item) {
        if (item != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            ItemStack[] items = inventory.getStorageContents();
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null || !item.isSimilar(items[i])) continue;
                list.add(i);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

