/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.util;

import dev.piglin.piglinworldapi.PiglinWorldAPI;
import dev.piglin.piglinworldapi.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class GuiUtils {
    private static Map<Plugin, ItemStack> barriers = new HashMap<Plugin, ItemStack>();

    public static void loadBarrier(Plugin plugin) {
        ItemStack barrier;
        try {
            barrier = GuiUtils.read(plugin.getConfig().getConfigurationSection("gui.barrier"), null, null);
        }
        catch (Exception exception) {
            PiglinWorldAPI.getInstance().getLogger().warning("No gui.barrier in config.yml or I have a problem deserializing it.");
            barrier = new ItemStack(Material.AIR);
        }
        barriers.put(plugin, barrier);
    }

    public static ItemStack read(ConfigurationSection section, HashMap<String, String> replacements, OfflinePlayer player) {
        ItemStack base = null;
        if (section.contains("base")) {
            base = section.getItemStack("base");
        }
        if (base == null) {
            Material material = Material.matchMaterial((String)StringUtils.replace(section.getString("material"), replacements, player));
            base = new ItemStack(material == null ? Material.BARRIER : material, section.getInt("amount", 1));
        }
        return GuiUtils.replace(base, section, replacements, player);
    }

    public static ItemStack replace(ItemStack base, ConfigurationSection section, HashMap<String, String> replacements, OfflinePlayer player) {
        try {
            ItemMeta meta = base.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(StringUtils.replace("&f" + section.getString("name"), replacements, player));
                meta.setLore(Arrays.asList(section.getStringList("lore").stream().map(line -> StringUtils.replace("&7" + line, replacements, player)).collect(Collectors.joining("\n")).split("\n")));
                meta.setCustomModelData(Integer.valueOf(section.getInt("custom model data", 0)));
                meta.addItemFlags(ItemFlag.values());
                base.setItemMeta(meta);
            }
            return base;
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430: " + section.getCurrentPath());
            e.printStackTrace();
            return new ItemStack(Material.AIR);
        }
    }

    public static void fillWithBarriers(@Nullable Plugin plugin, Inventory inventory) {
        GuiUtils.fillWith(GuiUtils.getBarrier(plugin), inventory);
    }

    public static void fillWith(@Nullable ItemStack item, Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
            inventory.setItem(i, item);
        }
    }

    public static ItemStack getBarrier(Plugin plugin) {
        if (!barriers.containsKey(plugin)) {
            GuiUtils.loadBarrier(plugin);
        }
        return barriers.get(plugin);
    }
}

