/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.libs.net.melion.rgbchat.chat;

import dev.piglin.piglinworldapi.libs.net.melion.rgbchat.chat.TextColor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/piglin/piglinworldapi/libs/net/melion/rgbchat/chat/RGBUtils;", "", "()V", "fix2", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "fix3", "gradient1", "gradient2", "hex", "applyFormats", "", "textInput", "asGradient", "start", "Ldev/piglin/piglinworldapi/libs/net/melion/rgbchat/chat/TextColor;", "text", "end", "fixFormat1", "fixFormat2", "input", "fixFormat3", "setGradient1", "setGradient2", "toChatColor", "hexCode", "toChatColorString", "toHexString", "red", "", "green", "blue", "rgb-chat"})
public final class RGBUtils {
    private static final Pattern hex;
    private static final Pattern fix2;
    private static final Pattern fix3;
    private static final Pattern gradient1;
    private static final Pattern gradient2;
    public static final RGBUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final String toChatColor(String hexCode) {
        StringBuilder magic = new StringBuilder("\u00a7x");
        String string = hexCode;
        int n = 1;
        int n2 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
        string = string3;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string4.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "(this as java.lang.String).toCharArray()");
        char[] var3 = cArray;
        int var4 = var3.length;
        n = 0;
        n2 = var4;
        while (n < n2) {
            void var5;
            char c = var3[var5];
            magic.append('\u00a7').append(c);
            ++var5;
        }
        String string5 = magic.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "magic.toString()");
        return string5;
    }

    private final String toHexString(int red, int green, int blue) {
        String s = Integer.toHexString((red << 16) + (green << 8) + blue);
        while (s.length() < 6) {
            s = '0' + s;
        }
        String string = s;
        Intrinsics.checkNotNullExpressionValue(string, "s");
        return string;
    }

    private final String applyFormats(String textInput) {
        String text = textInput;
        text = this.fixFormat1(text);
        text = this.fixFormat2(text);
        text = this.fixFormat3(text);
        text = this.setGradient1(text);
        text = this.setGradient2(text);
        return text;
    }

    @NotNull
    public final String toChatColorString(@NotNull String textInput) {
        Intrinsics.checkNotNullParameter(textInput, "textInput");
        String text = this.applyFormats(textInput);
        Matcher m = hex.matcher(text);
        while (m.find()) {
            String hexcode;
            String string = hexcode = m.group();
            Intrinsics.checkNotNullExpressionValue(string, "hexcode");
            text = StringsKt.replace$default(text, string, this.toChatColor(hexcode), false, 4, null);
        }
        return text;
    }

    private final String fixFormat1(String text) {
        return StringsKt.replace$default(text, "&#", "#", false, 4, null);
    }

    private final String fixFormat2(String input) {
        String text = input;
        Matcher m = fix2.matcher(text);
        while (m.find()) {
            String fixed;
            String string;
            String hexcode = m.group();
            Intrinsics.checkNotNullExpressionValue(hexcode, "hexcode");
            int n = 2;
            int n2 = 8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue(string2.substring(n, n2), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            text = StringsKt.replace$default(text, hexcode, '#' + fixed, false, 4, null);
        }
        return text;
    }

    private final String fixFormat3(String text) {
        String text2 = text;
        text2 = StringsKt.replace$default(text2, '\u00a7', '&', false, 4, null);
        Matcher m = fix3.matcher(text2);
        while (m.find()) {
            String hexcode = m.group();
            char[] cArray = new char[]{hexcode.charAt(3), hexcode.charAt(5), hexcode.charAt(7), hexcode.charAt(9), hexcode.charAt(11), hexcode.charAt(13)};
            boolean bl = false;
            String fixed = new String(cArray);
            String string = hexcode;
            Intrinsics.checkNotNullExpressionValue(string, "hexcode");
            text2 = StringsKt.replace$default(text2, string, '#' + fixed, false, 4, null);
        }
        return text2;
    }

    private final String setGradient1(String input) {
        String text = input;
        Matcher m = gradient1.matcher(text);
        while (m.find()) {
            String message;
            String string;
            String format = m.group();
            Intrinsics.checkNotNullExpressionValue(format, "format");
            int n = 2;
            int n2 = 8;
            int n3 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            TextColor start = new TextColor(string3);
            String string4 = format;
            n2 = 9;
            n3 = format.length() - 10;
            int n4 = 0;
            Intrinsics.checkNotNullExpressionValue(string4.substring(n2, n3), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = format;
            n3 = format.length() - 7;
            n4 = format.length() - 1;
            boolean bl = false;
            String string6 = string5.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            TextColor end = new TextColor(string6);
            String applied = this.asGradient(start, message, end);
            text = StringsKt.replace$default(text, format, applied, false, 4, null);
        }
        return text;
    }

    private final String setGradient2(String input) {
        String text = input;
        Matcher m = gradient2.matcher(text);
        while (m.find()) {
            String message;
            String string;
            String format = m.group();
            Intrinsics.checkNotNullExpressionValue(format, "format");
            int n = 2;
            int n2 = 8;
            int n3 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            TextColor start = new TextColor(string3);
            String string4 = format;
            n2 = 10;
            n3 = format.length() - 10;
            int n4 = 0;
            Intrinsics.checkNotNullExpressionValue(string4.substring(n2, n3), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = format;
            n3 = format.length() - 8;
            n4 = format.length() - 2;
            boolean bl = false;
            String string6 = string5.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            TextColor end = new TextColor(string6);
            String applied = this.asGradient(start, message, end);
            text = StringsKt.replace$default(text, format, applied, false, 4, null);
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final String asGradient(TextColor start, String text, TextColor end) {
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            int red = (int)((float)start.getRed() + (float)(end.getRed() - start.getRed()) / (float)(length - 1) * (float)i);
            int green = (int)((float)start.getGreen() + (float)(end.getGreen() - start.getGreen()) / (float)(length - 1) * (float)i);
            int blue = (int)((float)start.getBlue() + (float)(end.getBlue() - start.getBlue()) / (float)(length - 1) * (float)i);
            sb.append("#" + this.toHexString(red, green, blue) + text.charAt((int)i));
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private RGBUtils() {
    }

    static {
        RGBUtils rGBUtils;
        INSTANCE = rGBUtils = new RGBUtils();
        hex = Pattern.compile("#[0-9a-fA-F]{6}");
        fix2 = Pattern.compile("\\{#[0-9a-fA-F]{6}\\}");
        fix3 = Pattern.compile("\\&x[\\&0-9a-fA-F]{12}");
        gradient1 = Pattern.compile("<#[0-9a-fA-F]{6}>[^<]*</#[0-9a-fA-F]{6}>");
        gradient2 = Pattern.compile("\\{#[0-9a-fA-F]{6}>\\}[^\\{]*\\{#[0-9a-fA-F]{6}<\\}");
    }
}

