/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.gui;

import dev.piglin.piglinworldapi.gui.CustomGui;
import dev.piglin.piglinworldapi.util.GuiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class ListGui<T>
extends CustomGui {
    protected final int rows;
    protected final String name;
    protected final List<Integer> listSlots;
    protected final int prevSlot;
    protected final int nextSlot;
    protected final ItemStack prevItem;
    protected final ItemStack nextItem;
    protected final ItemStack noPrevItem;
    protected final ItemStack noNextItem;
    protected final HashMap<Inventory, List<T>> lists = new HashMap();
    protected final HashMap<Inventory, Integer> pages = new HashMap();
    private final Plugin plugin;

    public ListGui(final List<Integer> listSlots, final int prev, final int next, ItemStack prevItem, ItemStack nextItem, ItemStack noPrevItem, ItemStack noNextItem, String name, Plugin plugin) {
        super((List<Integer>)new ArrayList<Integer>(listSlots.size() + 2){
            {
                super(arg0);
                assert (!listSlots.contains(prev) && !listSlots.contains(next));
                this.addAll(listSlots);
                this.add(prev);
                this.add(next);
            }
        });
        Integer max = (Integer)Collections.max(this.allowedSlots);
        int rows = max / 9 + 1;
        assert (rows > 6);
        this.rows = rows;
        this.name = name;
        this.listSlots = listSlots;
        this.prevSlot = prev;
        this.nextSlot = next;
        this.prevItem = prevItem;
        this.nextItem = nextItem;
        this.noPrevItem = noPrevItem;
        this.noNextItem = noNextItem;
        this.plugin = plugin;
    }

    @Override
    public CustomGui.ClickResult onItemClick(InventoryClickEvent event) {
        event.setCancelled(true);
        int pageChange = 0;
        if (this.listSlots.contains(event.getSlot()) && this.listSlots.indexOf(event.getSlot()) < this.lists.get(event.getInventory()).size()) {
            T item = this.lists.get(event.getInventory()).get(this.listSlots.indexOf(event.getSlot()));
            return this.onClick(item, (Player)event.getWhoClicked(), event.getInventory(), event.getClick());
        }
        if (event.getSlot() == this.prevSlot && this.pages.get(event.getInventory()) > 0) {
            pageChange = -1;
        } else if (event.getSlot() == this.nextSlot && (this.pages.get(event.getInventory()) + 1) * this.listSlots.size() < this.lists.get(event.getInventory()).size()) {
            pageChange = 1;
        }
        if (pageChange != 0) {
            ItemMeta nextMeta;
            Inventory inventory = event.getInventory();
            List<T> items = this.getItems((Player)event.getWhoClicked());
            int page = this.pages.get(inventory) + pageChange;
            this.lists.put(inventory, items);
            this.pages.put(inventory, page);
            int i = 0;
            for (int slot : this.listSlots) {
                ItemStack item = i + page * this.listSlots.size() >= items.size() ? new ItemStack(Material.AIR) : this.display((Player)event.getWhoClicked(), items.get(i + page * this.listSlots.size()));
                inventory.setItem(slot, item);
                ++i;
            }
            ItemStack next = page > 0 ? this.prevItem : this.noPrevItem;
            ItemStack prev = items.size() > this.listSlots.size() ? this.nextItem : this.noNextItem;
            ItemMeta prevMeta = prev.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(prevMeta.getDisplayName().replaceAll("\\{page}", String.valueOf(page)));
                prev.setItemMeta(prevMeta);
            }
            if ((nextMeta = next.getItemMeta()) != null) {
                nextMeta.setDisplayName(nextMeta.getDisplayName().replaceAll("\\{page}", String.valueOf(page + 2)));
                next.setItemMeta(nextMeta);
            }
            inventory.setItem(this.prevSlot, next);
            inventory.setItem(this.nextSlot, prev);
        }
        return new CustomGui.ClickResultNone();
    }

    @Override
    public CustomGui.ClickResult onItemClickInInventory(InventoryClickEvent event) {
        event.setCancelled(true);
        return new CustomGui.ClickResultNone();
    }

    @Override
    public void onItemDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public Inventory open(Player player) {
        ItemMeta nextMeta;
        Inventory inventory = Bukkit.createInventory(null, (int)(this.rows * 9), (String)this.name);
        List<T> items = this.getItems(player);
        int page = 0;
        this.lists.put(inventory, items);
        this.pages.put(inventory, page);
        int i = 0;
        for (int slot : this.listSlots) {
            if (i + page * this.listSlots.size() >= items.size()) break;
            ItemStack item = this.display(player, items.get(i + page * this.listSlots.size()));
            inventory.setItem(slot, item);
            ++i;
        }
        ItemStack next = page > 0 ? this.prevItem : this.noPrevItem;
        ItemStack prev = items.size() > this.listSlots.size() ? this.nextItem : this.noNextItem;
        ItemMeta prevMeta = prev.getItemMeta();
        if (prevMeta != null) {
            prevMeta.setDisplayName(prevMeta.getDisplayName().replaceAll("\\{page}", String.valueOf(page)));
            prev.setItemMeta(prevMeta);
        }
        if ((nextMeta = next.getItemMeta()) != null) {
            nextMeta.setDisplayName(nextMeta.getDisplayName().replaceAll("\\{page}", String.valueOf(page + 2)));
            next.setItemMeta(nextMeta);
        }
        inventory.setItem(this.prevSlot, next);
        inventory.setItem(this.nextSlot, prev);
        GuiUtils.fillWithBarriers(this.plugin, inventory);
        player.openInventory(inventory);
        return inventory;
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        this.lists.remove(event.getInventory());
        this.pages.remove(event.getInventory());
    }

    public abstract List<T> getItems(Player var1);

    public abstract ItemStack display(Player var1, T var2);

    public abstract CustomGui.ClickResult onClick(T var1, Player var2, Inventory var3, ClickType var4);
}

