/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.block;

import dev.piglin.piglinworldapi.PiglinWorldAPI;
import dev.piglin.piglinworldapi.event.BlockRedstoneChangeEvent;
import dev.piglin.piglinworldapi.util.Pair;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class RedstoneListener
implements Listener {
    static HashMap<Block, HashMap<Block, Integer>> blocksRedstoneLevelBySource = new HashMap();
    private static Set<Material> isRedstoneBlock = new HashSet<Material>();

    private static void checkBlockChange(Block block, boolean build, @Nullable Material oldMaterial) {
        if (oldMaterial == null) {
            oldMaterial = block.getType();
        }
        switch (oldMaterial) {
            case REDSTONE_TORCH: 
            case REDSTONE_WALL_TORCH: 
            case REDSTONE_BLOCK: {
                RedstoneListener.handleRedstoneForBlock(block, build ? 0 : 15, build ? 15 : 0, oldMaterial);
                break;
            }
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: 
            case DETECTOR_RAIL: 
            case STONE_PRESSURE_PLATE: 
            case ACACIA_PRESSURE_PLATE: 
            case BIRCH_PRESSURE_PLATE: 
            case DARK_OAK_PRESSURE_PLATE: 
            case JUNGLE_PRESSURE_PLATE: 
            case OAK_PRESSURE_PLATE: 
            case SPRUCE_PRESSURE_PLATE: 
            case COMPARATOR: 
            case REPEATER: {
                Powerable powerable = (Powerable)block.getBlockData();
                if (!powerable.isPowered()) break;
                RedstoneListener.handleRedstoneForBlock(block, build ? 0 : 15, build ? 15 : 0, oldMaterial);
                break;
            }
            case HEAVY_WEIGHTED_PRESSURE_PLATE: 
            case LIGHT_WEIGHTED_PRESSURE_PLATE: 
            case REDSTONE_WIRE: {
                AnaloguePowerable analoguePowerable = (AnaloguePowerable)block.getBlockData();
                if (analoguePowerable.getPower() <= 0) break;
                RedstoneListener.handleRedstoneForBlock(block, build ? 0 : analoguePowerable.getPower(), build ? analoguePowerable.getPower() : 0, oldMaterial);
                break;
            }
        }
    }

    private static void handleRedstoneForBlock(Block block, int oldLevel, int newLevel, @Nullable Material oldMaterial) {
        boolean wasChange;
        World world = block.getWorld();
        boolean wasOn = oldLevel >= 1;
        boolean isOn = newLevel >= 1;
        boolean bl = wasChange = wasOn != isOn;
        if (!wasChange) {
            return;
        }
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        if (oldMaterial == null) {
            oldMaterial = block.getType();
        }
        switch (oldMaterial) {
            case REDSTONE_WIRE: {
                Material above = world.getBlockAt(x, y + 1, z).getType();
                Material westSide = world.getBlockAt(x, y, z + 1).getType();
                Material westSideAbove = world.getBlockAt(x, y + 1, z + 1).getType();
                Material westSideBelow = world.getBlockAt(x, y - 1, z + 1).getType();
                Material eastSide = world.getBlockAt(x, y, z - 1).getType();
                Material eastSideAbove = world.getBlockAt(x, y + 1, z - 1).getType();
                Material eastSideBelow = world.getBlockAt(x, y - 1, z - 1).getType();
                Material northSide = world.getBlockAt(x - 1, y, z).getType();
                Material northSideAbove = world.getBlockAt(x - 1, y + 1, z).getType();
                Material northSideBelow = world.getBlockAt(x - 1, y - 1, z).getType();
                Material southSide = world.getBlockAt(x + 1, y, z).getType();
                Material southSideAbove = world.getBlockAt(x + 1, y + 1, z).getType();
                Material southSideBelow = world.getBlockAt(x + 1, y - 1, z).getType();
                if (!(RedstoneListener.isRedstoneBlock(westSide) || RedstoneListener.isRedstoneBlock(eastSide) || RedstoneListener.isRedstoneBlock(westSideAbove) && westSide != Material.AIR && above == Material.AIR || RedstoneListener.isRedstoneBlock(eastSideAbove) && eastSide != Material.AIR && above == Material.AIR || RedstoneListener.isRedstoneBlock(westSideBelow) && westSide == Material.AIR || RedstoneListener.isRedstoneBlock(eastSideBelow) && eastSide == Material.AIR)) {
                    RedstoneListener.handleDirectWireInput(x - 1, y, z, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + 1, y, z, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x - 1, y - 1, z, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + 1, y - 1, z, block, oldLevel, newLevel);
                }
                if (!(RedstoneListener.isRedstoneBlock(northSide) || RedstoneListener.isRedstoneBlock(southSide) || RedstoneListener.isRedstoneBlock(northSideAbove) && northSide != Material.AIR && above == Material.AIR || RedstoneListener.isRedstoneBlock(southSideAbove) && southSide != Material.AIR && above == Material.AIR || RedstoneListener.isRedstoneBlock(northSideBelow) && northSide == Material.AIR || RedstoneListener.isRedstoneBlock(southSideBelow) && southSide == Material.AIR)) {
                    RedstoneListener.handleDirectWireInput(x, y, z - 1, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x, y, z + 1, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x, y - 1, z - 1, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x, y - 1, z + 1, block, oldLevel, newLevel);
                }
                RedstoneListener.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
                RedstoneListener.handleDirectWireInput(x, y - 1, z, block, oldLevel, newLevel);
                return;
            }
            case COMPARATOR: 
            case REPEATER: {
                Directional diode = (Directional)block.getBlockData();
                BlockFace f = diode.getFacing();
                RedstoneListener.handleDirectWireInput(x - f.getModX(), y, z - f.getModZ(), block, oldLevel, newLevel);
                if (world.getBlockAt(x - f.getModX(), y, z - f.getModZ()).getType().isSolid()) {
                    RedstoneListener.handleDirectWireInput(x - f.getModX() * 2, y, z - f.getModZ() * 2, block, oldLevel, newLevel);
                }
                if (block.getRelative(f).getType() != Material.AIR) {
                    RedstoneListener.handleDirectWireInput(x + f.getModX(), y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + f.getModX(), y + 1, z + f.getModZ(), block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + f.getModX() + 1, y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + f.getModX() - 1, y - 1, z + f.getModZ(), block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + f.getModX() + 1, y - 1, z + f.getModZ() + 1, block, oldLevel, newLevel);
                    RedstoneListener.handleDirectWireInput(x + f.getModX() - 1, y - 1, z + f.getModZ() - 1, block, oldLevel, newLevel);
                }
                return;
            }
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: {
                Directional button = (Directional)block.getBlockData();
                BlockFace face = button.getFacing().getOppositeFace();
                RedstoneListener.handleDirectWireInput(x + face.getModX() * 2, y + face.getModY() * 2, z + face.getModZ() * 2, block, oldLevel, newLevel);
                break;
            }
            case POWERED_RAIL: 
            case ACTIVATOR_RAIL: {
                return;
            }
            case REDSTONE_TORCH: 
            case REDSTONE_WALL_TORCH: {
                if (y + 1 < world.getMaxHeight()) {
                    RedstoneListener.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
                }
                if (y + 2 >= world.getMaxHeight() || !world.getBlockAt(x, y + 1, z).getType().isSolid()) break;
                RedstoneListener.handleDirectWireInput(x, y + 2, z, block, oldLevel, newLevel);
            }
        }
        RedstoneListener.handleDirectWireInput(x - 1, y, z, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x + 1, y, z, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x - 1, y - 1, z, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x + 1, y - 1, z, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y, z - 1, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y, z + 1, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y - 1, z - 1, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y - 1, z + 1, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y + 1, z, block, oldLevel, newLevel);
        RedstoneListener.handleDirectWireInput(x, y - 1, z, block, oldLevel, newLevel);
    }

    private static void handleDirectWireInput(int x, int y, int z, Block sourceBlock, int oldLevel, int newLevel) {
        Block block = sourceBlock.getWorld().getBlockAt(x, y, z);
        if (sourceBlock.equals(block)) {
            return;
        }
        blocksRedstoneLevelBySource.putIfAbsent(block, new HashMap());
        Pair<Block, Integer> level = RedstoneListener.getRedstoneLevel(block);
        if (level == null) {
            blocksRedstoneLevelBySource.get(block).put(sourceBlock, newLevel);
            BlockRedstoneChangeEvent event = new BlockRedstoneChangeEvent(sourceBlock, block, oldLevel, newLevel);
            Bukkit.getPluginManager().callEvent((Event)event);
            return;
        }
        Integer oldLevelRegistered = level.getValue();
        blocksRedstoneLevelBySource.get(block).put(sourceBlock, newLevel);
        Integer newLevelRegistered = RedstoneListener.getRedstoneLevel(block).getValue();
        BlockRedstoneChangeEvent event = new BlockRedstoneChangeEvent(sourceBlock, block, oldLevelRegistered, newLevelRegistered);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    private static Pair<Block, Integer> getRedstoneLevel(Block block) {
        if (!blocksRedstoneLevelBySource.containsKey(block)) {
            return null;
        }
        return blocksRedstoneLevelBySource.get(block).entrySet().stream().max(Map.Entry.comparingByValue()).map(Pair::of).orElse(null);
    }

    public static boolean isRedstoneBlock(Material id) {
        return isRedstoneBlock.contains(id);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        RedstoneListener.checkBlockChange(event.getBlock(), false, null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        RedstoneListener.checkBlockChange(event.getBlock(), true, null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        Bukkit.getScheduler().runTask((Plugin)PiglinWorldAPI.getInstance(), () -> {
            if (event.getBlock().getType() == Material.AIR && (event.getChangedType() == Material.REDSTONE_TORCH || event.getChangedType() == Material.REDSTONE_WALL_TORCH)) {
                RedstoneListener.checkBlockChange(event.getBlock(), false, event.getChangedType());
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        RedstoneListener.handleRedstoneForBlock(event.getBlock(), event.getOldCurrent(), event.getNewCurrent(), null);
    }

    static {
        isRedstoneBlock.add(Material.POWERED_RAIL);
        isRedstoneBlock.add(Material.DETECTOR_RAIL);
        isRedstoneBlock.add(Material.STICKY_PISTON);
        isRedstoneBlock.add(Material.PISTON);
        isRedstoneBlock.add(Material.LEVER);
        isRedstoneBlock.add(Material.STONE_PRESSURE_PLATE);
        isRedstoneBlock.addAll(Tag.WOODEN_PRESSURE_PLATES.getValues());
        isRedstoneBlock.add(Material.REDSTONE_TORCH);
        isRedstoneBlock.add(Material.REDSTONE_WALL_TORCH);
        isRedstoneBlock.add(Material.REDSTONE_WIRE);
        isRedstoneBlock.addAll(Tag.DOORS.getValues());
        isRedstoneBlock.add(Material.TNT);
        isRedstoneBlock.add(Material.DISPENSER);
        isRedstoneBlock.add(Material.NOTE_BLOCK);
        isRedstoneBlock.add(Material.REPEATER);
        isRedstoneBlock.add(Material.TRIPWIRE_HOOK);
        isRedstoneBlock.add(Material.COMMAND_BLOCK);
        isRedstoneBlock.addAll(Tag.BUTTONS.getValues());
        isRedstoneBlock.add(Material.TRAPPED_CHEST);
        isRedstoneBlock.add(Material.HEAVY_WEIGHTED_PRESSURE_PLATE);
        isRedstoneBlock.add(Material.LIGHT_WEIGHTED_PRESSURE_PLATE);
        isRedstoneBlock.add(Material.COMPARATOR);
        isRedstoneBlock.add(Material.REDSTONE_BLOCK);
        isRedstoneBlock.add(Material.HOPPER);
        isRedstoneBlock.add(Material.ACTIVATOR_RAIL);
        isRedstoneBlock.add(Material.DROPPER);
        isRedstoneBlock.add(Material.DAYLIGHT_DETECTOR);
        isRedstoneBlock = EnumSet.copyOf(isRedstoneBlock);
    }
}

