/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.block;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockDataStorage
implements TabExecutor {
    final HashMap<Block, List<String>> data = new HashMap();

    @Deprecated
    public BlockDataStorage(File storage) {
        try {
            FileInputStream stream = new FileInputStream(storage);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])stream.readAllBytes());
            stream.close();
            if (!buf.isReadable()) {
                return;
            }
            int length = buf.readInt();
            for (int i = 0; i < length; ++i) {
                byte[] bytes = new byte[buf.readShort()];
                buf.readBytes(bytes);
                String tag = new String(bytes);
                int locations = buf.readInt();
                for (int j = 0; j < locations; ++j) {
                    byte[] bytes2 = new byte[buf.readShort()];
                    buf.readBytes(bytes2);
                    String world = new String(bytes2);
                    int x = buf.readInt();
                    int y = buf.readInt();
                    int z = buf.readInt();
                    this.set(new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z).getBlock(), tag);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error initializing BlockDataStorage", exception);
        }
    }

    public boolean is(Block block, String tag, Plugin plugin) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)tag);
        Validate.notNull((Object)plugin);
        Validate.isTrue((!tag.isBlank() ? 1 : 0) != 0);
        Validate.isTrue((tag.length() + plugin.getName().length() < Short.MAX_VALUE ? 1 : 0) != 0, (String)"The tag's length + plugin's name length must be less than 32767");
        return this.is(block, plugin.getName() + ":" + tag);
    }

    boolean is(Block block, String tag) {
        List<String> blockTags = this.data.get(block);
        return blockTags != null && blockTags.contains(tag);
    }

    public boolean set(Block block, String tag, Plugin plugin) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)tag);
        Validate.notNull((Object)plugin);
        Validate.isTrue((!tag.isBlank() ? 1 : 0) != 0);
        Validate.isTrue((tag.length() + plugin.getName().length() < Short.MAX_VALUE ? 1 : 0) != 0, (String)"The tag's length + plugin's name length must be less than 32767");
        return this.set(block, plugin.getName() + ":" + tag);
    }

    boolean set(Block block, String tag) {
        if (this.is(block, tag)) {
            return false;
        }
        List<String> tags = this.data.get(block);
        if (tags == null) {
            this.data.put(block, Lists.newArrayList((Object[])new String[]{tag}));
        } else {
            tags.add(tag);
        }
        return true;
    }

    public boolean unset(Block block, String tag, Plugin plugin) {
        Validate.notNull((Object)block);
        Validate.notNull((Object)tag);
        Validate.notNull((Object)plugin);
        Validate.isTrue((!tag.isBlank() ? 1 : 0) != 0);
        Validate.isTrue((tag.length() + plugin.getName().length() < Short.MAX_VALUE ? 1 : 0) != 0, (String)"The tag's length + plugin's name length must be less than 32767");
        return this.unset(block, plugin.getName() + ":" + tag);
    }

    boolean unset(Block block, String tag) {
        if (!this.is(block, tag)) {
            return false;
        }
        List<String> tags = this.data.get(block);
        tags.remove(tag);
        if (tags.isEmpty()) {
            this.data.remove(block);
        }
        return true;
    }

    @NotNull
    public List<String> getTags(Block block, Plugin plugin) {
        return this.data.containsKey(block) ? this.getTags(block).stream().filter(tag -> tag.startsWith(plugin.getName() + ":")).map(tag -> tag.substring(plugin.getName().length() + 1)).toList() : Collections.emptyList();
    }

    private List<String> getTags(Block block) {
        return this.data.get(block);
    }

    public void save(File storage) {
        HashMap<String, List> map = new HashMap<String, List>();
        this.data.forEach((block, tags) -> tags.forEach(tag -> {
            if (!map.containsKey(tag)) {
                map.put((String)tag, Lists.newArrayList((Object[])new Block[]{block}));
            } else {
                ((List)map.get(tag)).add(block);
            }
        }));
        try {
            ByteBuf buf = Unpooled.buffer();
            buf.writeInt(map.size());
            map.forEach((tag, blocks) -> {
                buf.writeShort(tag.getBytes().length).writeBytes(tag.getBytes()).writeInt(blocks.size());
                blocks.forEach(block -> buf.writeShort(block.getWorld().getName().getBytes().length).writeBytes(block.getWorld().getName().getBytes()).writeInt(block.getX()).writeInt(block.getY()).writeInt(block.getZ()));
            });
            FileOutputStream stream = new FileOutputStream(storage);
            stream.write(buf.array());
            stream.close();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error initializing CustomBlockDataStorage", exception);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args2) {
        if (args2.length != 1) {
            return false;
        }
        switch (command.getName()) {
            case "checkblocktag": {
                sender.sendMessage(this.is(((Player)sender).getTargetBlock(null, 5), args2[0]) ? "yes" : "no");
                break;
            }
            case "addblocktag": {
                this.set(((Player)sender).getTargetBlock(null, 5), args2[0]);
                sender.sendMessage("Done.");
                break;
            }
            case "removeblocktag": {
                this.unset(((Player)sender).getTargetBlock(null, 5), args2[0]);
                sender.sendMessage("Done.");
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args2) {
        if (args2.length != 1 && !(sender instanceof Player)) {
            return Collections.emptyList();
        }
        return this.data.get(((Player)sender).getTargetBlock(null, 5));
    }
}

