/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi.block;

import com.google.common.collect.ImmutableMap;
import dev.piglin.piglinworldapi.PiglinWorldAPI;
import dev.piglin.piglinworldapi.block.CustomBlock;
import dev.piglin.piglinworldapi.block.Mushroom;
import dev.piglin.piglinworldapi.gui.CustomGui;
import dev.piglin.piglinworldapi.util.InventoryUtils;
import dev.piglin.piglinworldapi.util.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockController
implements Listener {
    private static final HashMap<Class<? extends CustomBlock>, List<Block>> blocks = new HashMap();
    private final NamespacedKey tagsKey = new NamespacedKey((Plugin)PiglinWorldAPI.getInstance(), "tags");

    @Deprecated
    public BlockController() {
    }

    public static void registerBlock(CustomBlock block) {
        blocks.put(block.getClass(), new LinkedList());
        CustomBlock.blocks.add(block);
    }

    public static List<Block> getBlocks(Class<? extends CustomBlock> clazz) {
        return blocks.get(clazz);
    }

    public static void clearBlocks() {
        blocks.clear();
    }

    public static ImmutableMap<Class<? extends CustomBlock>, List<Block>> getAllBlocks() {
        return ImmutableMap.copyOf(blocks);
    }

    public static Mushroom getMushroom(Block block) {
        return BlockController.getMushroom(block.getState());
    }

    public static Mushroom getMushroom(BlockState block) {
        if (!Mushroom.MushroomType.isMushroom(block.getType())) {
            return null;
        }
        MultipleFacing data = (MultipleFacing)block.getBlockData();
        int b1 = data.hasFace(BlockFace.DOWN) ? 1 : 0;
        int b2 = data.hasFace(BlockFace.EAST) ? 1 : 0;
        int b3 = data.hasFace(BlockFace.NORTH) ? 1 : 0;
        int b4 = data.hasFace(BlockFace.SOUTH) ? 1 : 0;
        int b5 = data.hasFace(BlockFace.UP) ? 1 : 0;
        int b6 = data.hasFace(BlockFace.WEST) ? 1 : 0;
        return Mushroom.fromCustomModel((b1 << 5 | b2 << 4 | b3 << 3 | b4 << 2 | b5 << 1 | b6) + Mushroom.MushroomType.valueOf(block.getType()).ordinal() * 63);
    }

    public Optional<? extends CustomBlock> getCustomBlock(Block block) {
        return this.getCustomBlock(BlockController.getMushroom(block));
    }

    public Optional<? extends CustomBlock> getCustomBlock(Mushroom mushroom) {
        return mushroom == null ? Optional.empty() : CustomBlock.blocks.stream().filter(block -> block.mushroom == mushroom).findAny();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreak(BlockExplodeEvent event) {
        Random random = new Random();
        event.blockList().forEach(block -> {
            if (random.nextFloat() <= event.getYield()) {
                ItemStack item = new ItemStack(block.getType());
                if (PiglinWorldAPI.getInstance().getBlockDataStorage().data.containsKey(block)) {
                    ItemMeta meta = item.getItemMeta();
                    assert (meta != null);
                    meta.getPersistentDataContainer().set(this.tagsKey, PersistentDataType.STRING, (Object)String.join((CharSequence)"\u001e", (Iterable<? extends CharSequence>)PiglinWorldAPI.getInstance().getBlockDataStorage().data.get(block)));
                    item.setItemMeta(meta);
                }
                this.getCustomBlock(BlockController.getMushroom(block)).ifPresent(customBlock -> {
                    if (customBlock.breakBlock((Block)block, new ItemStack(Material.AIR))) {
                        event.getBlock().getWorld().dropItemNaturally(block.getLocation(), item);
                    }
                });
            }
        });
        PiglinWorldAPI.getInstance().getBlockDataStorage().data.remove(event.getBlock());
        event.setYield(0.0f);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDrop(BlockDropItemEvent event) {
        event.setCancelled(true);
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            ItemStack item = new ItemStack(event.getBlockState().getType());
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            if (PiglinWorldAPI.getInstance().getBlockDataStorage().data.containsKey(event.getBlock())) {
                meta.getPersistentDataContainer().set(this.tagsKey, PersistentDataType.STRING, (Object)String.join((CharSequence)"\u001e", (Iterable<? extends CharSequence>)PiglinWorldAPI.getInstance().getBlockDataStorage().data.get(event.getBlock())));
            }
            if (Mushroom.MushroomType.isMushroom(event.getBlockState().getType())) {
                meta.setCustomModelData(Integer.valueOf(BlockController.getMushroom(event.getBlockState()).customModelData()));
            }
            item.setItemMeta(meta);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), item);
        }
        PiglinWorldAPI.getInstance().getBlockDataStorage().data.remove(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDrop(BlockBreakEvent event) {
        if (!event.isDropItems()) {
            PiglinWorldAPI.getInstance().getBlockDataStorage().data.remove(event.getBlock());
        }
        if (Mushroom.MushroomType.isMushroom(event.getBlock().getType())) {
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                ItemStack tool = event.getPlayer().getInventory().getItemInMainHand();
                Optional<? extends CustomBlock> block = this.getCustomBlock(BlockController.getMushroom(event.getBlock()));
                block.ifPresent(customBlock -> event.setDropItems(customBlock.breakBlock(event.getBlock(), tool)));
            }
            blocks.forEach((customBlockClass, customBlocks) -> customBlocks.remove(event.getBlock()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemMeta meta = event.getItemInHand().getItemMeta();
        assert (meta != null);
        if (meta.getPersistentDataContainer().has(this.tagsKey, PersistentDataType.STRING)) {
            String[] tags;
            for (String tag : tags = ((String)meta.getPersistentDataContainer().get(this.tagsKey, PersistentDataType.STRING)).split("\u001e")) {
                PiglinWorldAPI.getInstance().getBlockDataStorage().set(event.getBlock(), tag);
            }
        }
        if (Mushroom.MushroomType.isMushroom(event.getBlock().getType())) {
            int model = event.getItemInHand().getItemMeta().getCustomModelData();
            boolean b1 = (model & 0x20) != 0;
            boolean b2 = (model & 0x10) != 0;
            boolean b3 = (model & 8) != 0;
            boolean b4 = (model & 4) != 0;
            boolean b5 = (model & 2) != 0;
            boolean b6 = (model & 1) != 0;
            MultipleFacing block = (MultipleFacing)event.getBlock().getBlockData();
            block.setFace(BlockFace.DOWN, b1);
            block.setFace(BlockFace.EAST, b2);
            block.setFace(BlockFace.NORTH, b3);
            block.setFace(BlockFace.SOUTH, b4);
            block.setFace(BlockFace.UP, b5);
            block.setFace(BlockFace.WEST, b6);
            event.getBlock().setBlockData((BlockData)block, false);
            this.getCustomBlock(BlockController.getMushroom(event.getBlock())).ifPresent(customBlock -> {
                if (!customBlock.placeBlock(event.getBlock())) {
                    event.setBuild(false);
                } else {
                    blocks.get(customBlock.getClass()).add(event.getBlock());
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (event.hasBlock()) {
            assert (event.getClickedBlock() != null);
            if (Mushroom.MushroomType.isMushroom(event.getClickedBlock().getType())) {
                this.getCustomBlock(BlockController.getMushroom(event.getClickedBlock())).flatMap(block -> block.onInteract(event)).ifPresent(inventory -> PiglinWorldAPI.getInstance().getGuiController().open((CustomGui)inventory, event.getPlayer()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onMiddleClickBlock(InventoryCreativeEvent event) {
        Material material;
        if (event.getAction() == InventoryAction.PLACE_ALL && Mushroom.MushroomType.isMushroom(material = event.getCursor().getType()) && !event.getCursor().getItemMeta().hasCustomModelData() && event.getWhoClicked().getTargetBlock(null, 5).getType() == material) {
            Mushroom mushroom = BlockController.getMushroom(event.getWhoClicked().getTargetBlock(null, 5));
            ItemMeta meta = event.getCursor().getItemMeta();
            meta.setCustomModelData(Integer.valueOf(mushroom.customModelData()));
            event.getCursor().setItemMeta(meta);
            Integer slot = InventoryUtils.getSimilarSlots((Inventory)event.getWhoClicked().getInventory(), event.getCursor()).get(0);
            int airSlot = event.getWhoClicked().getInventory().firstEmpty();
            if (slot.intValue() == event.getWhoClicked().getInventory().getHeldItemSlot()) {
                event.setCancelled(true);
                event.getWhoClicked().getInventory().setHeldItemSlot(slot.intValue());
                if (airSlot != -1) {
                    event.getWhoClicked().getInventory().setItem(airSlot, null);
                }
            } else if (slot == -1) {
                if (airSlot != -1 && airSlot < 9) {
                    if (event.getWhoClicked().getInventory().getItemInMainHand().getType() == Material.AIR) {
                        airSlot = event.getWhoClicked().getInventory().getHeldItemSlot();
                    }
                    event.setCancelled(true);
                    event.getWhoClicked().getInventory().setHeldItemSlot(airSlot);
                    event.getWhoClicked().getInventory().setItem(airSlot, event.getCursor());
                }
            } else if (slot < 9) {
                event.setCancelled(true);
                event.getWhoClicked().getInventory().setHeldItemSlot(slot.intValue());
                if (airSlot != -1) {
                    event.getWhoClicked().getInventory().setItem(airSlot, null);
                }
            } else {
                event.setCancelled(true);
                ItemStack itemMushroom = event.getWhoClicked().getInventory().getItem(slot.intValue());
                if (airSlot < 9) {
                    event.getWhoClicked().getInventory().setHeldItemSlot(airSlot);
                    event.getWhoClicked().getInventory().setItem(airSlot, itemMushroom);
                    event.getWhoClicked().getInventory().setItem(slot.intValue(), null);
                } else {
                    ItemStack itemInHand = event.getWhoClicked().getInventory().getItemInMainHand();
                    event.getWhoClicked().getInventory().setItem(event.getWhoClicked().getInventory().getHeldItemSlot(), itemMushroom);
                    event.getWhoClicked().getInventory().setItem(slot.intValue(), itemInHand);
                }
            }
        }
    }

    @EventHandler
    public void onPhysics(BlockPhysicsEvent event) {
        if (Mushroom.MushroomType.isMushroom(event.getBlock().getType())) {
            event.setCancelled(true);
            Material mushroom = event.getBlock().getType();
            ArrayList<Block> list = new ArrayList<Block>(100);
            list.add(event.getBlock());
            for (int i = 0; i < list.size(); ++i) {
                Block block = (Block)list.get(i);
                for (BlockFace face : BlockFace.values()) {
                    Block neighbor;
                    if (!face.isCartesian() || (neighbor = block.getRelative(face)).getType() != mushroom || list.contains(neighbor)) continue;
                    list.add(neighbor);
                }
            }
            for (Block block : list) {
                BlockData data = block.getBlockData().clone();
                block.setType(mushroom, false);
                block.setBlockData(data, false);
            }
        }
    }

    public void loadChunk(ChunkSnapshot snapshot, int minHeight, int maxHeight) {
        new Thread(() -> {
            LinkedList<Triple<Integer, Integer, Integer>> locations = new LinkedList<Triple<Integer, Integer, Integer>>();
            for (int x = 0; x < 16; ++x) {
                for (int y = minHeight; y < maxHeight; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockData block = snapshot.getBlockData(x, y, z);
                        if (!Mushroom.MushroomType.isMushroom(block.getMaterial())) continue;
                        locations.add(new Triple<Integer, Integer, Integer>(x, y, z));
                    }
                }
            }
            Bukkit.getScheduler().runTask((Plugin)PiglinWorldAPI.getInstance(), () -> {
                World world = Bukkit.getWorld((String)snapshot.getWorldName());
                Chunk chunk = world.getChunkAt(snapshot.getX(), snapshot.getZ());
                locations.forEach(loc -> {
                    Block block = chunk.getBlock(((Integer)loc.left()).intValue(), ((Integer)loc.middle()).intValue(), ((Integer)loc.right()).intValue());
                    this.getCustomBlock(BlockController.getMushroom(block)).ifPresent(customBlock -> {
                        blocks.get(customBlock.getClass()).add(block);
                        customBlock.onLoad(block);
                    });
                });
            });
        }).start();
    }

    public void unloadChunk(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int y = chunk.getWorld().getMinHeight(); y < chunk.getWorld().getMaxHeight(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    if (!Mushroom.MushroomType.isMushroom(block.getType())) continue;
                    this.getCustomBlock(BlockController.getMushroom(block)).ifPresent(customBlock -> {
                        blocks.get(customBlock.getClass()).add(block);
                        customBlock.onUnload(block);
                    });
                }
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        this.loadChunk(event.getChunk().getChunkSnapshot(), event.getWorld().getMinHeight(), event.getWorld().getMaxHeight());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        this.unloadChunk(event.getChunk());
    }

    @EventHandler
    public void onPistonMove(BlockPistonExtendEvent event) {
        if (Mushroom.MushroomType.isMushroom(event.getBlock().getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonMove(BlockPistonRetractEvent event) {
        if (Mushroom.MushroomType.isMushroom(event.getBlock().getType())) {
            event.setCancelled(true);
        }
    }
}

