/*
 * Decompiled with CFR 0.152.
 */
package dev.piglin.piglinworldapi;

import com.google.common.collect.ImmutableMap;
import dev.piglin.piglinworldapi.block.BlockController;
import dev.piglin.piglinworldapi.block.BlockDataStorage;
import dev.piglin.piglinworldapi.block.CustomBlock;
import dev.piglin.piglinworldapi.block.RedstoneListener;
import dev.piglin.piglinworldapi.gui.GuiController;
import dev.piglin.piglinworldapi.recipe.RecipeController;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PiglinWorldAPI
extends JavaPlugin {
    private final File blockDataStorageFile = new File(this.getDataFolder(), "block");
    private BlockDataStorage blockDataStorage;
    private BlockController blockController;
    private RecipeController recipeController;
    private GuiController guiController;

    public static PiglinWorldAPI getInstance() {
        return (PiglinWorldAPI)PiglinWorldAPI.getPlugin(PiglinWorldAPI.class);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupFileStorage();
        this.blockDataStorage = new BlockDataStorage(this.blockDataStorageFile);
        this.blockController = new BlockController();
        this.recipeController = new RecipeController();
        this.guiController = new GuiController();
        this.getCommand("checkblocktag").setExecutor((CommandExecutor)this.blockDataStorage);
        this.getCommand("addblocktag").setExecutor((CommandExecutor)this.blockDataStorage);
        this.getCommand("removeblocktag").setExecutor((CommandExecutor)this.blockDataStorage);
        this.getServer().getPluginManager().registerEvents((Listener)this.blockController, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.recipeController, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiController, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RedstoneListener(), (Plugin)this);
        if (this.getServer().getWorlds().stream().anyMatch(world -> world.getLoadedChunks().length != 0)) {
            System.out.println("Searching for PiglinAPI blocks... It may take some time.");
            for (World world2 : this.getServer().getWorlds()) {
                for (Chunk chunk : world2.getLoadedChunks()) {
                    this.blockController.loadChunk(chunk.getChunkSnapshot(), world2.getMinHeight(), world2.getMaxHeight());
                }
            }
            ImmutableMap<Class<? extends CustomBlock>, List<Block>> blocks = BlockController.getAllBlocks();
            System.out.println("Loaded " + blocks.size() + " different blocks (" + blocks.values().stream().map(Collection::size).reduce(Integer::sum).orElse(0) + " blocks)");
        }
    }

    public BlockDataStorage getBlockDataStorage() {
        return this.blockDataStorage;
    }

    public BlockController getBlockController() {
        return this.blockController;
    }

    public RecipeController getRecipeController() {
        return this.recipeController;
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    public long getTeleportDelay() {
        return this.getConfig().getLong("teleport delay");
    }

    public void onDisable() {
        this.blockDataStorage.save(this.blockDataStorageFile);
        BlockController.clearBlocks();
        this.guiController.closeAll();
    }

    private void setupFileStorage() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            if (!this.blockDataStorageFile.exists()) {
                this.blockDataStorageFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

