/*
 * Decompiled with CFR 0.152.
 */
package io.pdfapi.client;

import io.pdfapi.client.model.ConversionProperties;
import io.pdfapi.client.model.PageFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversionRequest {
    private final ConversionProperties properties;
    private final InputStream htmlContent;
    private final List<AssetInput> assets;
    private final AssetInput headerFile;
    private final AssetInput footerFile;

    private ConversionRequest(Builder builder) {
        this.properties = Objects.requireNonNull(builder.properties, "Properties must not be null");
        this.htmlContent = Objects.requireNonNull(builder.htmlContent, "HTML content must not be null");
        this.assets = List.copyOf(builder.assets);
        this.headerFile = builder.headerFile;
        this.footerFile = builder.footerFile;
    }

    public ConversionProperties getProperties() {
        return this.properties;
    }

    public InputStream getHtmlContent() {
        return this.htmlContent;
    }

    public List<AssetInput> getAssets() {
        return this.assets;
    }

    public AssetInput getHeaderFile() {
        return this.headerFile;
    }

    public AssetInput getFooterFile() {
        return this.footerFile;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConversionProperties properties;
        private InputStream htmlContent;
        private final List<AssetInput> assets = new ArrayList<AssetInput>();
        private AssetInput headerFile;
        private AssetInput footerFile;

        public Builder properties(ConversionProperties properties) {
            this.properties = Objects.requireNonNull(properties, "Properties must not be null");
            return this;
        }

        public Builder htmlContent(InputStream htmlContent) {
            this.htmlContent = Objects.requireNonNull(htmlContent, "HTML content must not be null");
            return this;
        }

        public Builder addAsset(AssetInput asset) {
            this.assets.add(Objects.requireNonNull(asset, "Asset must not be null"));
            return this;
        }

        public Builder headerFile(AssetInput headerFile) {
            this.headerFile = Objects.requireNonNull(headerFile, "Header file must not be null");
            this.assets.add(headerFile);
            if (this.properties != null) {
                this.properties = ConversionProperties.builderFrom(this.properties).headerFile(headerFile.getFileName()).build();
            }
            return this;
        }

        public Builder footerFile(AssetInput footerFile) {
            this.footerFile = Objects.requireNonNull(footerFile, "Footer file must not be null");
            this.assets.add(footerFile);
            if (this.properties != null) {
                this.properties = ConversionProperties.builderFrom(this.properties).footerFile(footerFile.getFileName()).build();
            }
            return this;
        }

        public ConversionRequest build() {
            if (this.properties == null) {
                this.properties = ConversionProperties.builder().format(PageFormat.A4).build();
            }
            if ((this.headerFile != null || this.footerFile != null) && this.properties != null) {
                ConversionProperties.Builder propsBuilder = ConversionProperties.builderFrom(this.properties);
                if (this.headerFile != null) {
                    propsBuilder.headerFile(this.headerFile.getFileName());
                }
                if (this.footerFile != null) {
                    propsBuilder.footerFile(this.footerFile.getFileName());
                }
                this.properties = propsBuilder.build();
            }
            return new ConversionRequest(this);
        }
    }

    public static class AssetInput {
        private final InputStream content;
        private final String fileName;

        public AssetInput(InputStream content, String fileName) {
            this.content = content;
            this.fileName = fileName;
        }

        public InputStream getContent() {
            return this.content;
        }

        public String getFileName() {
            return this.fileName;
        }

        public static AssetInput of(InputStream content, String fileName) {
            return new AssetInput(content, fileName);
        }
    }
}

