/*
 * Decompiled with CFR 0.152.
 */
package io.pdfapi.client.http;

import io.pdfapi.client.http.AbstractHttpClient;
import io.pdfapi.client.http.HttpResponse;
import io.pdfapi.client.http.StreamingHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ApacheHttpClient
extends AbstractHttpClient {
    private final CloseableHttpClient httpClient;

    public ApacheHttpClient() {
        this.httpClient = HttpClients.createDefault();
    }

    public ApacheHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, String jsonBody) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse;
            block8: {
                HttpPost httpPost = new HttpPost(url);
                headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
                httpPost.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                try {
                    httpResponse = this.convertResponse(response);
                    if (response == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                response.close();
            }
            return httpResponse;
        });
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, String fileName, InputStream content, String contentType, String partName) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse;
            block8: {
                HttpPost httpPost = new HttpPost(url);
                headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addBinaryBody(partName, content, ContentType.create((String)contentType), fileName);
                httpPost.setEntity(builder.build());
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                try {
                    httpResponse = this.convertResponse(response);
                    if (response == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                response.close();
            }
            return httpResponse;
        });
    }

    @Override
    protected CompletableFuture<HttpResponse> executeGet(String url, Map<String, String> headers) {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse httpResponse;
            block8: {
                HttpGet httpGet = new HttpGet(url);
                headers.forEach((arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                try {
                    httpResponse = this.convertResponse(response);
                    if (response == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                response.close();
            }
            return httpResponse;
        });
    }

    private HttpResponse convertResponse(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return new StreamingHttpResponse(response.getStatusLine().getStatusCode(), ApacheHttpClient.readContent(entity), (AutoCloseable)response, this.mapHeaders(response.getAllHeaders()));
        }
        response.close();
        return new StreamingHttpResponse(response.getStatusLine().getStatusCode(), null, null, this.mapHeaders(response.getAllHeaders()));
    }

    private Map<String, List<String>> mapHeaders(Header[] allHeaders) {
        return Arrays.stream(allHeaders).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
    }

    private static InputStream readContent(HttpEntity entity) throws IOException {
        try (InputStream content = entity.getContent();){
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.readAllBytes());
            return byteArrayInputStream;
        }
    }

    @Override
    protected void closeInternal() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close Apache HTTP client", e);
        }
    }
}

