/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.simple.task;

import com.redhat.parodos.examples.utils.RestUtils;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class RestAPIWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestAPIWorkFlowTask.class);
    private static final String URL_KEY = "url";

    public WorkReport execute(WorkContext workContext) {
        try {
            String urlString = this.getRequiredParameterValue(workContext, URL_KEY);
            log.info("Running Task REST API Call: urlString: {}", (Object)urlString);
            ResponseEntity<String> result = RestUtils.executeGet(urlString);
            if (result.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed: {}", result.getBody());
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)result.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key(URL_KEY).description("The Url of the service (ie: https://httpbin.org/post").optional(false).type(WorkParameterType.URL).build(), WorkParameter.builder().key("user-id").description("The user id").type(WorkParameterType.TEXT).optional(false).build());
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.HTTP2XX, WorkFlowTaskOutput.OTHER);
    }
}

