/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpAppDeploymentWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OcpAppDeploymentWorkFlowTask.class);
    private static final String OPENSHIFT_NGINX = "twalter/openshift-nginx";
    private static final int CONTAINER_PORT = 8081;
    private static final String DEMO_PORT = "demo-port";
    private static final String APP_LINK = "APP_LINK";
    private static final String ROUTE_PROTOCOl = "http://";
    private static final String NGINX = "nginx";
    private static final String NAMESPACE = "NAMESPACE";
    private static final String CLUSTER_TOKEN = "CLUSTER_TOKEN";
    private final String clusterApiUrl;

    public OcpAppDeploymentWorkFlowTask(String clusterApiUrl) {
        this.clusterApiUrl = clusterApiUrl;
    }

    public WorkReport execute(WorkContext workContext) {
        log.info("Start ocpAppDeploymentWorkFlowTask...");
        try {
            String namespace = this.getRequiredParameterValue(workContext, NAMESPACE);
            String clusterToken = this.getRequiredParameterValue(workContext, CLUSTER_TOKEN);
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.clusterApiUrl)).withOauthToken(clusterToken)).build();
            try (KubernetesClient kclient = new KubernetesClientBuilder().withConfig(config).build();){
                OpenShiftClient client = (OpenShiftClient)kclient.adapt(OpenShiftClient.class);
                this.createProject(client, namespace);
                Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(NGINX)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withNewTemplate().withNewMetadata().addToLabels("app", NGINX)).endMetadata()).withNewSpec().addNewContainer().withName(NGINX)).withImage(OPENSHIFT_NGINX)).addNewPort().withContainerPort(Integer.valueOf(8081))).endPort()).endContainer()).endSpec()).endTemplate()).withNewSelector().addToMatchLabels("app", NGINX)).endSelector()).endSpec()).build();
                ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).create();
                Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(NGINX)).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("app", NGINX))).addNewPort().withName(DEMO_PORT)).withProtocol("TCP")).withPort(Integer.valueOf(8081))).withTargetPort(new IntOrString((Object)8081))).endPort()).endSpec()).build();
                ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).resource((Object)service)).create();
                Route route = ((RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(NGINX)).endMetadata()).withNewSpec().withTo(((RouteTargetReferenceBuilder)((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withKind("Service")).withName(NGINX)).build())).withPort(((RoutePortBuilder)new RoutePortBuilder().withTargetPort(new IntOrString((Object)8081))).build())).endSpec()).build();
                route = (Route)((Resource)((NonNamespaceOperation)client.routes().inNamespace(namespace)).resource((Object)route)).create();
                this.addParameter(workContext, APP_LINK, String.format("%s%s", ROUTE_PROTOCOl, route.getSpec().getHost()));
                log.info("deployment is successful");
            }
        }
        catch (MissingParameterException e) {
            log.error("can't get namespace or cluster token");
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        catch (KubernetesClientException e) {
            log.error("deploy failed. error message: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private void createProject(OpenShiftClient client, String namespace) {
        try {
            client.projectrequests().create((Object)((ProjectRequestBuilder)((ProjectRequestBuilder)((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(namespace)).endMetadata()).withDescription(namespace)).withDisplayName(namespace)).build());
        }
        catch (KubernetesClientException e) {
            log.info("project {} already exists: {}", (Object)namespace, (Object)((Object)((Object)e)).getClass().getSimpleName());
        }
    }
}

