/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.examples.ocponboarding.task.dto.jira.CreateJiraTicketRequestDto;
import com.redhat.parodos.examples.ocponboarding.task.dto.jira.CreateJiraTicketResponseDto;
import com.redhat.parodos.examples.ocponboarding.task.dto.jira.RequestFieldValues;
import com.redhat.parodos.examples.utils.RestUtils;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class JiraTicketCreationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTicketCreationWorkFlowTask.class);
    private static final String NAMESPACE = "NAMESPACE";
    private static final String ISSUE_KEY = "ISSUE_KEY";
    private static final String ISSUE_LINK = "ISSUE_LINK";
    private static final String WEB_LINK = "web";
    private final String jiraServiceBaseUrl;
    private final String jiraUsername;
    private final String jiraPassword;
    private final String approverId;

    public JiraTicketCreationWorkFlowTask(String jiraServiceBaseUrl, String jiraUsername, String jiraPassword, String approverId) {
        this.jiraServiceBaseUrl = jiraServiceBaseUrl;
        this.jiraUsername = jiraUsername;
        this.jiraPassword = jiraPassword;
        this.approverId = approverId;
    }

    public WorkReport execute(WorkContext workContext) {
        log.info("Start jiraTicketCreationWorkFlowTask...");
        try {
            String urlString = this.jiraServiceBaseUrl + "/rest/servicedeskapi/request";
            String serviceDeskId = "1";
            String requestTypeId = "35";
            String projectId = this.getProjectId(workContext);
            String namespace = this.getOptionalParameterValue(workContext, NAMESPACE, "demo");
            log.info("Calling: urlString: {} username: {}", (Object)urlString, (Object)this.jiraUsername);
            CreateJiraTicketRequestDto request = CreateJiraTicketRequestDto.builder().serviceDeskId(serviceDeskId).requestTypeId(requestTypeId).requestFieldValues(RequestFieldValues.builder().approvers(List.of(RequestFieldValues.JiraUser.builder().accountId(this.approverId).build())).summary(String.format("Onboard %s in namespace %s on ocp", projectId, namespace)).projectName(projectId).namespace(namespace).build()).build();
            ResponseEntity<CreateJiraTicketResponseDto> response = RestUtils.executePost(urlString, request, this.jiraUsername, this.jiraPassword, CreateJiraTicketResponseDto.class);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed: {}", (Object)Objects.requireNonNull((CreateJiraTicketResponseDto)response.getBody()).getIssueId());
                this.addParameter(workContext, ISSUE_KEY, Objects.requireNonNull((CreateJiraTicketResponseDto)response.getBody()).getIssueKey());
                this.addParameter(workContext, ISSUE_LINK, Objects.requireNonNull((CreateJiraTicketResponseDto)response.getBody()).getLinks().get(WEB_LINK));
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.HTTP2XX, WorkFlowTaskOutput.OTHER);
    }
}

