/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.examples.ocponboarding.task.dto.notification.NotificationRequest;
import com.redhat.parodos.examples.utils.RestUtils;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class NotificationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationWorkFlowTask.class);
    private static final String NOTIFICATION_MESSAGE = "NOTIFICATION_MESSAGE";
    private static final String NOTIFICATION_SUBJECT = "NOTIFICATION_SUBJECT";
    private final String notificationServiceUrl;

    public NotificationWorkFlowTask(String notificationServiceUrl) {
        this.notificationServiceUrl = notificationServiceUrl;
    }

    public WorkReport execute(WorkContext workContext) {
        try {
            String subject = this.getRequiredParameterValue(workContext, NOTIFICATION_SUBJECT);
            String message = this.getRequiredParameterValue(workContext, NOTIFICATION_MESSAGE);
            NotificationRequest request = NotificationRequest.builder().usernames(List.of("test")).subject(subject).body(message).build();
            HttpEntity<NotificationRequest> notificationRequestHttpEntity = RestUtils.getRequestWithHeaders(request, "test", "test");
            ResponseEntity<String> response = RestUtils.executePost(this.notificationServiceUrl + "/api/v1/messages", notificationRequestHttpEntity);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Rest call completed: {}", response.getBody());
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.HTTP2XX, WorkFlowTaskOutput.OTHER);
    }
}

