/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.utils;

import java.util.Base64;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public final class RestUtils {
    private RestUtils() {
        throw new UnsupportedOperationException("Suppress default constructor for non instantiability");
    }

    public static ResponseEntity<String> executePost(String urlString, String payload) {
        RestTemplate restTemplate = new RestTemplate();
        return restTemplate.postForEntity(urlString, (Object)payload, String.class, new Object[0]);
    }

    public static ResponseEntity<String> restExchange(String urlString, String username, String password) {
        RestTemplate restTemplate = new RestTemplate();
        return restTemplate.exchange(urlString, HttpMethod.GET, RestUtils.getRequestWithHeaders(username, password), String.class, new Object[0]);
    }

    public static HttpEntity<String> getRequestWithHeaders(String username, String password) {
        String base64Creds = RestUtils.getBase64Creds(username, password);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        return new HttpEntity((MultiValueMap)headers);
    }

    public static String getBase64Creds(String username, String password) {
        String plainCreds = username + ":" + password;
        byte[] plainCredsBytes = plainCreds.getBytes();
        byte[] base64CredsBytes = Base64.getEncoder().encode(plainCredsBytes);
        return new String(base64CredsBytes);
    }
}

