/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.Property;
import org.springframework.core.convert.converter.Converter;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CollectionType;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.swagger2.mappers.PropertyMapper;

public class CollectionSpecificationToPropertyConverter
implements Converter<CollectionSpecification, Property> {
    private final ModelNamesRegistry modelNamesRegistry;

    public CollectionSpecificationToPropertyConverter(ModelNamesRegistry modelNamesRegistry) {
        this.modelNamesRegistry = modelNamesRegistry;
    }

    @Override
    public Property convert(CollectionSpecification source2) {
        ArrayProperty arrayProperty = new ArrayProperty();
        if (source2.getModel().getScalar().isPresent() && source2.getModel().getScalar().get().getType() == ScalarType.BYTE) {
            return new ByteArrayProperty();
        }
        arrayProperty.items(new PropertyMapper().fromModel(source2.getModel(), this.modelNamesRegistry));
        if (source2.getCollectionType() == CollectionType.SET) {
            arrayProperty.uniqueItems();
        }
        return arrayProperty;
    }
}

