/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147482648)
public class SwaggerOperationTagsReader
implements OperationBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().tags(Stream.concat(this.operationTags(context).stream(), this.controllerTags(context).stream()).collect(Collectors.toSet()));
    }

    private Set<String> controllerTags(OperationContext context) {
        Optional<Api> controllerAnnotation = context.findControllerAnnotation(Api.class);
        return controllerAnnotation.map(this.tagsFromController()).orElse(new HashSet());
    }

    private Set<String> operationTags(OperationContext context) {
        Optional<ApiOperation> annotation = context.findAnnotation(ApiOperation.class);
        return new HashSet<String>(annotation.map(this.tagsFromOperation()).orElse(new HashSet()));
    }

    private Function<ApiOperation, Set<String>> tagsFromOperation() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }

    private Function<Api, Set<String>> tagsFromController() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

