/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.common;

import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;
import springfox.documentation.swagger.common.XForwardPrefixPathAdjuster;

public class HostNameProvider {
    private HostNameProvider() {
        throw new UnsupportedOperationException();
    }

    public static UriComponents componentsFrom(HttpServletRequest request, String basePath) {
        ServletUriComponentsBuilder builder = HostNameProvider.fromServletMapping(request, basePath);
        UriComponents components = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build();
        String host = components.getHost();
        if (!StringUtils.hasText(host)) {
            return builder.build();
        }
        builder.host(host);
        builder.port(components.getPort());
        builder.scheme(components.getScheme());
        return builder.build();
    }

    private static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request, String basePath) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath(request);
        XForwardPrefixPathAdjuster adjuster = new XForwardPrefixPathAdjuster(request);
        String adjustedPath = adjuster.adjustedPath(basePath);
        if (!adjustedPath.equals(basePath)) {
            builder.replacePath(adjustedPath);
        }
        if (StringUtils.hasText(new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }
}

