/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.common.SpringVersion;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;

@Component
@Order(value=-2147483648)
public class ParameterRequiredReader
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public ParameterRequiredReader(DescriptionResolver descriptions) {
        this(descriptions, new SpringVersion());
    }

    ParameterRequiredReader(DescriptionResolver descriptions, SpringVersion springVersion) {
        this.descriptions = descriptions;
    }

    @Override
    public void apply(ParameterContext context) {
        ResolvedMethodParameter methodParameter = context.resolvedMethodParameter();
        context.parameterBuilder().required(this.isRequired(context.getOperationContext(), methodParameter));
        context.requestParameterBuilder().required(this.isRequired(context.getOperationContext(), methodParameter));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private boolean isRequired(OperationContext operationContext, ResolvedMethodParameter methodParameter) {
        HashSet<Boolean> requiredSet = new HashSet<Boolean>();
        boolean optional = this.isOptional(methodParameter);
        Optional<RequestParam> requestParam = methodParameter.findAnnotation(RequestParam.class);
        requestParam.ifPresent(param -> requiredSet.add(!optional && this.isRequired((RequestParam)param)));
        Optional<RequestHeader> requestHeader = methodParameter.findAnnotation(RequestHeader.class);
        requestHeader.ifPresent(header -> requiredSet.add(!optional && header.required()));
        Optional<PathVariable> pathVariable = methodParameter.findAnnotation(PathVariable.class);
        if (pathVariable.isPresent()) {
            String paramName = Optional.ofNullable(pathVariable.get().name()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(methodParameter.defaultName().orElse(null));
            if (pathVariable.get().required() || this.optionalButPresentInThePath(operationContext, pathVariable.get(), paramName)) {
                requiredSet.add(true);
            }
        }
        Optional<RequestBody> requestBody = methodParameter.findAnnotation(RequestBody.class);
        requestBody.ifPresent(body2 -> requiredSet.add(!optional && body2.required()));
        Optional<RequestPart> requestPart = methodParameter.findAnnotation(RequestPart.class);
        requestPart.ifPresent(part -> requiredSet.add(!optional && part.required()));
        return requiredSet.contains(true);
    }

    private boolean optionalButPresentInThePath(OperationContext operationContext, PathVariable pathVariable, String paramName) {
        return !pathVariable.required() && operationContext.requestMappingPattern().contains("{" + paramName + "}");
    }

    boolean isOptional(ResolvedMethodParameter methodParameter) {
        return "com.google.common.base.Optional".equals(methodParameter.getParameterType().getErasedType().getName());
    }

    private boolean isRequired(RequestParam annotation) {
        String defaultValue = this.descriptions.resolve(annotation.defaultValue());
        boolean missingDefaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue);
        return annotation.required() && missingDefaultValue;
    }
}

