/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.function.Predicate;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.JaxbPresentInClassPathCondition;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Conditional(value={JaxbPresentInClassPathCondition.class})
public class XmlPropertyPlugin
implements ModelPropertyBuilderPlugin {
    @Override
    public void apply(ModelPropertyContext context) {
        Optional<Object> elementAnnotation = Optional.empty();
        Optional<Object> attributeAnnotation = Optional.empty();
        if (context.getAnnotatedElement().isPresent()) {
            elementAnnotation = elementAnnotation.map(Optional::of).orElse(XmlPropertyPlugin.findAnnotation(context.getAnnotatedElement().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.map(Optional::of).orElse(XmlPropertyPlugin.findAnnotation(context.getAnnotatedElement().get(), XmlAttribute.class));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            elementAnnotation = elementAnnotation.map(Optional::of).orElse(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.map(Optional::of).orElse(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlAttribute.class));
        }
        if (elementAnnotation.isPresent() && context.getBeanPropertyDefinition().isPresent()) {
            Optional<XmlElementWrapper> wrapper = Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlElementWrapper.class);
            context.getBuilder().xml(new Xml().attribute(false).namespace(this.defaultToNull(((XmlElement)elementAnnotation.get()).namespace())).name(this.wrapperName(wrapper, elementAnnotation)).wrapped(wrapper.isPresent()));
            context.getSpecificationBuilder().xml(new Xml().attribute(false).namespace(this.defaultToNull(((XmlElement)elementAnnotation.get()).namespace())).name(this.wrapperName(wrapper, elementAnnotation)).wrapped(wrapper.isPresent()));
        } else if (attributeAnnotation.isPresent()) {
            context.getBuilder().xml(new Xml().attribute(true).namespace(this.defaultToNull(((XmlAttribute)attributeAnnotation.get()).namespace())).name(this.attributeName(attributeAnnotation)).wrapped(false));
            context.getSpecificationBuilder().xml(new Xml().attribute(true).namespace(this.defaultToNull(((XmlAttribute)attributeAnnotation.get()).namespace())).name(this.attributeName(attributeAnnotation)).wrapped(false));
        }
    }

    public static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement annotated, Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.getAnnotation(annotated, annotation));
    }

    private String wrapperName(Optional<XmlElementWrapper> wrapper, Optional<XmlElement> element) {
        return wrapper.map(xmlElementWrapper -> Optional.ofNullable(this.defaultToNull(Optional.ofNullable(xmlElementWrapper.name()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null))).orElse(Optional.ofNullable(this.elementName(element)).orElse(null))).orElseGet(() -> this.elementName(element));
    }

    private String elementName(Optional<XmlElement> element) {
        return element.map(xmlElement -> this.defaultToNull(Optional.ofNullable(xmlElement.name()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null))).orElse(null);
    }

    private String attributeName(Optional<XmlAttribute> attribute) {
        return attribute.map(xmlAttribute -> this.defaultToNull(Optional.ofNullable(xmlAttribute.name()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null))).orElse(null);
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

