/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonView;
import java.lang.reflect.Type;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order
public class JacksonJsonViewProvider
implements ViewProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonJsonViewProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public JacksonJsonViewProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public Optional<ResolvedType> viewFor(ResolvedMethodParameter parameter) {
        return this.viewFor(String.format("Parameter name: %s @ index: %s", parameter.defaultName().orElse("<none>"), parameter.getParameterIndex()), parameter.findAnnotation(JsonView.class).orElse(null));
    }

    @Override
    public Optional<ResolvedType> viewFor(RequestMappingContext context) {
        return this.viewFor(String.format("Request Mapping: %s", context.getRequestMappingPattern()), context.findAnnotation(JsonView.class).orElse(null));
    }

    @Override
    public Optional<ResolvedType> viewFor(OperationContext context) {
        return this.viewFor(String.format("Operation: %s", context.getName()), context.findAnnotation(JsonView.class).orElse(null));
    }

    private Optional<ResolvedType> viewFor(String context, JsonView annotation) {
        Optional<ResolvedType> view = Optional.empty();
        if (annotation != null) {
            Class<?>[] views = annotation.value();
            view = Optional.of(this.typeResolver.resolve(views[0], new Type[0]));
            LOG.debug("Found view {} for type {}", (Object)ResolvedTypes.resolvedTypeSignature(view.get()).orElse("<null>"), (Object)context);
        }
        return view;
    }
}

