/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.HashSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.Representation;
import springfox.documentation.service.SimpleParameterSpecification;

public class BodyParameterSpecificationProvider
implements ParameterSpecificationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyParameterSpecificationProvider.class);

    @Override
    public ParameterSpecification create(ParameterSpecificationContext context) {
        SimpleParameterSpecification simpleParameter = context.getSimpleParameter();
        ContentSpecification contentParameter = context.getContentParameter();
        HashSet<MediaType> accepts = new HashSet<MediaType>(context.getAccepts());
        if (contentParameter != null) {
            accepts.addAll(contentParameter.getRepresentations().stream().map(Representation::getMediaType).collect(Collectors.toSet()));
        }
        if (accepts.isEmpty()) {
            accepts.add(MediaType.APPLICATION_JSON);
        }
        accepts.stream().filter(mediaType -> !mediaType.equalsTypeAndSubtype((MimeType)MediaType.APPLICATION_FORM_URLENCODED)).forEach(each -> {
            if (simpleParameter != null && simpleParameter.getModel() != null) {
                context.getContentSpecificationBuilder().copyOf(contentParameter).requestBody(true).representation((MediaType)each).apply(r -> r.model(m3 -> m3.copyOf(simpleParameter.getModel())).clearEncodings());
            } else if (contentParameter != null) {
                contentParameter.representationFor((MediaType)each).ifPresent(representation -> context.getContentSpecificationBuilder().representation(representation.getMediaType()).apply(r -> r.copyOf((Representation)representation)));
            } else {
                LOGGER.warn("Parameter should either be a simple or a content type");
                context.getContentSpecificationBuilder().requestBody(true).representation((MediaType)each).apply(r -> r.model(m3 -> m3.copyOf(new ModelSpecificationBuilder().name(context.getName()).scalarModel(ScalarType.STRING).build())).clearEncodings());
            }
        });
        return new ParameterSpecification(null, context.getContentSpecificationBuilder().build());
    }
}

