/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractTypeAwareSupport<T>
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
InitializingBean {
    @Nullable
    private ApplicationContext context;
    @Nullable
    private Class<T> type;
    @Nullable
    private BeansOfTypeTargetSource targetSource;
    private Collection<Class<?>> exclusions = Collections.emptySet();

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setExclusions(Class<?>[] exclusions) {
        this.exclusions = Arrays.asList(exclusions);
    }

    protected List<T> getBeans() {
        BeansOfTypeTargetSource targetSource = this.targetSource;
        if (targetSource == null) {
            throw new IllegalStateException("Traget source not initialized!");
        }
        ProxyFactory factory2 = new ProxyFactory(List.class, targetSource);
        return (List)factory2.getProxy();
    }

    @Override
    public void afterPropertiesSet() {
        ApplicationContext context = this.context;
        if (context == null) {
            throw new IllegalStateException("ApplicationContext not set!");
        }
        Class<T> type = this.type;
        if (type == null) {
            throw new IllegalStateException("No type configured!");
        }
        this.targetSource = new BeansOfTypeTargetSource((ListableBeanFactory)context, type, false, this.exclusions);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.context) && this.targetSource != null) {
            this.targetSource.freeze();
        }
    }

    static class BeansOfTypeTargetSource
    implements TargetSource {
        private final ListableBeanFactory context;
        private final Class<?> type;
        private final boolean eagerInit;
        private final Collection<Class<?>> exclusions;
        private boolean frozen = false;
        @Nullable
        private Collection<Object> components;

        public BeansOfTypeTargetSource(ListableBeanFactory context, Class<?> type, boolean eagerInit, Collection<Class<?>> exclusions) {
            Assert.notNull((Object)context, "ListableBeanFactory must not be null!");
            Assert.notNull(type, "Type must not be null!");
            Assert.notNull(exclusions, "Exclusions must not be null!");
            this.context = context;
            this.type = type;
            this.eagerInit = eagerInit;
            this.exclusions = exclusions;
            this.components = null;
        }

        public void freeze() {
            this.frozen = true;
        }

        @Override
        @NonNull
        public Class<?> getTargetClass() {
            return List.class;
        }

        @Override
        public boolean isStatic() {
            return this.frozen;
        }

        @Override
        @NonNull
        public synchronized Object getTarget() throws Exception {
            Collection<Object> components;
            Collection<Object> collection = components = this.components == null ? this.getBeansOfTypeExcept(this.type, this.exclusions) : this.components;
            if (this.frozen && this.components == null) {
                this.components = components;
            }
            return new ArrayList<Object>(components);
        }

        @Override
        public void releaseTarget(Object target) throws Exception {
        }

        private Collection<Object> getBeansOfTypeExcept(Class<?> type, Collection<Class<?>> exceptions) {
            return Arrays.stream(this.context.getBeanNamesForType(type, false, this.eagerInit)).filter(it -> !exceptions.contains(this.context.getType((String)it))).map(it -> this.context.getBean((String)it)).collect(Collectors.toList());
        }
    }
}

