/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class TomcatServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    public TomcatServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(TomcatServletWebServerFactory factory2) {
        ServerProperties.Tomcat tomcatProperties = this.serverProperties.getTomcat();
        if (!ObjectUtils.isEmpty(tomcatProperties.getAdditionalTldSkipPatterns())) {
            factory2.getTldSkipPatterns().addAll(tomcatProperties.getAdditionalTldSkipPatterns());
        }
        if (tomcatProperties.getRedirectContextRoot() != null) {
            this.customizeRedirectContextRoot(factory2, tomcatProperties.getRedirectContextRoot());
        }
        this.customizeUseRelativeRedirects(factory2, tomcatProperties.isUseRelativeRedirects());
        factory2.setDisableMBeanRegistry(!tomcatProperties.getMbeanregistry().isEnabled());
    }

    private void customizeRedirectContextRoot(ConfigurableTomcatWebServerFactory factory2, boolean redirectContextRoot) {
        factory2.addContextCustomizers(context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot));
    }

    private void customizeUseRelativeRedirects(ConfigurableTomcatWebServerFactory factory2, boolean useRelativeRedirects) {
        factory2.addContextCustomizers(context -> context.setUseRelativeRedirects(useRelativeRedirects));
    }
}

