/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.WebListenerRegistrar;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.core.Ordered;

public class ServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;
    private final Iterable<WebListenerRegistrar> webListenerRegistrars;

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this(serverProperties, Collections.emptyList());
    }

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties, List<WebListenerRegistrar> webListenerRegistrars) {
        this.serverProperties = serverProperties;
        this.webListenerRegistrars = webListenerRegistrars;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableServletWebServerFactory factory2) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serverProperties::getPort).to(factory2::setPort);
        map.from(this.serverProperties::getAddress).to(factory2::setAddress);
        map.from(this.serverProperties.getServlet()::getContextPath).to(factory2::setContextPath);
        map.from(this.serverProperties.getServlet()::getApplicationDisplayName).to(factory2::setDisplayName);
        map.from(this.serverProperties.getServlet()::isRegisterDefaultServlet).to(factory2::setRegisterDefaultServlet);
        map.from(this.serverProperties.getServlet()::getSession).to(factory2::setSession);
        map.from(this.serverProperties::getSsl).to(factory2::setSsl);
        map.from(this.serverProperties.getServlet()::getJsp).to(factory2::setJsp);
        map.from(this.serverProperties::getCompression).to(factory2::setCompression);
        map.from(this.serverProperties::getHttp2).to(factory2::setHttp2);
        map.from(this.serverProperties::getServerHeader).to(factory2::setServerHeader);
        map.from(this.serverProperties.getServlet()::getContextParameters).to(factory2::setInitParameters);
        map.from(this.serverProperties.getShutdown()).to(factory2::setShutdown);
        for (WebListenerRegistrar registrar : this.webListenerRegistrars) {
            registrar.register(factory2);
        }
    }
}

