/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.jdbc.AbstractDataSourceInitializer;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcSessionDataSourceInitializer
extends AbstractDataSourceInitializer {
    private final JdbcSessionProperties properties;

    public JdbcSessionDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, JdbcSessionProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull((Object)properties, "JdbcSessionProperties must not be null");
        this.properties = properties;
    }

    @Override
    protected DataSourceInitializationMode getMode() {
        return this.properties.getInitializeSchema();
    }

    @Override
    protected String getSchemaLocation() {
        return this.properties.getSchema();
    }

    @Override
    protected String getDatabaseName() {
        String platform = this.properties.getPlatform();
        if (StringUtils.hasText(platform)) {
            return platform;
        }
        return super.getDatabaseName();
    }
}

