/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.Roles;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.EntryMapAdapter;
import org.eclipse.sisu.wire.EntrySetAdapter;

final class PlexusRequirements {
    private final Provider<PlexusBeanLocator> locatorProvider;

    PlexusRequirements(TypeEncounter<?> encounter) {
        this.locatorProvider = encounter.getProvider(PlexusBeanLocator.class);
    }

    public <T> Provider<T> lookup(Requirement requirement, final BeanProperty<T> property) {
        try {
            TypeLiteral<T> expectedType = property.getType();
            TypeLiteral<?> roleType = Roles.roleType(requirement, expectedType);
            Class<T> rawType = expectedType.getRawType();
            String[] hints = Hints.canonicalHints(requirement);
            if (Map.class == rawType) {
                return new RequirementMapProvider(this.locatorProvider, roleType, hints);
            }
            if (List.class == rawType || Collection.class == rawType || Iterable.class == rawType) {
                return new RequirementListProvider(this.locatorProvider, roleType, hints);
            }
            if (Set.class == rawType) {
                return new RequirementSetProvider(this.locatorProvider, roleType, hints);
            }
            return new RequirementProvider(this.locatorProvider, roleType, hints);
        }
        catch (RuntimeException e) {
            return new Provider<T>(){

                @Override
                public T get() {
                    throw new ProvisionException("Error in requirement: " + property, e);
                }
            };
        }
    }

    private static abstract class AbstractRequirementProvider<S, T>
    implements Provider<S> {
        private final Provider<PlexusBeanLocator> locatorProvider;
        final TypeLiteral<T> type;
        private final String[] hints;

        AbstractRequirementProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            this.locatorProvider = locatorProvider;
            this.type = type;
            this.hints = hints;
        }

        final Iterable<? extends Map.Entry<String, T>> locate() {
            return this.locatorProvider.get().locate(this.type, this.hints);
        }
    }

    private static final class RequirementListProvider<T>
    extends AbstractRequirementProvider<List<T>, T> {
        RequirementListProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        @Override
        public List<T> get() {
            return new EntryListAdapter(this.locate());
        }
    }

    private static final class RequirementMapProvider<T>
    extends AbstractRequirementProvider<Map<String, T>, T> {
        RequirementMapProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        @Override
        public Map<String, T> get() {
            return new EntryMapAdapter(this.locate());
        }
    }

    private static final class RequirementProvider<T>
    extends AbstractRequirementProvider<T, T> {
        RequirementProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        @Override
        public T get() {
            Iterator i2 = this.locate().iterator();
            if (i2.hasNext()) {
                return i2.next().getValue();
            }
            return Roles.throwMissingComponentException(this.type, null);
        }
    }

    private static final class RequirementSetProvider<T>
    extends AbstractRequirementProvider<Set<T>, T> {
        RequirementSetProvider(Provider<PlexusBeanLocator> locatorProvider, TypeLiteral<T> type, String[] hints) {
            super(locatorProvider, type, hints);
        }

        @Override
        public Set<T> get() {
            return new EntrySetAdapter(this.locate());
        }
    }
}

