/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.bean.DeclaredMembers;

public final class CompositeBeanHelper {
    private static final Type[] NO_TYPES = new Type[0];
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    public CompositeBeanHelper(ConverterLookup lookup, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    public void setDefault(Object bean, Object defaultValue, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Type[] paramTypeHolder;
        Class<?> beanType = bean.getClass();
        Method setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set");
        if (setter == null) {
            throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + beanType);
        }
        Object value = defaultValue;
        TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
        if (!paramType.getRawType().isInstance(value)) {
            if (configuration.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
            }
            value = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration);
        }
        if (value != null) {
            try {
                if (this.listener != null) {
                    this.listener.notifyFieldChangeUsingSetter("", value, bean);
                }
                setter.invoke(bean, value);
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
    }

    public void setProperty(Object bean, String propertyName, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        String reason;
        Field field;
        Throwable problem;
        Method setter;
        Class<?> beanType;
        block20: {
            String title;
            Type[] paramTypeHolder;
            beanType = bean.getClass();
            setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set" + (title = String.valueOf(Character.toTitleCase(propertyName.charAt(0))) + propertyName.substring(1)));
            if (setter == null) {
                setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder, "add" + title);
            }
            problem = null;
            Object value = null;
            if (setter != null) {
                try {
                    TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
                    Class<?> rawPropertyType = paramType.getRawType();
                    if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                        rawPropertyType = valueType;
                    }
                    if ((value = this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration)) != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingSetter(propertyName, value, bean);
                        }
                        setter.invoke(bean, value);
                        return;
                    }
                }
                catch (Exception e) {
                    problem = e;
                }
                catch (LinkageError e) {
                    problem = e;
                }
            }
            if ((field = CompositeBeanHelper.findField(beanType, propertyName)) != null) {
                try {
                    TypeLiteral<?> fieldType = TypeLiteral.get(field.getGenericType());
                    Class<?> rawPropertyType = fieldType.getRawType();
                    if (!rawPropertyType.isInstance(value)) {
                        if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                            rawPropertyType = valueType;
                        }
                        value = this.convertProperty(beanType, rawPropertyType, fieldType.getType(), configuration);
                    }
                    if (value != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingReflection(propertyName, value, bean);
                        }
                        CompositeBeanHelper.setField(bean, field, value);
                        return;
                    }
                }
                catch (Exception e) {
                    if (problem == null) {
                        problem = e;
                    }
                }
                catch (LinkageError e) {
                    if (problem != null) break block20;
                    problem = e;
                }
            }
        }
        if (problem instanceof ComponentConfigurationException) {
            throw (ComponentConfigurationException)problem;
        }
        if (problem != null) {
            reason = "Cannot set '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason, problem);
        }
        if (setter == null && field == null) {
            reason = "Cannot find '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] propertyTypeArgs = CompositeBeanHelper.getTypeArguments(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, propertyTypeArgs, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Type[] getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            int i2 = 0;
            while (i2 < typeArguments.length) {
                typeArguments[i2] = CompositeBeanHelper.expandType(typeArguments[i2]);
                ++i2;
            }
            return typeArguments;
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{CompositeBeanHelper.expandType(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    private static Type expandType(Type type) {
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }

    private static Method findMethod(Class<?> beanType, Type[] paramTypeHolder, String methodName) {
        Method[] methodArray = beanType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] paramTypes;
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && !Modifier.isStatic(m.getModifiers()) && (paramTypes = m.getGenericParameterTypes()).length == 1) {
                paramTypeHolder[0] = paramTypes[0];
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static Field findField(Class<?> beanType, String fieldName) {
        for (Member f : new DeclaredMembers(beanType, DeclaredMembers.View.FIELDS)) {
            if (!fieldName.equals(f.getName()) || Modifier.isStatic(f.getModifiers())) continue;
            return (Field)f;
        }
        return null;
    }

    private static void setField(Object bean, final Field field, Object value) throws Exception {
        if (!field.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
        field.set(bean, value);
    }
}

