/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transform.FileTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultInstaller
implements Installer,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInstaller.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;

    public DefaultInstaller() {
    }

    @Inject
    DefaultInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultInstaller addMetadataGeneratorFactory(MetadataGeneratorFactory factory2) {
        this.metadataFactories.add(Objects.requireNonNull(factory2, "metadata generator factory cannot be null"));
        return this;
    }

    public DefaultInstaller setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultInstaller setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session, false);){
            InstallResult installResult = this.install(syncContext, session, request);
            return installResult;
        }
    }

    private InstallResult install(SyncContext syncContext, RepositorySystemSession session, InstallRequest request) throws InstallationException {
        InstallResult result = new InstallResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
        IdentityHashMap processedMetadata = new IdentityHashMap();
        List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
        syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
        for (Metadata metadata : metadatas) {
            this.install(session, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        for (int i2 = 0; i2 < artifacts.size(); ++i2) {
            Artifact artifact = (Artifact)artifacts.get(i2);
            for (MetadataGenerator metadataGenerator : generators) {
                artifact = metadataGenerator.transformArtifact(artifact);
            }
            artifacts.set(i2, artifact);
            this.install(session, trace, artifact);
            result.addArtifact(artifact);
        }
        metadatas = Utils.finishMetadata(generators, artifacts);
        syncContext.acquire(null, metadatas);
        for (Metadata metadata : metadatas) {
            this.install(session, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        for (Metadata metadata : request.getMetadata()) {
            if (processedMetadata.containsKey(metadata)) continue;
            this.install(session, trace, metadata);
            result.addMetadata(metadata);
        }
        return result;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, InstallRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory2 : factories.getEnabled()) {
            MetadataGenerator generator = factory2.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File srcFile = artifact.getFile();
        Collection<FileTransformer> fileTransformers = session.getFileTransformerManager().getTransformersForArtifact(artifact);
        if (fileTransformers.isEmpty()) {
            this.install(session, trace, artifact, lrm, srcFile, null);
        } else {
            for (FileTransformer fileTransformer : fileTransformers) {
                this.install(session, trace, artifact, lrm, srcFile, fileTransformer);
            }
        }
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Artifact artifact, LocalRepositoryManager lrm, File srcFile, FileTransformer fileTransformer) throws InstallationException {
        Artifact targetArtifact = fileTransformer != null ? fileTransformer.transformArtifact(artifact) : artifact;
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(targetArtifact));
        this.artifactInstalling(session, trace, targetArtifact, dstFile);
        Exception exception = null;
        try {
            boolean copy;
            if (dstFile.equals(srcFile)) {
                throw new IllegalStateException("cannot install " + dstFile + " to same path");
            }
            boolean bl = copy = "pom".equals(targetArtifact.getExtension()) || srcFile.lastModified() != dstFile.lastModified() || srcFile.length() != dstFile.length() || !srcFile.exists();
            if (!copy) {
                LOGGER.debug("Skipped re-installing {} to {}, seems unchanged", (Object)srcFile, (Object)dstFile);
            } else if (fileTransformer != null) {
                try (InputStream is = fileTransformer.transformData(srcFile);){
                    this.fileProcessor.write(dstFile, is);
                    dstFile.setLastModified(srcFile.lastModified());
                }
            } else {
                this.fileProcessor.copy(srcFile, dstFile);
                dstFile.setLastModified(srcFile.lastModified());
            }
            lrm.add(session, new LocalArtifactRegistration(targetArtifact));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install artifact " + targetArtifact + ": " + e.getMessage(), e);
        }
        finally {
            this.artifactInstalled(session, trace, targetArtifact, dstFile, exception);
        }
    }

    private void install(RepositorySystemSession session, RequestTrace trace, Metadata metadata) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalMetadata(metadata));
        this.metadataInstalling(session, trace, metadata, dstFile);
        Exception exception = null;
        try {
            if (metadata instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            } else {
                if (dstFile.equals(metadata.getFile())) {
                    throw new IllegalStateException("cannot install " + dstFile + " to same path");
                }
                this.fileProcessor.copy(metadata.getFile(), dstFile);
            }
            lrm.add(session, new LocalMetadataRegistration(metadata));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install metadata " + metadata + ": " + e.getMessage(), e);
        }
        finally {
            this.metadataInstalled(session, trace, metadata, dstFile, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session, RequestTrace trace, Artifact artifact, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactInstalled(RepositorySystemSession session, RequestTrace trace, Artifact artifact, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_INSTALLED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalling(RepositorySystemSession session, RequestTrace trace, Metadata metadata, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalled(RepositorySystemSession session, RequestTrace trace, Metadata metadata, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INSTALLED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

