/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration;

import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class PlexusConfigurationMerger {
    public static PlexusConfiguration merge(PlexusConfiguration user, PlexusConfiguration system) {
        PlexusConfiguration logging;
        PlexusConfiguration[] configurationsDirectories;
        PlexusConfiguration systemProperties;
        XmlPlexusConfiguration mergedConfiguration = new XmlPlexusConfiguration("plexus");
        PlexusConfiguration loadOnStart = user.getChild("load-on-start");
        if (loadOnStart.getChildCount() != 0) {
            mergedConfiguration.addChild(loadOnStart);
        }
        if ((systemProperties = user.getChild("system-properties")).getChildCount() != 0) {
            mergedConfiguration.addChild(systemProperties);
        }
        if ((configurationsDirectories = user.getChildren("configurations-directory")).length != 0) {
            for (int i2 = 0; i2 < configurationsDirectories.length; ++i2) {
                mergedConfiguration.addChild(configurationsDirectories[i2]);
            }
        }
        if ((logging = user.getChild("logging")).getChildCount() != 0) {
            mergedConfiguration.addChild(logging);
        } else {
            mergedConfiguration.addChild(system.getChild("logging"));
        }
        PlexusConfiguration componentRepository = user.getChild("component-repository");
        if (componentRepository.getChildCount() != 0) {
            mergedConfiguration.addChild(componentRepository);
        } else {
            mergedConfiguration.addChild(system.getChild("component-repository"));
        }
        PlexusConfigurationMerger.copyResources(system, mergedConfiguration);
        PlexusConfigurationMerger.copyResources(user, mergedConfiguration);
        mergedConfiguration.addChild(system.getChild("component-manager-manager"));
        PlexusConfiguration componentDiscovererManager = user.getChild("component-discoverer-manager");
        if (componentDiscovererManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentDiscovererManager);
            PlexusConfigurationMerger.copyComponentDiscoverers(system.getChild("component-discoverer-manager"), componentDiscovererManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-discoverer-manager"));
        }
        PlexusConfiguration componentFactoryManager = user.getChild("component-factory-manager");
        if (componentFactoryManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentFactoryManager);
            PlexusConfigurationMerger.copyComponentFactories(system.getChild("component-factory-manager"), componentFactoryManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-factory-manager"));
        }
        PlexusConfiguration lifecycleHandlerManager = user.getChild("lifecycle-handler-manager");
        if (lifecycleHandlerManager.getChildCount() != 0) {
            mergedConfiguration.addChild(lifecycleHandlerManager);
            PlexusConfigurationMerger.copyLifecycles(system.getChild("lifecycle-handler-manager"), lifecycleHandlerManager);
        } else {
            mergedConfiguration.addChild(system.getChild("lifecycle-handler-manager"));
        }
        PlexusConfiguration componentComposerManager = user.getChild("component-composer-manager");
        if (componentComposerManager.getChildCount() != 0) {
            mergedConfiguration.addChild(componentComposerManager);
            PlexusConfigurationMerger.copyComponentComposers(system.getChild("component-composer-manager"), componentComposerManager);
        } else {
            mergedConfiguration.addChild(system.getChild("component-composer-manager"));
        }
        PlexusConfiguration components = system.getChild("components");
        mergedConfiguration.addChild(components);
        PlexusConfigurationMerger.copyComponents(user.getChild("components"), components);
        return mergedConfiguration;
    }

    private static void copyResources(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source2.getChild("resources").getChildren();
        XmlPlexusConfiguration dest = (XmlPlexusConfiguration)destination.getChild("resources");
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            dest.addChild(handlers[i2]);
        }
    }

    private static void copyComponentDiscoverers(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source2.getChild("component-discoverers").getChildren("component-discoverer");
        XmlPlexusConfiguration dest = (XmlPlexusConfiguration)destination.getChild("component-discoverers");
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            dest.addChild(handlers[i2]);
        }
    }

    private static void copyComponentFactories(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source2.getChild("component-factories").getChildren("component-factory");
        XmlPlexusConfiguration dest = (XmlPlexusConfiguration)destination.getChild("component-factories");
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            dest.addChild(handlers[i2]);
        }
    }

    private static void copyComponentComposers(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] composers = source2.getChild("component-composers").getChildren("component-composer");
        XmlPlexusConfiguration dest = (XmlPlexusConfiguration)destination.getChild("component-composers");
        for (int i2 = 0; i2 < composers.length; ++i2) {
            dest.addChild(composers[i2]);
        }
    }

    private static void copyLifecycles(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] handlers = source2.getChild("lifecycle-handlers").getChildren("lifecycle-handler");
        XmlPlexusConfiguration dest = (XmlPlexusConfiguration)destination.getChild("lifecycle-handlers");
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            dest.addChild(handlers[i2]);
        }
    }

    private static void copyComponents(PlexusConfiguration source2, PlexusConfiguration destination) {
        PlexusConfiguration[] components = source2.getChildren("component");
        for (int i2 = 0; i2 < components.length; ++i2) {
            destination.addChild(components[i2]);
        }
    }
}

