/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentImplementationNotFoundException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private PlexusConfiguration configuration;
    private Map componentDescriptorMaps;
    private Map componentDescriptors = new HashMap();
    private CompositionResolver compositionResolver;
    private ClassRealm classRealm;

    public DefaultComponentRepository() {
        this.componentDescriptorMaps = new HashMap();
    }

    protected PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean hasComponent(String role) {
        return this.componentDescriptors.containsKey(role);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.componentDescriptors.containsKey(role + roleHint);
    }

    public Map getComponentDescriptorMap(String role) {
        return (Map)this.componentDescriptorMaps.get(role);
    }

    public ComponentDescriptor getComponentDescriptor(String key) {
        return (ComponentDescriptor)this.componentDescriptors.get(key);
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public void configure(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize() throws ComponentRepositoryException {
        this.initializeComponentDescriptors();
    }

    public void initializeComponentDescriptors() throws ComponentRepositoryException {
        this.initializeComponentDescriptorsFromUserConfiguration();
    }

    private void initializeComponentDescriptorsFromUserConfiguration() throws ComponentRepositoryException {
        PlexusConfiguration[] componentConfigurations = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        for (int i2 = 0; i2 < componentConfigurations.length; ++i2) {
            this.addComponentDescriptor(componentConfigurations[i2]);
        }
    }

    public void addComponentDescriptor(PlexusConfiguration configuration) throws ComponentRepositoryException {
        ComponentDescriptor componentDescriptor = null;
        try {
            componentDescriptor = PlexusTools.buildComponentDescriptor(configuration);
        }
        catch (PlexusConfigurationException e) {
            throw new ComponentRepositoryException("Cannot unmarshall component descriptor:", e);
        }
        this.addComponentDescriptor(componentDescriptor);
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        try {
            this.validateComponentDescriptor(componentDescriptor);
        }
        catch (ComponentImplementationNotFoundException e) {
            throw new ComponentRepositoryException("Component descriptor validation failed: ", e);
        }
        String role = componentDescriptor.getRole();
        String roleHint = componentDescriptor.getRoleHint();
        if (roleHint != null) {
            ComponentDescriptor desc;
            if (this.componentDescriptors.containsKey(role) && (desc = (ComponentDescriptor)this.componentDescriptors.get(role)).getRoleHint() == null) {
                String message = "Component descriptor " + componentDescriptor.getHumanReadableKey() + " has a hint, but there are other implementations that don't";
                throw new ComponentRepositoryException(message);
            }
            HashMap<String, ComponentDescriptor> map = (HashMap<String, ComponentDescriptor>)this.componentDescriptorMaps.get(role);
            if (map == null) {
                map = new HashMap<String, ComponentDescriptor>();
                this.componentDescriptorMaps.put(role, map);
            }
            map.put(roleHint, componentDescriptor);
        } else {
            if (this.componentDescriptorMaps.containsKey(role)) {
                String message = "Component descriptor " + componentDescriptor.getHumanReadableKey() + " has no hint, but there are other implementations that do";
                throw new ComponentRepositoryException(message);
            }
            if (this.componentDescriptors.containsKey(role) && !this.componentDescriptors.get(role).equals(componentDescriptor)) {
                String message = "Component role " + role + " is already in the repository and different to attempted addition of " + componentDescriptor.getHumanReadableKey();
                throw new ComponentRepositoryException(message);
            }
        }
        try {
            this.compositionResolver.addComponentDescriptor(componentDescriptor);
        }
        catch (CompositionException e) {
            throw new ComponentRepositoryException(e.getMessage(), e);
        }
        this.componentDescriptors.put(componentDescriptor.getComponentKey(), componentDescriptor);
        if (!this.componentDescriptors.containsKey(role)) {
            this.componentDescriptors.put(role, componentDescriptor);
        }
    }

    public void validateComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentImplementationNotFoundException {
    }

    public List getComponentDependencies(ComponentDescriptor componentDescriptor) {
        return this.compositionResolver.getRequirements(componentDescriptor.getComponentKey());
    }
}

