/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class PlexusXmlComponentDiscoverer
implements ComponentDiscoverer {
    private static final String PLEXUS_XML_RESOURCE = "META-INF/plexus/plexus.xml";
    private ComponentDiscovererManager manager;

    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }

    public List findComponents(Context context, ClassRealm classRealm) throws PlexusConfigurationException {
        PlexusConfiguration configuration = this.discoverConfiguration(context, classRealm);
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(configuration, classRealm);
        componentSetDescriptors.add(componentSetDescriptor);
        ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
        this.manager.fireComponentDiscoveryEvent(event);
        return componentSetDescriptors;
    }

    public PlexusConfiguration discoverConfiguration(Context context, ClassRealm classRealm) throws PlexusConfigurationException {
        PlexusConfiguration configuration = null;
        Enumeration resources2 = null;
        try {
            resources2 = classRealm.findResources(PLEXUS_XML_RESOURCE);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Error retrieving configuration resources: META-INF/plexus/plexus.xml from class realm: " + classRealm.getId(), e);
        }
        Enumeration e = resources2;
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(url.openStream());
                ContextMapAdapter contextAdapter = new ContextMapAdapter(context);
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, contextAdapter);
                PlexusConfiguration discoveredConfig = PlexusTools.buildConfiguration(url.toExternalForm(), interpolationFilterReader);
                configuration = configuration == null ? discoveredConfig : PlexusConfigurationMerger.merge(configuration, discoveredConfig);
            }
            catch (IOException ex) {
                try {
                    throw new PlexusConfigurationException("Error reading configuration from: " + url.toExternalForm(), ex);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close(reader);
        }
        return configuration;
    }

    private ComponentSetDescriptor createComponentDescriptors(PlexusConfiguration configuration, ClassRealm classRealm) throws PlexusConfigurationException {
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        if (configuration != null) {
            ArrayList componentDescriptors = new ArrayList();
            PlexusConfiguration[] componentConfigurations = configuration.getChild("components").getChildren("component");
            for (int i2 = 0; i2 < componentConfigurations.length; ++i2) {
                PlexusConfiguration componentConfiguration = componentConfigurations[i2];
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration);
                }
                catch (PlexusConfigurationException e) {
                    throw new PlexusConfigurationException("Cannot build component descriptor from resource found in:\n" + Arrays.asList(classRealm.getConstituents()), e);
                }
                componentDescriptor.setComponentType("plexus");
                componentDescriptors.add(componentDescriptor);
            }
            componentSetDescriptor.setComponents(componentDescriptors);
        }
        return componentSetDescriptor;
    }
}

