/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.validation;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.StringUtils;

public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    public ModelValidationResult validate(Model model) {
        Reporting reporting;
        Build build;
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, model.getModelVersion());
        this.validateId("groupId", result, model.getGroupId());
        this.validateId("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, model.getPackaging());
        this.validateStringNotEmpty("version", result, model.getVersion());
        Iterator<Dependency> it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency d = it.next();
            this.validateId("dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateId("dependencies.dependency.groupId", result, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", result, d.getType());
            this.validateStringNotEmpty("dependencies.dependency.version", result, d.getVersion());
            if ("system".equals(d.getScope()) && StringUtils.isEmpty(d.getSystemPath())) {
                result.addMessage("For dependency " + d + ": system-scoped dependency must specify systemPath.");
                continue;
            }
            if ("system".equals(d.getScope()) || !StringUtils.isNotEmpty(d.getSystemPath())) continue;
            result.addMessage("For dependency " + d + ": only dependency with system scope can specify systemPath.");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            Iterator<Dependency> it2 = mgmt.getDependencies().iterator();
            while (it2.hasNext()) {
                Dependency d = it2.next();
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", result, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", result, d.getGroupId());
                if ("system".equals(d.getScope()) && StringUtils.isEmpty(d.getSystemPath())) {
                    result.addMessage("For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                    continue;
                }
                if ("system".equals(d.getScope()) || !StringUtils.isNotEmpty(d.getSystemPath())) continue;
                result.addMessage("For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
        }
        if ((build = model.getBuild()) != null) {
            Resource r;
            Iterator<InputLocationTracker> it3 = build.getPlugins().iterator();
            while (it3.hasNext()) {
                Plugin p = it3.next();
                this.validateStringNotEmpty("build.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("build.plugins.plugin.groupId", result, p.getGroupId());
            }
            it3 = build.getResources().iterator();
            while (it3.hasNext()) {
                r = (Resource)it3.next();
                this.validateStringNotEmpty("build.resources.resource.directory", result, r.getDirectory());
            }
            it3 = build.getTestResources().iterator();
            while (it3.hasNext()) {
                r = (Resource)it3.next();
                this.validateStringNotEmpty("build.testResources.testResource.directory", result, r.getDirectory());
            }
        }
        if ((reporting = model.getReporting()) != null) {
            Iterator<ReportPlugin> it4 = reporting.getPlugins().iterator();
            while (it4.hasNext()) {
                ReportPlugin p = it4.next();
                this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("reporting.plugins.plugin.groupId", result, p.getGroupId());
            }
        }
        this.validateRepositories(result, model.getRepositories(), "repositories.repository");
        this.validateRepositories(result, model.getPluginRepositories(), "pluginRepositories.pluginRepository");
        this.forcePluginExecutionIdCollision(model, result);
        return result;
    }

    private boolean validateId(String fieldName, ModelValidationResult result, String id) {
        if (!this.validateStringNotEmpty(fieldName, result, id)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            result.addMessage("'" + fieldName + "' with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateRepositories(ModelValidationResult result, List repositories, String prefix) {
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            Repository repository = (Repository)it.next();
            this.validateStringNotEmpty(prefix + ".id", result, repository.getId());
            this.validateStringNotEmpty(prefix + ".url", result, repository.getUrl());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelValidationResult result) {
        List<Plugin> plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Iterator<Plugin> it = plugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = it.next();
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    result.addMessage(collisionException.getMessage());
                }
            }
        }
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string) {
        if (!this.validateNotNull(fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelValidationResult result, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }
}

