/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecycleMojo;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=LifeCyclePluginAnalyzer.class)
public class DefaultLifecyclePluginAnalyzer
implements LifeCyclePluginAnalyzer {
    @Requirement(role=LifecycleMapping.class)
    private Map<String, LifecycleMapping> lifecycleMappings;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        LifecycleMapping lifecycleMappingForPackaging;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up lifecycle mappings for packaging " + packaging + " from " + Thread.currentThread().getContextClassLoader());
        }
        if ((lifecycleMappingForPackaging = this.lifecycleMappings.get(packaging)) == null) {
            return null;
        }
        LinkedHashMap<Plugin, Plugin> plugins = new LinkedHashMap<Plugin, Plugin>();
        for (Lifecycle lifecycle : this.getOrderedLifecycles()) {
            org.apache.maven.lifecycle.mapping.Lifecycle lifecycleConfiguration = lifecycleMappingForPackaging.getLifecycles().get(lifecycle.getId());
            Map<String, LifecyclePhase> phaseToGoalMapping = null;
            if (lifecycleConfiguration != null) {
                phaseToGoalMapping = lifecycleConfiguration.getLifecyclePhases();
            } else if (lifecycle.getDefaultLifecyclePhases() != null) {
                phaseToGoalMapping = lifecycle.getDefaultLifecyclePhases();
            }
            if (phaseToGoalMapping == null) continue;
            for (Map.Entry<String, LifecyclePhase> goalsForLifecyclePhase : phaseToGoalMapping.entrySet()) {
                String phase = goalsForLifecyclePhase.getKey();
                LifecyclePhase goals = goalsForLifecyclePhase.getValue();
                if (goals == null) continue;
                this.parseLifecyclePhaseDefinitions(plugins, phase, goals);
            }
        }
        return plugins.keySet();
    }

    private List<Lifecycle> getOrderedLifecycles() {
        ArrayList<Lifecycle> lifecycles = new ArrayList<Lifecycle>(this.defaultLifeCycles.getLifeCycles());
        Collections.sort(lifecycles, new Comparator<Lifecycle>(){

            @Override
            public int compare(Lifecycle l1, Lifecycle l2) {
                return l1.getId().compareTo(l2.getId());
            }
        });
        return lifecycles;
    }

    private void parseLifecyclePhaseDefinitions(Map<Plugin, Plugin> plugins, String phase, LifecyclePhase goals) {
        String modelId = "org.apache.maven:maven-core:" + this.getClass().getPackage().getImplementationVersion() + ":default-lifecycle-bindings";
        InputSource inputSource = new InputSource();
        inputSource.setModelId(modelId);
        InputLocation location = new InputLocation(-1, -1, inputSource);
        location.setLocation(0, location);
        List<LifecycleMojo> mojos = goals.getMojos();
        if (mojos != null) {
            for (int i2 = 0; i2 < mojos.size(); ++i2) {
                LifecycleMojo mojo = mojos.get(i2);
                GoalSpec gs = this.parseGoalSpec(mojo.getGoal());
                if (gs == null) {
                    this.logger.warn("Ignored invalid goal specification '" + mojo.getGoal() + "' from lifecycle mapping for phase " + phase);
                    continue;
                }
                Plugin plugin = new Plugin();
                plugin.setGroupId(gs.groupId);
                plugin.setArtifactId(gs.artifactId);
                plugin.setVersion(gs.version);
                plugin.setLocation("", location);
                plugin.setLocation("groupId", location);
                plugin.setLocation("artifactId", location);
                plugin.setLocation("version", location);
                Plugin existing = plugins.get(plugin);
                if (existing != null) {
                    if (existing.getVersion() == null) {
                        existing.setVersion(plugin.getVersion());
                        existing.setLocation("version", location);
                    }
                    plugin = existing;
                } else {
                    plugins.put(plugin, plugin);
                }
                PluginExecution execution = new PluginExecution();
                execution.setId(this.getExecutionId(plugin, gs.goal));
                execution.setPhase(phase);
                execution.setPriority(i2 - mojos.size());
                execution.getGoals().add(gs.goal);
                execution.setLocation("", location);
                execution.setLocation("id", location);
                execution.setLocation("phase", location);
                execution.setLocation("goals", location);
                Xpp3Dom lifecycleConfiguration = mojo.getConfiguration();
                if (lifecycleConfiguration != null) {
                    execution.setConfiguration(new Xpp3Dom(lifecycleConfiguration));
                }
                plugin.setDependencies(mojo.getDependencies());
                plugin.getExecutions().add(execution);
            }
        }
    }

    private GoalSpec parseGoalSpec(String goalSpec) {
        GoalSpec gs = new GoalSpec();
        String[] p = StringUtils.split(goalSpec.trim(), ":");
        if (p.length == 3) {
            gs.groupId = p[0];
            gs.artifactId = p[1];
            gs.goal = p[2];
        } else if (p.length == 4) {
            gs.groupId = p[0];
            gs.artifactId = p[1];
            gs.version = p[2];
            gs.goal = p[3];
        } else {
            gs = null;
        }
        return gs;
    }

    private String getExecutionId(Plugin plugin, String goal) {
        String base;
        HashSet<String> existingIds = new HashSet<String>();
        for (PluginExecution execution : plugin.getExecutions()) {
            existingIds.add(execution.getId());
        }
        String id = base = "default-" + goal;
        int index = 1;
        while (existingIds.contains(id)) {
            id = base + '-' + index;
            ++index;
        }
        return id;
    }

    static class GoalSpec {
        String groupId;
        String artifactId;
        String version;
        String goal;

        GoalSpec() {
        }
    }
}

