/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    private RepositoryMetadataManager repositoryMetadataManager;

    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source2 = new File(basedir, finalName + "." + extension);
        this.deploy(source2, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source2, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        if (!this.wagonManager.isOnline()) {
            throw new ArtifactDeploymentException("System is offline. Cannot deploy artifact: " + artifact + ".");
        }
        try {
            this.transformationManager.transformForDeployment(artifact, deploymentRepository, localRepository);
            File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            if (!artifactFile.equals(source2)) {
                FileUtils.copyFile(source2, artifactFile);
            }
            this.wagonManager.putArtifact(source2, artifact, deploymentRepository);
            Iterator i2 = artifact.getMetadataList().iterator();
            while (i2.hasNext()) {
                ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                this.repositoryMetadataManager.deploy(metadata, localRepository, deploymentRepository);
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataDeploymentException e) {
            throw new ArtifactDeploymentException("Error installing artifact's metadata: " + e.getMessage(), e);
        }
    }
}

