/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static boolean isSnapshot(String version2) {
        return version2 != null && (version2.toUpperCase().endsWith("SNAPSHOT") || Artifact.VERSION_FILE_PATTERN.matcher(version2).matches());
    }

    public static String versionlessKey(Artifact artifact) {
        return ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
    }

    public static String versionlessKey(String groupId, String artifactId) {
        if (groupId == null) {
            throw new NullPointerException("groupId was null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId was null");
        }
        return groupId + ":" + artifactId;
    }

    public static String artifactId(String groupId, String artifactId, String type, String version2) {
        return ArtifactUtils.artifactId(groupId, artifactId, type, null, version2);
    }

    public static String artifactId(String groupId, String artifactId, String type, String classifier, String baseVersion) {
        return groupId + ":" + artifactId + ":" + type + (classifier != null ? ":" + classifier : "") + ":" + baseVersion;
    }

    public static Map artifactMapByVersionlessId(Collection artifacts) {
        HashMap<String, Artifact> artifactMap = new HashMap<String, Artifact>();
        if (artifacts != null) {
            Iterator it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                artifactMap.put(ArtifactUtils.versionlessKey(artifact), artifact);
            }
        }
        return artifactMap;
    }

    public static Map artifactMapByArtifactId(Collection artifacts) {
        HashMap<String, Artifact> artifactMap = new HashMap<String, Artifact>();
        if (artifacts != null) {
            Iterator it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                artifactMap.put(artifact.getId(), artifact);
            }
        }
        return artifactMap;
    }
}

