/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms.naming;

import com.tibco.tibjms.naming.TibjmsContext;
import com.tibco.tibjms.naming.TibjmsNamingConstants;
import com.tibco.tibjms.naming.TibjmsNamingEnvUtil;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class TibjmsURLContext
implements Context,
TibjmsNamingConstants {
    private static final String USERINFO_SEPARATOR = ":";
    protected Hashtable environment = new Hashtable();
    protected Context root = null;
    private String scheme = null;

    public TibjmsURLContext() {
        this(null);
    }

    public TibjmsURLContext(Hashtable hashtable) {
        if (hashtable != null) {
            this.environment.putAll(hashtable);
        }
        this.setScheme("tibjmsnaming:");
    }

    protected void setScheme(String string) {
        this.scheme = string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Environment variables must be named");
        }
        this.environment.put(string, object);
        return object;
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable(this.environment);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        Object v = this.environment.remove(string);
        return v;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String string = (String)this.environment.get("java.naming.provider.url");
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("tibjmsnaming://");
        Object var3_3 = null;
        var3_3 = this.environment.get("com.tibco.tibjms.naming.security.principal");
        if (var3_3 != null) {
            stringBuffer.append((Object)var3_3).append(USERINFO_SEPARATOR);
            var3_3 = this.environment.get("com.tibco.tibjms.naming.security.credentials");
            stringBuffer.append((Object)var3_3).append("@");
        } else {
            var3_3 = this.environment.get("java.naming.security.principal");
            if (var3_3 != null) {
                stringBuffer.append((Object)var3_3).append(USERINFO_SEPARATOR);
                var3_3 = this.environment.get("java.naming.security.credentials");
                stringBuffer.append((Object)var3_3).append("@");
            }
        }
        var3_3 = this.environment.get("com.tibco.tibjms.naming.server");
        if (var3_3 != null) {
            stringBuffer.append((Object)var3_3);
        } else {
            stringBuffer.append("localhost");
        }
        var3_3 = this.environment.get("com.tibco.tibjms.naming.port");
        if (var3_3 != null) {
            stringBuffer.append(USERINFO_SEPARATOR).append((Object)var3_3);
        } else {
            stringBuffer.append(":7222");
        }
        return stringBuffer.toString();
    }

    @Override
    public Object lookup(String string) throws NamingException {
        if (string == null || string.length() < 1) {
            return this;
        }
        if (!string.startsWith(this.scheme)) {
            if (this.root == null) {
                this.root = new TibjmsContext("", this.environment);
            }
            return this.root.lookup(string);
        }
        String string2 = this.parseURLintoEnvironment(string);
        if (this.root == null) {
            this.root = new TibjmsContext("", this.environment, true);
        }
        return this.root.lookup(string2);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            return this;
        }
        return this.lookup(name.toString());
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void close() throws NamingException {
        if (this.root != null) {
            this.root.close();
        }
    }

    private String parseURLintoEnvironment(String string) throws NamingException {
        return TibjmsNamingEnvUtil.parseURL(string, this.environment, true);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException("Name composition is not supported for the " + this.scheme + " scheme");
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException("Name composition is not supported for the " + this.scheme + " scheme");
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        throw new UnsupportedOperationException("Name parsing is not supported for the " + this.scheme + " scheme");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException("Name parsing is not supported for the " + this.scheme + " scheme");
    }

    public NamingEnumeration list(String string) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Contexts may not be explicitly added");
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException("Contexts may not be explicitly added");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException("Contexts may not be explicitly removed");
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new UnsupportedOperationException("Contexts may not be explicitly removed");
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void unbind(String string) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException("Not supported");
    }
}

