/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms.naming;

import com.tibco.tibjms.naming.TibjmsNamingConstants;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;

class TibjmsNamingEnvUtil
implements TibjmsNamingConstants {
    private static final int STATE_SCHEME = 1;
    private static final int STATE_USER = 2;
    private static final int STATE_PASSWORD = 3;
    private static final int STATE_SERVER = 4;
    private static final int STATE_PROTOCOL = 5;
    private static final int STATE_PORT = 6;
    private static final int STATE_CONTEXT = 7;

    private TibjmsNamingEnvUtil() {
    }

    private static String _parseURL(String string, Hashtable hashtable, boolean bl) throws NamingException {
        String string2;
        if (string == null || string.length() < 1) {
            return null;
        }
        int n = 1;
        boolean bl2 = false;
        String string3 = string2 = bl ? TibjmsNamingEnvUtil.mungeURL(string) : string;
        if (bl && !string2.equals(string)) {
            hashtable.put("java.naming.provider.url", string2);
        }
        int n2 = -1;
        block11: while (!bl2) {
            switch (n) {
                case 1: {
                    if (string2.startsWith("tibjmsnaming://")) {
                        string2 = string2.substring("tibjmsnaming://".length());
                        n = 2;
                        continue block11;
                    }
                    throw new InvalidNameException("Supplied URL (" + string + ") is not a valid tibjmsnaming URL");
                }
                case 2: {
                    int n3;
                    n2 = string2.indexOf("@");
                    if (n2 >= 0) {
                        n = 3;
                        n3 = string2.indexOf("/");
                        if (n3 >= 0 && n3 < n2) {
                            hashtable.put("com.tibco.tibjms.naming.security.principal", string2.substring(0, n3));
                            string2 = string2.substring(n3 + 1);
                            continue block11;
                        }
                        hashtable.put("com.tibco.tibjms.naming.security.principal", string2.substring(0, n2));
                        string2 = string2.substring(n2 + 1);
                        n = 4;
                        continue block11;
                    }
                    n = 4;
                    continue block11;
                }
                case 3: {
                    n2 = string2.indexOf("@");
                    if (n2 < 0) {
                        string2 = null;
                        bl2 = true;
                        continue block11;
                    }
                    if (n2 > 0) {
                        hashtable.put("com.tibco.tibjms.naming.security.credentials", string2.substring(0, n2));
                    }
                    string2 = string2.substring(n2 + 1);
                    n = 4;
                    continue block11;
                }
                case 4: {
                    int n3 = string2.indexOf(91);
                    if (n3 != -1) {
                        int n4 = string2.indexOf(93);
                        if (n4 > n3 + 2) {
                            hashtable.put("com.tibco.tibjms.naming.server", string2.substring(n3, n4 + 1));
                            string2 = string2.substring(n4 + 1);
                        }
                    } else {
                        n2 = string2.indexOf(":");
                        if (n2 >= 0) {
                            if (n2 > 0) {
                                hashtable.put("com.tibco.tibjms.naming.server", string2.substring(0, n2));
                            }
                            string2 = string2.substring(n2);
                        } else {
                            n2 = string2.indexOf("/");
                            if (n2 >= 0) {
                                if (n2 > 0) {
                                    hashtable.put("com.tibco.tibjms.naming.server", string2.substring(0, n2));
                                }
                                string2 = string2.substring(n2);
                            } else {
                                if (string2.length() > 0) {
                                    hashtable.put("com.tibco.tibjms.naming.server", string2);
                                }
                                bl2 = true;
                                string2 = null;
                            }
                        }
                    }
                    n = 5;
                    continue block11;
                }
                case 5: {
                    n = 6;
                    continue block11;
                }
                case 6: {
                    if (string2 != null && string2.length() > 0 && string2.startsWith(":")) {
                        String string4 = string2.substring(1);
                        if (string4.indexOf("/") >= 0) {
                            string4 = string4.substring(0, string4.indexOf("/"));
                        }
                        if (string4.length() > 0) {
                            try {
                                int n5 = Integer.valueOf(string4);
                                if (n5 < 0 || n5 > 65535) {
                                    throw new NumberFormatException("Invalid port number");
                                }
                                hashtable.put("com.tibco.tibjms.naming.port", "" + n5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new InvalidNameException("Supplied URL (" + string + ") contains an invalid port number: " + numberFormatException.getMessage());
                            }
                        }
                        string2 = string2.indexOf("/") > 0 ? string2.substring(string2.indexOf("/")) : string2.substring(string4.length() + 1);
                    }
                    n = 7;
                    continue block11;
                }
                case 7: {
                    if (string2 == null || string2.length() < 1) {
                        bl2 = true;
                        continue block11;
                    }
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    bl2 = true;
                    continue block11;
                }
            }
            bl2 = true;
        }
        return string2;
    }

    static String parseInitialEnvironment(Hashtable hashtable) throws NamingException {
        return TibjmsNamingEnvUtil.parseURL((String)hashtable.get("java.naming.provider.url"), hashtable, true);
    }

    static String parseEnvironment(Hashtable hashtable) throws NamingException {
        return TibjmsNamingEnvUtil.parseURL((String)hashtable.get("java.naming.provider.url"), hashtable);
    }

    static String parseURL(String string, Hashtable hashtable) throws NamingException {
        return TibjmsNamingEnvUtil.parseURL(string, hashtable, false);
    }

    static String parseURL(String string, Hashtable hashtable, boolean bl) throws NamingException {
        if (string == null || string.length() < 1) {
            return null;
        }
        int n = string.indexOf(",");
        if (n < 0) {
            return TibjmsNamingEnvUtil._parseURL(string, hashtable, bl);
        }
        String string2 = string.substring(0, n);
        String string3 = TibjmsNamingEnvUtil._parseURL(string2, hashtable, bl);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            String string5 = bl ? TibjmsNamingEnvUtil.mungeURL(string4) : string4;
            vector.add(string5);
        }
        hashtable.put("com.tibco.tibjms.naming.url.list", vector);
        return string3;
    }

    static String getServer(Hashtable hashtable) {
        String string = (String)hashtable.get("com.tibco.tibjms.naming.server");
        if (string == null || string.length() < 1) {
            return null;
        }
        return string;
    }

    static int getPort(Hashtable hashtable, String string) {
        String string2;
        int n = 7222;
        if (string != null && string.equals("ssl")) {
            n = 7243;
        }
        if ((string2 = (String)hashtable.get("com.tibco.tibjms.naming.port")) == null || string2.length() < 1) {
            return n;
        }
        try {
            int n2 = Integer.valueOf(string2);
            if (n2 > 0 && n2 < 65535) {
                return n2;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    static String getProtocol(Hashtable hashtable) {
        throw new UnsupportedOperationException("Only tcp is currently supported");
    }

    static String getUsername(Hashtable hashtable) {
        String string = (String)hashtable.get("com.tibco.tibjms.naming.security.principal");
        if (string != null && string.length() > 0) {
            return string;
        }
        string = (String)hashtable.get("java.naming.security.principal");
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    static String getPassword(Hashtable hashtable) {
        String string = (String)hashtable.get("com.tibco.tibjms.naming.security.credentials");
        if (string != null && string.length() > 0) {
            return string;
        }
        string = (String)hashtable.get("java.naming.security.credentials");
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    static Vector getUrlList(Hashtable hashtable) throws ConfigurationException {
        Vector<String> vector = null;
        Object v = hashtable.get("com.tibco.tibjms.naming.url.list");
        if (v == null || v instanceof Vector) {
            vector = (Vector<String>)v;
        } else if (v instanceof String) {
            String string = (String)v;
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken().trim());
            }
        } else {
            throw new ConfigurationException("The property com.tibco.tibjms.naming.url.list accepts only a Vector or a String");
        }
        return vector;
    }

    static String getReferenceURLBase(Hashtable hashtable) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer("tibjmsnaming://");
        stringBuffer.append(TibjmsNamingEnvUtil.getServer(hashtable));
        stringBuffer.append(":");
        stringBuffer.append(TibjmsNamingEnvUtil.getPort(hashtable, null));
        return stringBuffer.toString();
    }

    private static String mungeURL(String string) {
        String string2 = "tibjmsnaming://";
        if (string == null || string.length() < 1) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string;
        }
        int n = string.indexOf("//");
        if (n < 0) {
            return string2 + string;
        }
        if (string.startsWith("tcp://") || string.startsWith("ssl://")) {
            return string2 + string.substring("tcp://".length());
        }
        return string;
    }
}

