/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms.naming;

import com.tibco.tibjms.TibjmsConnectionFactory;
import com.tibco.tibjms.TibjmsMapMessage;
import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import com.tibco.tibjms.TibjmsTopicConnectionFactory;
import com.tibco.tibjms.TibjmsXAConnectionFactory;
import com.tibco.tibjms.TibjmsXAQueueConnectionFactory;
import com.tibco.tibjms.TibjmsXATopicConnectionFactory;
import com.tibco.tibjms.naming.TibjmsConnectionFactoryAttributes;
import com.tibco.tibjms.naming.TibjmsNameParser;
import com.tibco.tibjms.naming.TibjmsNamingConstants;
import com.tibco.tibjms.naming.TibjmsNamingEnvUtil;
import com.tibco.tibjms.naming.TibjmsQueueName;
import com.tibco.tibjms.naming.TibjmsTopicName;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.AuthenticationException;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.CompoundName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class TibjmsContext
implements Context,
Referenceable {
    public static final String PROPERTY_URL_LIST = "com.tibco.tibjms.naming.url.list";
    public static final String SECURITY_PROTOCOL = "com.tibco.tibjms.naming.security_protocol";
    public static final String SSL_VENDOR = "com.tibco.tibjms.naming.ssl_vendor";
    public static final String SSL_TRACE = "com.tibco.tibjms.naming.ssl_trace";
    public static final String SSL_DEBUG_TRACE = "com.tibco.tibjms.naming.ssl_debug_trace";
    public static final String SSL_ENABLE_VERIFY_HOST = "com.tibco.tibjms.naming.ssl_enable_verify_host";
    public static final String SSL_ENABLE_VERIFY_HOST_NAME = "com.tibco.tibjms.naming.ssl_enable_verify_hostname";
    public static final String SSL_EXPECTED_HOST_NAME = "com.tibco.tibjms.naming.ssl_expected_hostname";
    public static final String SSL_AUTH_ONLY = "com.tibco.tibjms.naming.ssl_auth_only";
    public static final String SSL_TRUSTED_CERTIFICATES = "com.tibco.tibjms.naming.ssl_trusted_certs";
    public static final String SSL_HOST_NAME_VERIFIER = "com.tibco.tibjms.naming.ssl_hostname_verifier";
    public static final String SSL_IDENTITY = "com.tibco.tibjms.naming.ssl_identity";
    public static final String SSL_IDENTITY_ENCODING = "com.tibco.tibjms.naming.ssl_identity_encoding";
    public static final String SSL_ISSUER_CERTIFICATES = "com.tibco.tibjms.naming.ssl_issuer_certs";
    public static final String SSL_PRIVATE_KEY = "com.tibco.tibjms.naming.ssl_private_key";
    public static final String SSL_PRIVATE_KEY_ENCODING = "com.tibco.tibjms.naming.ssl_private_key_encoding";
    public static final String SSL_PASSWORD = "com.tibco.tibjms.naming.ssl_password";
    public static final String SSL_CIPHER_SUITES = "com.tibco.tibjms.naming.ssl_cipher_suites";
    private static final String _NAMING_SSL_PREFIX = "com.tibco.tibjms.naming.ssl_";
    private static final String _TIBJMS_SSL_PREFIX = "com.tibco.tibjms.ssl.";
    private Hashtable environment = null;
    private CompoundName contextName = null;
    private boolean parsed = false;
    private Messenger messenger = null;
    static final int _ADMIN_GET_JNDI_OBJECT = 1;

    private void _translateSSL(Map map, Map map2) {
        for (Object k : map.keySet()) {
            String string;
            if (k == null || !(k instanceof String) || (string = (String)k).length() <= _NAMING_SSL_PREFIX.length() || !string.startsWith(_NAMING_SSL_PREFIX)) continue;
            int n = _NAMING_SSL_PREFIX.length();
            String string2 = _TIBJMS_SSL_PREFIX + string.substring(n);
            map2.put(string2, map.get(string));
        }
    }

    TibjmsContext(String string, Hashtable hashtable, boolean bl) throws NamingException {
        if (hashtable == null) {
            throw new IllegalStateException("The JNDI environment is not initialized.");
        }
        this.contextName = (CompoundName)this.getNameParser("").parse(string);
        this.environment = new Hashtable(hashtable);
        this.parsed = bl;
    }

    TibjmsContext(String string, Hashtable hashtable) throws NamingException {
        this(string, hashtable, false);
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.contextName != null && this.contextName.toString().length() > 0) {
            return new Reference(this.getClass().getName(), new StringRefAddr("URL", TibjmsNamingEnvUtil.getReferenceURLBase(this.environment) + "/" + this.contextName.toString()));
        }
        return new Reference(this.getClass().getName(), new StringRefAddr("URL", TibjmsNamingEnvUtil.getReferenceURLBase(this.environment)));
    }

    @Override
    public synchronized Object addToEnvironment(String string, Object object) throws NamingException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Environment variables must be named");
        }
        Object v = this.environment.get(string);
        this.environment.put(string, object);
        if (string.equals("java.naming.provider.url")) {
            if (this.messenger != null) {
                this.messenger.close();
            }
            this.messenger = null;
            TibjmsNamingEnvUtil.parseEnvironment(this.environment);
        } else if (string.equals("java.naming.security.principal") || string.equals("java.naming.security.credentials") || string.equals(SECURITY_PROTOCOL) || string.startsWith(_NAMING_SSL_PREFIX) || string.startsWith(_TIBJMS_SSL_PREFIX)) {
            if (this.messenger != null) {
                this.messenger.close();
            }
            this.messenger = null;
        }
        return v;
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable(this.environment);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.remove(string);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (name2 == null) {
            return name;
        }
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        if (string2 == null) {
            return string;
        }
        Name name = this.composeName(this.getNameParser("").parse(string), this.getNameParser("").parse(string2));
        return name.toString();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.contextName.toString();
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        TibjmsNameParser tibjmsNameParser = new TibjmsNameParser();
        tibjmsNameParser.parse(string);
        return tibjmsNameParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(this.getNameParser("").parse(string));
    }

    @Override
    public Object lookup(String string) throws NamingException {
        NameParser nameParser = this.getNameParser("");
        Name name = nameParser.parse(string);
        return this.lookup(name);
    }

    @Override
    public synchronized Object lookup(Name name) throws NamingException {
        Object object;
        Object object2;
        Object object3 = null;
        if (name == null || name.isEmpty()) {
            return new TibjmsContext(this.contextName.toString(), this.environment);
        }
        if (!(name instanceof CompoundName)) {
            throw new InvalidNameException("Only support CompoundName names");
        }
        CompoundName compoundName = (CompoundName)name;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.environment != null) {
            hashtable.putAll(this.environment);
        }
        if (!this.parsed) {
            TibjmsNamingEnvUtil.parseEnvironment(hashtable);
        }
        String string = (String)hashtable.get("java.naming.factory.object");
        boolean bl = false;
        if (string == null || string.length() < 1) {
            string = "com.tibco.tibjms.naming.tibjmsnaming.tibjmsnamingURLContextFactory:com.tibco.tibjms.naming.TibjmsObjectFactory";
            bl = true;
        } else {
            if (string.indexOf("com.tibco.tibjms.naming.TibjmsObjectFactory") == -1) {
                string = string + ":com.tibco.tibjms.naming.TibjmsObjectFactory";
                bl = true;
            }
            if (string.indexOf("com.tibco.tibjms.naming.tibjmsnaming.tibjmsnamingURLContextFactory") == -1) {
                string = string + ":com.tibco.tibjms.naming.tibjmsnaming.tibjmsnamingURLContextFactory";
                bl = true;
            }
        }
        if (bl) {
            hashtable.put("java.naming.factory.object", string);
        }
        int n = 0;
        String string2 = compoundName.toString();
        Enumeration<String> enumeration = compoundName.getAll();
        if (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (((String)object2).equals("$topics")) {
                n = 1;
            } else if (((String)object2).equals("$queues")) {
                n = 2;
            } else if (((String)object2).equals("$factories")) {
                n = 4;
            }
        }
        if (n != 0) {
            if (!enumeration.hasMoreElements()) {
                throw new InvalidNameException("Invalid name: '" + compoundName + "'");
            }
            string2 = enumeration.nextElement();
        } else {
            string2 = compoundName.get(0);
        }
        object3 = null;
        if (object3 == null) {
            Object object4;
            Cloneable cloneable;
            Object object5;
            object2 = null;
            object = null;
            try {
                if (this.messenger == null) {
                    int n2;
                    CharSequence charSequence;
                    object5 = new HashMap();
                    String string3 = this.setupProtocol((Map)object5);
                    cloneable = TibjmsNamingEnvUtil.getUrlList(this.environment);
                    if (cloneable == null) {
                        charSequence = TibjmsNamingEnvUtil.getServer(this.environment);
                        n2 = TibjmsNamingEnvUtil.getPort(this.environment, string3);
                        if (charSequence == null) {
                            throw new ConfigurationException("Server name is missing from provider URL of naming service");
                        }
                        object4 = string3 + "://" + (String)charSequence + ":" + n2;
                    } else {
                        charSequence = new StringBuffer();
                        n2 = 0;
                        enumeration = cloneable.elements();
                        while (enumeration.hasMoreElements()) {
                            if (n2 > 0) {
                                ((StringBuffer)charSequence).append(", ");
                            }
                            String string4 = enumeration.nextElement();
                            String string5 = null;
                            int n3 = string4.indexOf("//");
                            string5 = n3 < 0 ? string3 + "://" + string4 : string3 + "://" + string4.substring(n3 + 2);
                            ((StringBuffer)charSequence).append(string5);
                            ++n2;
                        }
                        object4 = ((StringBuffer)charSequence).toString();
                    }
                    charSequence = TibjmsNamingEnvUtil.getUsername(this.environment);
                    String string6 = TibjmsNamingEnvUtil.getPassword(this.environment);
                    this.messenger = new Messenger((String)object4, (String)charSequence, string6, (Map)object5);
                }
                object = this.messenger.request(n, string2);
                object5 = this.messenger.getSuccessfulURL();
                TibjmsNamingEnvUtil.parseURL((String)object5, hashtable, true);
                this.messenger.close();
            }
            catch (JMSException jMSException) {
                NamingException namingException = null;
                namingException = jMSException instanceof JMSSecurityException ? new AuthenticationException("Not permitted: " + jMSException.getMessage()) : new ServiceUnavailableException("Failed to query JNDI: " + jMSException.getMessage());
                namingException.setRootCause(jMSException);
                throw namingException;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            finally {
                if (this.messenger != null) {
                    this.messenger.close();
                }
            }
            if (object == null) {
                throw new ServiceUnavailableException("Server did not respond to JNDI request");
            }
            if (!(object instanceof MapMessage)) {
                throw new CommunicationException("Malformed server response, wrong message type");
            }
            object2 = (MapMessage)object;
            try {
                object5 = null;
                if (!object2.propertyExists("status")) {
                    throw new CommunicationException("Malformed server response");
                }
                int n4 = object2.getIntProperty("status");
                if (n4 != 0) {
                    if (n4 == 35) {
                        throw new NameNotFoundException("Name not found: '" + compoundName.toString() + "'");
                    }
                    if (n4 == 1) {
                        throw new CannotProceedException("Name '" + compoundName.toString() + "' is ambiguous: both a topic and a queue exist");
                    }
                    object4 = object2.getStringProperty("err");
                    if (object4 == null) {
                        object4 = "Malformed server response";
                    }
                    throw new ConfigurationException((String)object4);
                }
                n = -1;
                if (object2.itemExists("at")) {
                    n = object2.getInt("at");
                }
                if (n != 1 && n != 2 && n != 4) {
                    throw new CommunicationException("Malformed server response");
                }
                object5 = string2;
                object4 = object2.getObject("obj");
                if (object4 == null || !(object4 instanceof TibjmsMapMessage)) {
                    throw new CommunicationException("Malformed server response");
                }
                cloneable = (TibjmsMapMessage)object4;
                switch (n) {
                    case 1: 
                    case 2: {
                        object3 = this._msgToDest((String)object5, (MapMessage)((Object)cloneable));
                        break;
                    }
                    case 4: {
                        if (object5 == null || ((String)object5).length() == 0) {
                            throw new CommunicationException("Malformed server response");
                        }
                        object3 = this._msgToFactory((String)object5, (MapMessage)((Object)cloneable));
                        break;
                    }
                    default: {
                        throw new CommunicationException("Malformed server response");
                    }
                }
            }
            catch (JMSException jMSException) {
                throw new CommunicationException("Malformed server response");
            }
        }
        if (object3 == null) {
            throw new CommunicationException("Malformed server response");
        }
        try {
            return NamingManager.getObjectInstance(object3, null, null, hashtable);
        }
        catch (Exception exception) {
            object = new NamingException(exception.getMessage());
            ((NamingException)object).setRootCause(exception);
            throw object;
        }
    }

    private Object _msgToDest(String string, MapMessage mapMessage) throws NamingException {
        int n = 0;
        String string2 = null;
        try {
            n = mapMessage.getInt("dt");
            string2 = mapMessage.getString("dn");
            if (string2 == null || string2.length() == 0) {
                throw new CommunicationException("Malformed server response");
            }
            if (n == 2) {
                return new TibjmsTopicName(string2, string);
            }
            if (n == 1) {
                return new TibjmsQueueName(string2, string);
            }
            throw new CommunicationException("Malformed server response");
        }
        catch (JMSException jMSException) {
            throw new CommunicationException("Malformed server response");
        }
    }

    private Object _msgToFactory(String string, MapMessage mapMessage) throws NamingException {
        Object object = null;
        int n = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        HashMap<String, Object> hashMap = null;
        try {
            int n2;
            int n3;
            byte[] byArray;
            MapMessage mapMessage2;
            int n4;
            int n5;
            Object object2;
            MapMessage mapMessage3;
            n = mapMessage.getInt("ft");
            if (mapMessage.itemExists("xa")) {
                bl = mapMessage.getBoolean("xa");
            }
            string2 = mapMessage.getString("url");
            string3 = mapMessage.getString("cid");
            if (string2 == null || string2.length() == 0) {
                string2 = "tcp://localhost:7222";
            }
            hashMap = new HashMap<String, Object>();
            object = mapMessage.getObject("metric");
            if (object != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.factory.metric", object);
            }
            if ((object = mapMessage.getObject("sslvdr")) != null && object instanceof String) {
                hashMap.put("com.tibco.tibjms.ssl.vendor", object);
            }
            if ((object = mapMessage.getObject("ssltr")) != null && object instanceof Boolean) {
                hashMap.put("com.tibco.tibjms.ssl.trace", object);
            }
            if ((object = mapMessage.getObject("sslau")) != null && object instanceof Boolean) {
                hashMap.put("com.tibco.tibjms.ssl.auth_only", object);
            }
            if ((object = mapMessage.getObject("sslver")) != null && object instanceof Boolean) {
                hashMap.put("com.tibco.tibjms.ssl.enable_verify_host", object);
            }
            if ((object = mapMessage.getObject("sslverhn")) != null && object instanceof Boolean) {
                hashMap.put("com.tibco.tibjms.ssl.enable_verify_hostname", object);
            }
            if ((object = mapMessage.getObject("sslexphn")) != null && object instanceof String) {
                hashMap.put("com.tibco.tibjms.ssl.expected_hostname", object);
            }
            if ((object = mapMessage.getObject("ssliden")) != null && object instanceof MapMessage) {
                mapMessage3 = (MapMessage)object;
                object2 = mapMessage3.getBytes("data");
                n5 = mapMessage3.getInt("type");
                hashMap.put("com.tibco.tibjms.ssl.identity", object2);
                hashMap.put("com.tibco.tibjms.ssl.identity_encoding", new Integer(n5));
            }
            if ((object = mapMessage.getObject("sslpk")) != null && object instanceof MapMessage) {
                mapMessage3 = (MapMessage)object;
                object2 = mapMessage3.getBytes("data");
                n5 = mapMessage3.getInt("type");
                hashMap.put("com.tibco.tibjms.ssl.private_key", object2);
                hashMap.put("com.tibco.tibjms.ssl.private_key_encoding", new Integer(n5));
            }
            if ((object = mapMessage.getObject("nssltrst")) != null && object instanceof Number && (n4 = ((Number)object).intValue()) > 0) {
                object2 = new Vector();
                for (n5 = 0; n5 < n4; ++n5) {
                    object = mapMessage.getObject("ssltrst" + n5);
                    if (object == null || !(object instanceof MapMessage)) {
                        throw new CommunicationException("Malformed server response");
                    }
                    mapMessage2 = (MapMessage)object;
                    byArray = mapMessage2.getBytes("data");
                    n3 = mapMessage2.getInt("type");
                    ((Vector)object2).addElement(new Integer(n3));
                    ((Vector)object2).addElement(byArray);
                }
                hashMap.put("com.tibco.tibjms.ssl.trusted_certs", object2);
            }
            if ((object = mapMessage.getObject("nssliss")) != null && object instanceof Number && (n2 = ((Number)object).intValue()) > 0) {
                object2 = new Vector();
                for (n5 = 0; n5 < n2; ++n5) {
                    object = mapMessage.getObject("ssltrst" + n5);
                    if (object == null || !(object instanceof MapMessage)) {
                        throw new CommunicationException("Malformed server response");
                    }
                    mapMessage2 = (MapMessage)object;
                    byArray = mapMessage2.getBytes("data");
                    n3 = mapMessage2.getInt("type");
                    ((Vector)object2).addElement(new Integer(n3));
                    ((Vector)object2).addElement(byArray);
                }
                hashMap.put("com.tibco.tibjms.ssl.issuer_certs", object2);
            }
            if ((object = mapMessage.getObject("sslcip")) != null && object instanceof String) {
                hashMap.put("com.tibco.tibjms.ssl.cipher_suites", object);
            }
            if ((object = mapMessage.getObject("conatt")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.connect.attemptcount", object);
            }
            if ((object = mapMessage.getObject("condly")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.connect.attemptdelay", object);
            }
            if ((object = mapMessage.getObject("contmout")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.connect.attempttimeout", object);
            }
            if ((object = mapMessage.getObject("reconatt")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.reconnect.attemptcount", object);
            }
            if ((object = mapMessage.getObject("recondly")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.reconnect.attemptdelay", object);
            }
            if ((object = mapMessage.getObject("recontmout")) != null && object instanceof Integer) {
                hashMap.put("com.tibco.tibjms.reconnect.attempttimeout", object);
            }
            if ((object = mapMessage.getObject("mc")) != null && object instanceof Boolean) {
                hashMap.put("com.tibco.tibjms.multicast.enabled", object);
            }
            if ((object = mapMessage.getObject("mcd")) != null && object instanceof String) {
                hashMap.put("com.tibco.tibjms.multicast.daemon", object);
            }
            if (hashMap.size() == 0) {
                hashMap = null;
            }
            Class clazz = null;
            if (n == 0) {
                clazz = bl ? TibjmsXAConnectionFactory.class : TibjmsConnectionFactory.class;
            } else if (n == 2) {
                clazz = bl ? TibjmsXATopicConnectionFactory.class : TibjmsTopicConnectionFactory.class;
            } else if (n == 1) {
                clazz = bl ? TibjmsXAQueueConnectionFactory.class : TibjmsQueueConnectionFactory.class;
            } else {
                throw new CommunicationException("Malformed server response");
            }
            return new TibjmsConnectionFactoryAttributes(clazz, string, string2, string3, hashMap);
        }
        catch (JMSException jMSException) {
            throw new CommunicationException("Malformed server response");
        }
    }

    private String setupProtocol(Map map) throws JMSSecurityException, JMSException {
        String string = (String)this.environment.get(SECURITY_PROTOCOL);
        if (string == null) {
            return "tcp";
        }
        if (!string.trim().equals("ssl")) {
            return "tcp";
        }
        this._translateSSL(this.environment, map);
        return "ssl";
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void close() throws NamingException {
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Contexts may not be explicitly added");
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Contexts may not be explicitly added");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Contexts may not be explicitly removed");
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Contexts may not be explicitly removed");
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Not supported");
    }

    class Messenger
    implements TibjmsNamingConstants {
        private static final String _TIBJMS_JNDI_QUEUE = "$sys.lookup";
        private TibjmsQueueConnectionFactory qFactory = null;
        private String username = null;
        private String password = null;
        private QueueConnection connection = null;
        private QueueSession session = null;
        private Queue jndiQueue = null;
        private QueueSender sender = null;
        private Queue replyTo = null;
        private QueueReceiver receiver = null;
        private long messageTimeout = 30000L;

        Messenger(String string, String string2, String string3, Map map) throws JMSException, NamingException {
            this.qFactory = new TibjmsQueueConnectionFactory(string, null, map);
            this.username = string2;
            this.password = string3;
        }

        Message request(int n, String string) throws JMSException {
            if (this.connection == null) {
                this.connection = this.qFactory.createQueueConnection(this.username, this.password);
                this.session = this.connection.createQueueSession(false, 1);
                this.jndiQueue = this.session.createQueue(_TIBJMS_JNDI_QUEUE);
                this.sender = this.session.createSender(this.jndiQueue);
                this.sender.setDeliveryMode(1);
                this.replyTo = this.session.createTemporaryQueue();
                this.receiver = this.session.createReceiver(this.replyTo);
                this.connection.start();
            }
            MapMessage mapMessage = this.session.createMapMessage();
            mapMessage.setJMSReplyTo(this.replyTo);
            mapMessage.setIntProperty("code", 1);
            mapMessage.setInt("type", n);
            mapMessage.setString("name", string);
            this.sender.send(mapMessage);
            Message message = this.receiver.receive(this.messageTimeout * 2L);
            if (message == null) {
                return null;
            }
            return message;
        }

        void close() {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        String getSuccessfulURL() {
            String string = this.qFactory._getCurrentUrl();
            int n = string.indexOf(",");
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }
    }
}

